/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class TournamentSchedulerService {
    private static Logger log = Logger.getLogger((String)TournamentSchedulerService.class.getName());
    private String tournamentSchedulerUrl = "";
    private String interfaceUrl = "faces/serverInterface.jsp";
    private String propertiesUrl = "faces/properties.jsp";
    private int gameId = 0;

    public int getGameId() {
        return this.gameId;
    }

    public void setGameId(int gameId) {
        this.gameId = gameId;
    }

    public String getTournamentSchedulerUrl() {
        return this.tournamentSchedulerUrl;
    }

    public void setTournamentSchedulerUrl(String tournamentSchedulerUrl) {
        this.tournamentSchedulerUrl = tournamentSchedulerUrl;
    }

    public URL getBootUrl() {
        URL result = null;
        String urlString = this.tournamentSchedulerUrl + this.interfaceUrl + "?action=boot" + "&gameId=" + this.gameId;
        try {
            result = new URL(urlString);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Bad URL: " + urlString));
            e.printStackTrace();
        }
        return result;
    }

    public URL getConfigUrl() {
        URL result = null;
        String urlString = this.tournamentSchedulerUrl + this.propertiesUrl + "?gameId=" + this.gameId;
        try {
            result = new URL(urlString);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Bad URL: " + urlString));
            e.printStackTrace();
        }
        return result;
    }

    public void ready() {
        if (this.tournamentSchedulerUrl.isEmpty()) {
            return;
        }
        String finalUrl = this.tournamentSchedulerUrl + this.interfaceUrl + "?action=status" + "&gameId=" + this.gameId + "&status=game_ready";
        log.info((Object)("Sending game_ready to controller at: " + finalUrl));
        try {
            URL url = new URL(finalUrl);
            URLConnection conn = url.openConnection();
            InputStream input = conn.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Jenkins failure");
        }
    }

    public void inProgress() {
        if (this.tournamentSchedulerUrl.isEmpty()) {
            return;
        }
        String finalUrl = this.tournamentSchedulerUrl + this.interfaceUrl + "?action=status" + "&gameId=" + this.gameId + "&status=game_in_progress";
        log.info((Object)("Sending game_in_progress message to controller at: " + finalUrl));
        try {
            URL url = new URL(finalUrl);
            URLConnection conn = url.openConnection();
            InputStream input = conn.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Jenkins failure");
        }
    }
}

