/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.Timeslot;
import org.powertac.common.WeatherForecast;
import org.powertac.common.WeatherForecastPrediction;
import org.powertac.common.WeatherReport;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.exceptions.PowerTacException;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.repo.WeatherForecastRepo;
import org.powertac.common.repo.WeatherReportRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeatherService
extends TimeslotPhaseProcessor
implements InitializationService {
    private static Logger log = Logger.getLogger((String)WeatherService.class.getName());
    private boolean requestFailed = false;
    private XStream xstream;
    private Timeslot currentTime;
    @ConfigurableValue(valueType="Integer", description="Timeslot interval to make requests")
    private int weatherReqInterval = 12;
    private int currentWeatherId = 1;
    @ConfigurableValue(valueType="String", description="Location of weather data to be reported")
    private String weatherLocation = "minneapolis";
    @ConfigurableValue(valueType="String", description="Location of weather server rest url")
    private String serverUrl = "http://tac05.cs.umn.edu:8080/WeatherServer/faces/index.xhtml";
    @ConfigurableValue(valueType="Boolean", description="If network calls to weather server should block until finished")
    private boolean blocking = true;
    @ConfigurableValue(valueType="Integer", description="Length of forecasts (in hours)")
    private int forecastHorizon = 24;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private WeatherReportRepo weatherReportRepo;
    @Autowired
    private WeatherForecastRepo weatherForecastRepo;
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private ServerConfiguration serverProps;

    public int getWeatherReqInterval() {
        return this.weatherReqInterval;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public int getForecastHorizon() {
        return this.forecastHorizon;
    }

    public void activate(Instant time, int phaseNumber) {
        long msec;
        if (this.getWeatherReqInterval() > 24) {
            this.weatherReqInterval = 24;
        }
        if ((msec = time.getMillis()) % ((long)this.getWeatherReqInterval() * 3600000L) == 0L) {
            log.info((Object)("Timeslot " + this.timeslotRepo.currentTimeslot().getId() + " WeatherService reports time to make network request for weather data in blocking = " + this.isBlocking() + " mode."));
            try {
                this.webRequest(this.timeslotRepo.currentTimeslot(), 1);
                this.currentWeatherId += 2 * this.getWeatherReqInterval();
                this.requestFailed = false;
            }
            catch (Throwable e) {
                this.requestFailed = true;
            }
        } else {
            log.info((Object)"WeatherService reports not time to grab weather data.");
        }
        WeatherReport report = null;
        try {
            report = this.weatherReportRepo.currentWeatherReport();
        }
        catch (PowerTacException e) {
            log.error((Object)"Weather Service reports Weather Report Repo empty");
        }
        if (report == null) {
            log.error((Object)"null weather-report!");
            this.brokerProxyService.broadcastMessage((Object)new WeatherReport(this.timeslotRepo.currentTimeslot(), 0.0, 0.0, 0.0, 0.0));
        } else {
            this.brokerProxyService.broadcastMessage((Object)report);
        }
        WeatherForecast forecast = null;
        try {
            forecast = this.weatherForecastRepo.currentWeatherForecast();
        }
        catch (PowerTacException e) {
            log.error((Object)"Weather Service reports Weather Forecast Repo emtpy");
        }
        if (forecast == null) {
            log.error((Object)"null weather-forecast!");
            ArrayList<WeatherForecastPrediction> currentPredictions = new ArrayList<WeatherForecastPrediction>();
            for (int j = 1; j <= this.getForecastHorizon(); ++j) {
                currentPredictions.add(new WeatherForecastPrediction(j, 0.0, 0.0, 0.0, 0.0));
            }
            this.brokerProxyService.broadcastMessage((Object)new WeatherForecast(this.timeslotRepo.currentTimeslot(), currentPredictions));
        } else {
            this.brokerProxyService.broadcastMessage((Object)forecast);
        }
    }

    private boolean webRequest(Timeslot time, int randomSeed) {
        this.currentTime = time;
        try {
            int year = this.currentTime.getStartInstant().get(DateTimeFieldType.year());
            int month = this.currentTime.getStartInstant().get(DateTimeFieldType.monthOfYear());
            int day = this.currentTime.getStartInstant().get(DateTimeFieldType.dayOfMonth());
            int hour = this.currentTime.getStartInstant().get(DateTimeFieldType.clockhourOfDay()) - 1;
            String queryDate = String.format("%02d%02d%02d%04d", hour, day, month, year);
            log.info((Object)("Query datetime value for REST call: " + queryDate));
            URL url = new URL(this.getServerUrl() + "?weatherDate=" + queryDate + "&weatherLocation=" + this.weatherLocation);
            URLConnection conn = url.openConnection();
            BufferedReader input = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.xstream = new XStream();
            this.xstream.alias("data", Data.class);
            this.xstream.alias("weatherReport", WeatherReport.class);
            this.xstream.alias("weatherForecast", WeatherForecastPrediction.class);
            this.xstream.useAttributeFor(WeatherReport.class);
            this.xstream.registerConverter((Converter)new WeatherReportConverter());
            this.xstream.useAttributeFor(WeatherForecastPrediction.class);
            this.xstream.registerConverter((Converter)new WeatherForecastConverter());
            Data d = (Data)this.xstream.fromXML((Reader)input);
            for (WeatherReport r : d.getWeatherReports()) {
                this.weatherReportRepo.add(r);
            }
            this.currentTime = time;
            log.info((Object)(d.getWeatherReports().size() + " WeatherReports fetched from xml response."));
            this.weatherReportRepo.runOnce();
            for (int i = 1; i <= 2 * this.getWeatherReqInterval(); ++i) {
                ArrayList<WeatherForecastPrediction> currentPredictions = new ArrayList<WeatherForecastPrediction>();
                int j = 1;
                for (WeatherForecastPrediction f : d.getWeatherForecasts()) {
                    if (f.getId() > (long)i && j <= this.getForecastHorizon()) {
                        currentPredictions.add(new WeatherForecastPrediction(j, f.getTemperature(), f.getWindSpeed(), f.getWindDirection(), f.getCloudCover()));
                    }
                    ++j;
                }
                if (currentPredictions.size() != this.getForecastHorizon()) {
                    log.error((Object)"Forecast horizon does not match the predictions parsed!");
                }
                WeatherForecast newForecast = new WeatherForecast(this.currentTime, currentPredictions);
                this.weatherForecastRepo.add(newForecast);
                if (this.currentTime == null) {
                    log.error((Object)"Null timeslot when adding forecasts to weatherForecastRepo");
                    continue;
                }
                this.currentTime = this.currentTime.getNext();
            }
            log.info((Object)(d.getWeatherForecasts().size() + " WeatherForecasts fetched from xml response."));
            this.weatherForecastRepo.runOnce();
        }
        catch (Exception e) {
            log.error((Object)("Exception Raised during newtork call: " + e.toString()));
            System.out.println("Exception Raised: " + e.toString());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void setDefaults() {
    }

    public String initialize(Competition competition, List<String> completedInits) {
        super.init();
        this.serverProps.configureMe((Object)this);
        return "WeatherService";
    }

    public String getWeatherLocation() {
        return this.weatherLocation;
    }

    public void setWeatherLocation(String weatherLocation) {
        this.weatherLocation = weatherLocation;
    }

    public class Data {
        private List<WeatherReport> weatherReports = new ArrayList<WeatherReport>();
        private List<WeatherForecastPrediction> weatherForecasts = new ArrayList<WeatherForecastPrediction>();
        private List<EnergyReport> energyReports = new ArrayList<EnergyReport>();

        public List<WeatherReport> getWeatherReports() {
            return this.weatherReports;
        }

        public void setWeatherReports(List<WeatherReport> weatherReports) {
            this.weatherReports = weatherReports;
        }

        public List<WeatherForecastPrediction> getWeatherForecasts() {
            return this.weatherForecasts;
        }

        public void setWeatherForecasts(List<WeatherForecastPrediction> weatherForecasts) {
            this.weatherForecasts = weatherForecasts;
        }

        public List<EnergyReport> getEnergyReports() {
            return this.energyReports;
        }

        public void setEnergyReports(List<EnergyReport> energyReports) {
            this.energyReports = energyReports;
        }
    }

    private class EnergyReport {
        private EnergyReport() {
        }
    }

    public class WeatherForecastConverter
    implements Converter {
        public boolean canConvert(Class clazz) {
            return clazz.equals(WeatherForecastPrediction.class);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String Id = reader.getAttribute("id");
            String Date2 = reader.getAttribute("date");
            String Temp = reader.getAttribute("temp");
            String Wind = reader.getAttribute("windspeed");
            String Dir = reader.getAttribute("winddir");
            String CloudCvr = reader.getAttribute("cloudcover");
            String Location2 = reader.getAttribute("location");
            double cvr = 0.0;
            cvr = CloudCvr.equalsIgnoreCase("clr") ? 0.0 : (CloudCvr.equalsIgnoreCase("***") ? 0.0 : (CloudCvr.equalsIgnoreCase("sct") ? 0.375 : (CloudCvr.equalsIgnoreCase("bkn") ? 0.75 : (CloudCvr.equalsIgnoreCase("ovc") ? 1.0 : (CloudCvr.equalsIgnoreCase("obs") ? 1.0 : 1.0)))));
            WeatherForecastPrediction wp = new WeatherForecastPrediction(Integer.parseInt(Id), Double.parseDouble(Temp), Double.parseDouble(Wind), Double.parseDouble(Dir), cvr);
            return wp;
        }
    }

    public class WeatherReportConverter
    implements Converter {
        public boolean canConvert(Class clazz) {
            return clazz.equals(WeatherReport.class);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String Id = reader.getAttribute("id");
            String Date2 = reader.getAttribute("date");
            String Temp = reader.getAttribute("temp");
            String Wind = reader.getAttribute("windspeed");
            String Dir = reader.getAttribute("winddir");
            String CloudCvr = reader.getAttribute("cloudcover");
            String Location2 = reader.getAttribute("location");
            double cvr = 0.0;
            cvr = CloudCvr.equalsIgnoreCase("clr") ? 0.0 : (CloudCvr.equalsIgnoreCase("sct") ? 0.375 : (CloudCvr.equalsIgnoreCase("bkn") ? 0.75 : (CloudCvr.equalsIgnoreCase("ovc") ? 1.0 : (CloudCvr.equalsIgnoreCase("obs") ? 1.0 : 1.0))));
            WeatherReport wr = new WeatherReport(WeatherService.this.currentTime, Double.parseDouble(Temp), Double.parseDouble(Wind), Double.parseDouble(Dir.equalsIgnoreCase("***") ? "0.0" : Dir), cvr);
            WeatherService.this.currentTime = WeatherService.this.currentTime.getNext();
            return wr;
        }
    }
}

