/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.CompetitionControl;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.msg.BrokerAccept;
import org.powertac.common.msg.BrokerAuthentication;
import org.powertac.common.msg.PauseRelease;
import org.powertac.common.msg.PauseRequest;
import org.powertac.common.msg.SimEnd;
import org.powertac.common.msg.SimPause;
import org.powertac.common.msg.SimResume;
import org.powertac.common.msg.SimStart;
import org.powertac.common.msg.TimeslotComplete;
import org.powertac.common.msg.TimeslotUpdate;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.server.JmsManagementService;
import org.powertac.server.LogService;
import org.powertac.server.ServerMessageReceiver;
import org.powertac.server.ServerPropertiesService;
import org.powertac.server.SimulationClockControl;
import org.powertac.server.TournamentSchedulerService;
import org.powertac.server.VisualizerProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompetitionControlService
implements CompetitionControl {
    private static Logger log = Logger.getLogger(CompetitionControlService.class);
    private Competition competition;
    private SimulationClockControl clock;
    @Autowired
    private TimeService timeService;
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    @Autowired
    private LogService logService;
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private ServerPropertiesService configService;
    @Autowired
    private ServerMessageReceiver serverMessageReceiver;
    @Autowired
    private JmsManagementService jmsManagementService;
    @Autowired
    private TournamentSchedulerService tournamentSchedulerService;
    @Autowired
    private VisualizerProxyService visualizerProxyService;
    private String serverQueueName = "serverInput";
    private boolean running = false;
    private int timeslotPhaseCount = 4;
    private ArrayList<List<TimeslotPhaseProcessor>> phaseRegistrations;
    private int timeslotCount = 0;
    private int currentSlot = 0;
    private int bootstrapOffset = 0;
    private RandomSeed randomGen;
    private ArrayList<String> alwaysAuthorizedBrokers;
    private HashMap<String, String> authorizedBrokerMap;
    private int idPrefix = 0;
    @ConfigurableValue(valueType="Integer", description="Maximum time in msec to wait for first broker login")
    private int firstLoginTimeout = 0;
    @ConfigurableValue(valueType="Integer", description="Maximum time in msec to wait for subsequent broker login")
    private int loginTimeout = 0;
    private ArrayList<String> pendingLogins;
    private int loginCount = 0;
    @ConfigurableValue(valueType="Long", description="Milliseconds/timeslot in boot mode. Should be > 300.")
    private long bootstrapTimeslotMillis = 2000L;
    @ConfigurableValue(valueType="String", description="Name of abort file")
    private String abortFileName = "abort";
    private boolean bootstrapMode = true;
    private List<Object> bootstrapDataset = null;
    private boolean simRunning = false;
    String pauseRequester;

    public void init() {
        this.phaseRegistrations = null;
        this.idPrefix = 0;
        this.jmsManagementService.initializeServerQueue(this.serverQueueName);
        this.jmsManagementService.registerMessageListener(this.serverQueueName, this.serverMessageReceiver);
        for (Class messageType : Arrays.asList(BrokerAuthentication.class, PauseRequest.class, PauseRelease.class)) {
            this.brokerProxyService.registerBrokerMessageListener((Object)this, messageType);
        }
    }

    public void setTimeslotPhaseCount(int count) {
        if (count <= 0) {
            log.error((Object)"TimeslotPhaseCount must be >= 0");
        } else {
            this.timeslotPhaseCount = count;
        }
    }

    public void setAlwaysAuthorizedBrokers(List<String> brokerList) {
        this.alwaysAuthorizedBrokers = new ArrayList<String>(brokerList);
    }

    public void setAuthorizedBrokerList(List<String> brokerList) {
        this.loginCount = brokerList.size();
        this.pendingLogins = new ArrayList();
        this.authorizedBrokerMap = new HashMap();
        for (String brokerName : this.alwaysAuthorizedBrokers) {
            this.authorizedBrokerMap.put(brokerName, brokerName);
            log.info((Object)("pre-authorized " + brokerName));
        }
        for (String broker : brokerList) {
            String brokerName;
            String[] components = broker.split("/");
            if (components.length < 1) {
                log.error((Object)("Bad broker spec " + broker));
                continue;
            }
            String queueName = brokerName = components[0];
            if (components.length > 1) {
                queueName = components[1];
            }
            this.authorizedBrokerMap.put(brokerName, queueName);
            log.info((Object)("Authorized broker " + brokerName + " / " + queueName));
            this.pendingLogins.add(brokerName);
        }
    }

    void setBootstrapDataset(List<Object> dataset) {
        this.bootstrapDataset = dataset;
    }

    void setInputQueueName(String queueName) {
        if (null != queueName && !queueName.isEmpty()) {
            this.serverQueueName = queueName;
        }
    }

    public void runOnce(boolean bootstrapMode) {
        this.bootstrapMode = bootstrapMode;
        this.competition = Competition.currentCompetition();
        this.jmsManagementService.start();
        this.init();
        if (this.simRunning) {
            log.warn((Object)"attempt to start sim on top of running sim");
            return;
        }
        this.simRunning = true;
        if (this.competition == null) {
            log.error((Object)"null competition instance");
        }
        this.tournamentSchedulerService.ready();
        if (!this.setup()) {
            this.simRunning = false;
            return;
        }
        this.runSimulation((long)this.competition.getTimeslotLength() * 60000L / this.competition.getSimulationRate());
        this.logBrokerStats();
        this.postBrokerStats();
        this.shutDown();
    }

    private boolean setup() {
        this.randomGen = this.randomSeedRepo.getRandomSeed("CompetitionControlService", this.competition.getId(), "game-setup");
        this.configService.configureMe(this);
        if (!this.bootstrapMode) {
            this.bootstrapOffset = this.competition.getBootstrapTimeslotCount() + this.competition.getBootstrapDiscardedTimeslots();
            this.createInitialTimeslots(this.competition.getSimulationBaseTime(), this.bootstrapOffset + 1, 0);
            log.info((Object)("created " + this.timeslotRepo.count() + " bootstrap timeslots"));
        }
        this.setTimeParameters();
        this.brokerProxyService.setDeferredBroadcast(true);
        if (!this.configurePlugins()) {
            log.error((Object)"failed to configure plugins");
            return false;
        }
        this.createInitialTimeslots(this.timeService.getCurrentTime(), this.competition.getDeactivateTimeslotsAhead(), this.competition.getTimeslotsOpen());
        for (CustomerInfo customer : this.customerRepo.list()) {
            this.competition.addCustomer(customer);
        }
        this.timeslotCount = this.competition.getBootstrapTimeslotCount() + this.competition.getBootstrapDiscardedTimeslots();
        if (!this.bootstrapMode) {
            this.timeslotCount = this.computeGameLength(this.competition.getMinimumTimeslotCount(), this.competition.getExpectedTimeslotCount());
            log.info((Object)("timeslotCount = " + this.timeslotCount));
        }
        this.waitForBrokerLogin();
        this.visualizerProxyService.waitForRemoteViz(this.loginTimeout);
        for (String retailer : this.brokerRepo.findRetailBrokerNames()) {
            this.competition.addBroker(retailer);
        }
        this.tournamentSchedulerService.inProgress(this.timeslotCount);
        this.brokerProxyService.setDeferredBroadcast(false);
        this.brokerProxyService.broadcastMessage((Object)this.competition);
        this.brokerProxyService.broadcastMessage((Object)this.configService.getPublishedConfiguration());
        if (!this.bootstrapMode) {
            this.brokerProxyService.broadcastMessages(this.bootstrapDataset);
        }
        this.brokerProxyService.broadcastDeferredMessages();
        this.brokerProxyService.broadcastMessage((Object)this.makeTimeslotUpdate());
        return true;
    }

    private TimeslotUpdate makeTimeslotUpdate() {
        List enabled = this.timeslotRepo.enabledTimeslots();
        TimeslotUpdate msg = new TimeslotUpdate(this.timeService.getCurrentTime(), ((Timeslot)enabled.get(0)).getSerialNumber(), ((Timeslot)enabled.get(enabled.size() - 1)).getSerialNumber());
        return msg;
    }

    private synchronized void waitForBrokerLogin() {
        if (this.authorizedBrokerMap == null || this.authorizedBrokerMap.size() == 0) {
            return;
        }
        if (log.isInfoEnabled()) {
            StringBuffer msg = new StringBuffer();
            msg.append("waiting for logins from");
            for (String name : this.authorizedBrokerMap.keySet()) {
                msg.append(" ").append(name);
            }
            log.info((Object)msg.toString());
        }
        log.info((Object)("pendingLogins.size()=" + this.pendingLogins.size() + ", loginCount=" + this.loginCount));
        if (this.loginCount == this.pendingLogins.size()) {
            try {
                this.wait(this.firstLoginTimeout);
                log.info((Object)"first login observed");
            }
            catch (InterruptedException ie) {
                this.authorizedBrokerMap.clear();
                log.info((Object)"first login wait is interrupted");
            }
        }
        try {
            for (int sz = this.authorizedBrokerMap.size(); sz >= this.authorizedBrokerMap.size() && this.authorizedBrokerMap.size() > 0; --sz) {
                this.wait(this.loginTimeout);
            }
        }
        catch (InterruptedException ie) {
            this.authorizedBrokerMap.clear();
        }
        if (this.authorizedBrokerMap.size() > 0) {
            log.warn((Object)("Some brokers did not log in: " + this.authorizedBrokerMap));
            this.authorizedBrokerMap.clear();
        }
        if (this.loginCount == this.pendingLogins.size()) {
            this.timeslotCount = 1;
        }
    }

    public synchronized boolean loginBroker(String username) {
        if (this.authorizedBrokerMap == null || this.authorizedBrokerMap.size() == 0 || !this.authorizedBrokerMap.containsKey(username)) {
            log.info((Object)("Unauthorized attempt to log in " + username));
            return false;
        }
        Broker broker = this.brokerRepo.findByUsername(username);
        log.info((Object)("Log in " + (null == broker ? "" : "existing ") + "broker " + username + ", queue " + this.authorizedBrokerMap.get(username)));
        if (null == broker) {
            broker = new Broker(username);
            this.brokerRepo.add(broker);
        }
        broker.setEnabled(true);
        if (!broker.isLocal()) {
            String queueName = this.authorizedBrokerMap.get(username);
            broker.setQueueName(this.authorizedBrokerMap.get(username));
            this.jmsManagementService.createQueue(queueName);
            this.computeBrokerKey(broker);
        }
        this.brokerProxyService.sendMessage(broker, (Object)new BrokerAccept(++this.idPrefix, broker.getKey()));
        this.authorizedBrokerMap.remove(username);
        if (this.pendingLogins.contains(username)) {
            --this.loginCount;
        }
        this.notifyAll();
        return true;
    }

    private void computeBrokerKey(Broker broker) {
        long time = new Date().getTime() & 0xFFFFFFFFFFFFFFFFL;
        int hash = broker.hashCode();
        int code = (int)((long)hash * time & Integer.MAX_VALUE);
        String key = Integer.toString(code, 36);
        log.info((Object)("Broker " + broker.getUsername() + " key: " + key));
        broker.setKey(key);
    }

    private void setTimeParameters() {
        Instant base = this.competition.getSimulationBaseTime();
        long rate = this.competition.getSimulationRate();
        this.currentSlot = 0;
        if (!this.bootstrapMode) {
            int slotCount = this.bootstrapOffset;
            log.info((Object)("first slot: " + slotCount));
            base = base.plus((long)slotCount * this.competition.getTimeslotDuration());
        } else {
            log.info((Object)("bootstrapTimeslotMillis=" + this.bootstrapTimeslotMillis));
            rate = this.competition.getTimeslotDuration() / this.bootstrapTimeslotMillis;
            log.info((Object)("bootstrap mode clock rate: " + rate));
        }
        long rem = rate % (long)this.competition.getTimeslotLength();
        if (rem > 0L) {
            long mult = this.competition.getSimulationRate() / (long)this.competition.getTimeslotLength();
            log.warn((Object)("Simulation rate " + rate + " not a multiple of " + this.competition.getTimeslotLength() + "; adjust to " + (mult + 1L) * (long)this.competition.getTimeslotLength()));
            rate = (mult + 1L) * (long)this.competition.getTimeslotLength();
        }
        this.timeService.setClockParameters(base.getMillis(), rate, this.competition.getTimeslotDuration());
        this.timeService.setCurrentTime(base);
    }

    private int computeGameLength(int minLength, int expLength) {
        double roll = this.randomGen.nextDouble();
        double k = Math.log(1.0 - roll) / Math.log(1.0 - 1.0 / (double)(expLength - minLength + 1));
        int length = minLength + (int)Math.floor(k);
        log.info((Object)("game-length " + length + "(k=" + k + ", roll=" + roll + ")"));
        return length;
    }

    private boolean configurePlugins() {
        List initializers = SpringApplicationContext.listBeansOfType(InitializationService.class);
        ArrayList<String> completedPlugins = new ArrayList<String>();
        ArrayList<InitializationService> deferredInitializers = new ArrayList<InitializationService>();
        for (InitializationService initializer : initializers) {
            log.info((Object)("attempt to initialize " + initializer.toString()));
            String success = initializer.initialize(this.competition, completedPlugins);
            if (success == null) {
                log.info((Object)("deferring " + initializer.toString()));
                deferredInitializers.add(initializer);
                continue;
            }
            if (success == "fail") {
                log.error((Object)("Failed to initialize plugin " + initializer.toString()));
                return false;
            }
            log.info((Object)("completed " + success));
            completedPlugins.add(success);
        }
        int tryCounter = deferredInitializers.size();
        ArrayList<InitializationService> remaining = deferredInitializers;
        while (remaining.size() > 0 && tryCounter > 0) {
            InitializationService initializer = (InitializationService)remaining.get(0);
            log.info((Object)("additional attempt to initialize " + initializer.toString()));
            if (remaining.size() > 1) {
                remaining.remove(0);
            } else {
                remaining.clear();
            }
            String success = initializer.initialize(this.competition, completedPlugins);
            if (success == null) {
                log.info((Object)("deferring " + initializer.toString()));
                remaining.add(initializer);
                --tryCounter;
                continue;
            }
            log.info((Object)("completed " + success));
            completedPlugins.add(success);
        }
        for (InitializationService initializer : remaining) {
            log.error((Object)("Failed to initialize " + initializer.toString()));
        }
        return true;
    }

    private void createInitialTimeslots(Instant base, int initialSlots, int openSlots) {
        int i;
        long timeslotMillis = this.competition.getTimeslotDuration();
        for (i = 0; i < initialSlots - 1; ++i) {
            Timeslot ts = this.timeslotRepo.makeTimeslot(base.plus((long)i * timeslotMillis));
            ts.disable();
        }
        for (i = initialSlots - 1; i < initialSlots + openSlots - 1; ++i) {
            this.timeslotRepo.makeTimeslot(base.plus((long)i * timeslotMillis));
        }
    }

    private void logBrokerStats() {
        StringBuffer buf = new StringBuffer();
        buf.append("Final balance (brokername:balance) [");
        for (String brokerName : this.competition.getBrokers()) {
            Broker broker = this.brokerRepo.findByUsername(brokerName);
            buf.append(" \"").append(brokerName).append("\":");
            buf.append(broker.getCash().getBalance());
        }
        buf.append(" ]");
        log.info((Object)buf.toString());
    }

    private void postBrokerStats() {
        this.tournamentSchedulerService.sendResults(this.composeBrokerStats());
    }

    private String composeBrokerStats() {
        StringBuffer buf = new StringBuffer();
        String delimiter = "";
        for (String brokerName : this.competition.getBrokers()) {
            Broker broker = this.brokerRepo.findByUsername(brokerName);
            buf.append(delimiter).append(brokerName).append(":");
            buf.append(broker.getCash().getBalance());
            delimiter = ",";
        }
        return buf.toString();
    }

    private void runSimulation(long scheduleMillis) {
        SimRunner runner = new SimRunner(this);
        runner.start();
        try {
            runner.join();
        }
        catch (InterruptedException ie) {
            log.warn((Object)"sim interrupted", (Throwable)ie);
        }
    }

    private void step() {
        if (this.checkAbort()) {
            this.stop();
            return;
        }
        Instant time = this.timeService.getCurrentTime();
        Date started = new Date();
        int ts = this.activateNextTimeslot();
        log.info((Object)("step at " + time.toString()));
        this.detectAndKillHangingQueues();
        for (int index = 0; index < this.phaseRegistrations.size(); ++index) {
            log.info((Object)("activate phase " + (index + 1)));
            for (TimeslotPhaseProcessor fn : this.phaseRegistrations.get(index)) {
                fn.activate(time, index + 1);
            }
        }
        TimeslotComplete msg = new TimeslotComplete(ts);
        this.brokerProxyService.broadcastMessage((Object)msg);
        this.tournamentSchedulerService.heartbeat(ts, this.composeBrokerStats());
        Date ended = new Date();
        log.info((Object)("Elapsed time: " + (ended.getTime() - started.getTime())));
        if (--this.timeslotCount <= 0) {
            log.info((Object)"Stopping simulation");
            this.stop();
        }
    }

    private void detectAndKillHangingQueues() {
        Set<String> badQueues = this.jmsManagementService.processQueues();
        if (badQueues != null && badQueues.size() > 0) {
            for (Broker broker : this.brokerRepo.list()) {
                if (!badQueues.contains(broker.toQueueName())) continue;
                broker.setEnabled(false);
            }
            if (badQueues.contains(this.visualizerProxyService.getVisualizerQueueName())) {
                this.visualizerProxyService.setRemoteVisualizer(false);
            }
        }
    }

    private boolean checkAbort() {
        File abortFile = new File(this.abortFileName);
        if (abortFile.canRead()) {
            log.warn((Object)"Abort file detected - shutting down");
            abortFile.delete();
            return true;
        }
        return false;
    }

    private int activateNextTimeslot() {
        long timeslotMillis = this.competition.getTimeslotDuration();
        Timeslot current = this.findCurrentTimeslot();
        if (current == null) {
            log.error((Object)("current timeslot is null at " + this.timeService.getCurrentTime()));
            return -1;
        }
        int oldSerial = current.getSerialNumber() + this.competition.getDeactivateTimeslotsAhead() - 1;
        Timeslot oldTs = this.timeslotRepo.findBySerialNumber(oldSerial);
        oldTs.disable();
        log.info((Object)("Deactivated timeslot " + oldSerial + ", start " + oldTs.getStartInstant().toString()));
        int newSerial = current.getSerialNumber() + this.competition.getDeactivateTimeslotsAhead() - 1 + this.competition.getTimeslotsOpen();
        Timeslot newTs = this.timeslotRepo.findBySerialNumber(newSerial);
        if (newTs == null) {
            long start = current.getStartInstant().getMillis() + (long)(newSerial - current.getSerialNumber()) * timeslotMillis;
            newTs = this.timeslotRepo.makeTimeslot(new Instant(start));
        } else {
            newTs.enable();
        }
        log.info((Object)("Activated timeslot " + newSerial + ", start " + newTs.getStartInstant()));
        this.brokerProxyService.broadcastMessage((Object)this.makeTimeslotUpdate());
        return current.getSerialNumber();
    }

    private synchronized Timeslot findCurrentTimeslot() {
        int expectedIndex = this.currentSlot + this.bootstrapOffset;
        Timeslot currentTimeslot = this.timeslotRepo.findBySerialNumber(expectedIndex);
        if (currentTimeslot == null) {
            return null;
        }
        Instant now = this.timeService.getCurrentTime();
        int nextIndex = this.timeslotRepo.getTimeslotIndex(now);
        if (nextIndex > expectedIndex) {
            long sysTime = new Date().getTime();
            long simTime = currentTimeslot.getStartInstant().getMillis();
            long tickTime = this.timeService.getStart() + (simTime - this.timeService.getBase()) / this.timeService.getRate();
            log.warn((Object)("sysTime=" + sysTime + ", tickTime=" + tickTime));
        }
        return currentTimeslot;
    }

    public boolean isRunning() {
        return this.simRunning;
    }

    public void stop() {
        this.running = false;
    }

    public void shutDown() {
        this.running = false;
        SimEnd endMsg = new SimEnd();
        this.brokerProxyService.broadcastMessage((Object)endMsg);
        this.simRunning = false;
        if (this.clock != null) {
            this.clock.waitUntilStop();
        }
        this.jmsManagementService.stop();
        this.logService.stopLog();
    }

    public void registerTimeslotPhase(TimeslotPhaseProcessor thing, int phase) {
        if (phase <= 0 || phase > this.timeslotPhaseCount) {
            log.error((Object)("phase " + phase + " out of range (1.." + this.timeslotPhaseCount + ")"));
        } else {
            if (this.phaseRegistrations == null) {
                this.phaseRegistrations = new ArrayList();
                for (int index = 0; index < this.timeslotPhaseCount; ++index) {
                    this.phaseRegistrations.add(new ArrayList());
                }
            }
            this.phaseRegistrations.get(phase - 1).add(thing);
        }
    }

    public boolean isBootstrapMode() {
        return this.bootstrapMode;
    }

    public void pause() {
        log.info((Object)"pause");
        SimPause msg = new SimPause();
        this.brokerProxyService.broadcastMessage((Object)msg);
    }

    public void resume(long newStart) {
        log.info((Object)"resume");
        SimResume msg = new SimResume(new Instant(newStart));
        this.brokerProxyService.broadcastMessage((Object)msg);
    }

    public void handleMessage(PauseRequest msg) {
        if (this.pauseRequester != null) {
            log.info((Object)("Pause request by " + msg.getBroker().getUsername() + " rejected; already paused by " + this.pauseRequester));
            return;
        }
        this.pauseRequester = msg.getBroker().getUsername();
        log.info((Object)("Pause request by " + msg.getBroker().getUsername()));
        this.clock.requestPause();
    }

    public void handleMessage(PauseRelease msg) {
        if (this.pauseRequester == null) {
            log.info((Object)("Release request by " + msg.getBroker().getUsername() + ", but no pause currently requested"));
            return;
        }
        if (this.pauseRequester != msg.getBroker().getUsername()) {
            log.info((Object)("Release request by " + msg.getBroker().getUsername() + ", but pause request was by " + this.pauseRequester));
            return;
        }
        log.info((Object)("Pause released by " + msg.getBroker().getUsername()));
        this.clock.releasePause();
        this.pauseRequester = null;
    }

    public void handleMessage(BrokerAuthentication msg) {
        log.info((Object)("receiveMessage(BrokerAuthentication) " + msg.getUsername()));
        this.loginBroker(msg.getUsername());
    }

    public void setBootstrapTimeslotMillis(long length) {
        this.bootstrapTimeslotMillis = length;
    }

    long getBootstrapTimeslotMillis() {
        return this.bootstrapTimeslotMillis;
    }

    class SimRunner
    extends Thread {
        CompetitionControlService parent;

        public SimRunner(CompetitionControlService instance) {
            this.parent = instance;
        }

        @Override
        public void run() {
            SimulationClockControl.initialize(this.parent, CompetitionControlService.this.timeService);
            CompetitionControlService.this.clock = SimulationClockControl.getInstance();
            long now = new Date().getTime();
            long start = now + 1000L;
            SimStart startMsg = new SimStart(new Instant(start));
            CompetitionControlService.this.brokerProxyService.broadcastMessage((Object)startMsg);
            CompetitionControlService.this.clock.setStart(start);
            CompetitionControlService.this.timeService.init();
            CompetitionControlService.this.running = true;
            CompetitionControlService.this.clock.scheduleTick();
            while (CompetitionControlService.this.running) {
                log.info((Object)("Wait for tick " + CompetitionControlService.this.currentSlot));
                CompetitionControlService.this.clock.waitForTick(CompetitionControlService.this.currentSlot);
                try {
                    CompetitionControlService.this.step();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CompetitionControlService.this.running = false;
                }
                CompetitionControlService.this.currentSlot += 1;
                CompetitionControlService.this.clock.complete();
            }
            log.info((Object)"Stop simulation");
            CompetitionControlService.this.clock.stop();
        }
    }
}

