/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.IdGenerator;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.interfaces.BootstrapDataCollector;
import org.powertac.common.interfaces.CompetitionSetup;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.repo.DomainRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.server.CompetitionControlService;
import org.powertac.server.LogService;
import org.powertac.server.ServerPropertiesService;
import org.powertac.server.TournamentSchedulerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Service
public class CompetitionSetupService
implements CompetitionSetup {
    private static Logger log = Logger.getLogger(CompetitionSetupService.class);
    @Autowired
    private CompetitionControlService cc;
    @Autowired
    private BootstrapDataCollector defaultBroker;
    @Autowired
    private ServerPropertiesService serverProps;
    @Autowired
    RandomSeedRepo randomSeedRepo;
    @Autowired
    private XMLMessageConverter messageConverter;
    @Autowired
    private LogService logService;
    @Autowired
    private TournamentSchedulerService tss;
    private Competition competition;
    private int gameId = 0;
    private URL controllerURL;
    private String seedSource = null;
    private Thread session = null;

    public void processCmdLine(String[] args) {
        if (args.length <= 1) {
            System.out.println("Server BootStrap");
            this.preGame();
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        this.processCli(args);
        this.waitForSession();
    }

    private void waitForSession() {
        if (this.session != null) {
            try {
                this.session.join();
            }
            catch (InterruptedException e) {
                System.out.println("Error waiting for session completion: " + e.toString());
            }
        }
    }

    private void processCli(String[] args) {
        OptionParser parser = new OptionParser();
        parser.accepts("sim");
        ArgumentAcceptingOptionSpec bootOutput = parser.accepts("boot").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec controllerOption = parser.accepts("control").withRequiredArg().ofType(URL.class);
        ArgumentAcceptingOptionSpec gameOpt = parser.accepts("game-id").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec serverConfigUrl = parser.accepts("config").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec logSuffixOption = parser.accepts("log-suffix").withRequiredArg();
        ArgumentAcceptingOptionSpec bootData = parser.accepts("boot-data").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec seedData = parser.accepts("random-seeds").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec jmsUrl = parser.accepts("jms-url").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec inputQueue = parser.accepts("input-queue").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec brokerList = parser.accepts("brokers").withRequiredArg().withValuesSeparatedBy(',');
        OptionSet options = parser.parse(args);
        try {
            this.seedSource = null;
            String logSuffix = (String)options.valueOf((OptionSpec)logSuffixOption);
            this.controllerURL = (URL)options.valueOf((OptionSpec)controllerOption);
            Integer game = (Integer)options.valueOf((OptionSpec)gameOpt);
            String serverConfig = (String)options.valueOf((OptionSpec)serverConfigUrl);
            if (this.controllerURL != null) {
                if (null == game) {
                    log.error((Object)("controller URL " + this.controllerURL + " without gameId"));
                    this.gameId = 0;
                } else {
                    this.gameId = game;
                }
                this.tss.setTournamentSchedulerUrl(this.controllerURL.toString());
                this.tss.setGameId(game);
                serverConfig = this.tss.getConfigUrl().toExternalForm();
            }
            if (options.has((OptionSpec)bootOutput)) {
                this.bootSession((String)options.valueOf((OptionSpec)bootOutput), serverConfig, logSuffix);
            } else if (options.has("sim")) {
                this.simSession((String)options.valueOf((OptionSpec)bootData), serverConfig, (String)options.valueOf((OptionSpec)jmsUrl), logSuffix, options.valuesOf((OptionSpec)brokerList), (String)options.valueOf((OptionSpec)inputQueue), (String)options.valueOf((OptionSpec)seedData));
            } else {
                System.err.println("Must provide either --boot or --sim to run server");
                System.exit(1);
            }
        }
        catch (OptionException e) {
            System.err.println("Bad command argument: " + e.toString());
        }
    }

    private void setLogSuffix(String logSuffix, String defaultSuffix) throws IOException {
        if (logSuffix == null) {
            logSuffix = defaultSuffix;
        }
        this.serverProps.setProperty("server.logfileSuffix", logSuffix);
    }

    public String bootSession(String bootFilename, String config, String logSuffix) {
        String error = null;
        try {
            log.info((Object)("bootSession: bootFilename=" + bootFilename + ", config=" + config + ", logSuffix=" + logSuffix));
            this.serverProps.recycle();
            this.setConfigMaybe(config);
            this.setLogSuffix(logSuffix, "boot");
            File bootFile = new File(bootFilename);
            if (!bootFile.getAbsoluteFile().getParentFile().canWrite()) {
                error = "Cannot write to bootstrap data file " + bootFilename;
                System.out.println(error);
            } else {
                this.startBootSession(bootFile);
            }
        }
        catch (NullPointerException npe) {
            error = "Bootstrap filename not given";
        }
        catch (MalformedURLException e) {
            error = "Malformed URL: " + e.toString();
            System.out.println(error);
        }
        catch (IOException e) {
            error = "Error reading configuration";
        }
        catch (ConfigurationException e) {
            error = "Error setting configuration";
        }
        return error;
    }

    public String simSession(String bootData, String config, String jmsUrl, String logfileSuffix, List<String> brokerUsernames) {
        return this.simSession(bootData, config, jmsUrl, logfileSuffix, brokerUsernames, null, null);
    }

    String simSession(String bootData, String config, String jmsUrl, String logfileSuffix, List<String> brokerUsernames, String inputQueueName, String seedData) {
        String error = null;
        try {
            log.info((Object)("simSession: bootData=" + bootData + ", config=" + config + ", jmsUrl=" + jmsUrl + ", inputQueue=" + inputQueueName + ", seedData=" + seedData));
            this.serverProps.recycle();
            this.setConfigMaybe(config);
            this.seedSource = seedData;
            this.setLogSuffix(logfileSuffix, "sim-" + this.gameId);
            if (jmsUrl != null) {
                this.serverProps.setProperty("server.jmsManagementService.jmsBrokerUrl", jmsUrl);
            }
            URL bootUrl = null;
            if (this.controllerURL != null) {
                bootUrl = this.tss.getBootUrl();
            } else if (bootData != null) {
                if (!bootData.contains(":")) {
                    bootData = "file:" + bootData;
                }
                bootUrl = new URL(bootData);
            }
            if (null == bootUrl) {
                error = "bootstrap data source not given";
                System.out.println(error);
            } else {
                log.info((Object)("bootUrl=" + bootUrl.toExternalForm()));
                this.startSimSession(brokerUsernames, inputQueueName, bootUrl);
            }
        }
        catch (MalformedURLException e) {
            error = "Malformed URL: " + e.toString();
            System.out.println(error);
        }
        catch (IOException e) {
            error = "Error reading configuration " + config;
        }
        catch (ConfigurationException e) {
            error = "Error setting configuration " + config;
        }
        return error;
    }

    private void setConfigMaybe(String config) throws ConfigurationException, IOException {
        if (config == null) {
            return;
        }
        log.info((Object)("Reading configuration from " + config));
        this.serverProps.setUserConfig(this.makeUrl(config));
    }

    private void loadSeedsMaybe() {
        if (this.seedSource == null) {
            return;
        }
        log.info((Object)("Reading random seeds from " + this.seedSource));
        try {
            InputStreamReader stream = new InputStreamReader(this.makeUrl(this.seedSource).openStream());
            this.randomSeedRepo.loadSeeds(stream);
        }
        catch (Exception e) {
            log.error((Object)("Cannot load seeds from " + this.seedSource));
        }
    }

    private URL makeUrl(String name) throws MalformedURLException {
        String urlName = name;
        if (!urlName.contains(":")) {
            urlName = "file:" + urlName;
        }
        return new URL(urlName);
    }

    private void startBootSession(File bootstrapFile) throws IOException {
        final FileWriter bootWriter = new FileWriter(bootstrapFile);
        this.session = new Thread(){

            @Override
            public void run() {
                CompetitionSetupService.this.cc.setAuthorizedBrokerList(new ArrayList<String>());
                CompetitionSetupService.this.preGame();
                CompetitionSetupService.this.cc.runOnce(true);
                CompetitionSetupService.this.saveBootstrapData(bootWriter);
            }
        };
        this.session.start();
    }

    private void startSimSession(final List<String> brokers, final String inputQueueName, final URL bootDataset) {
        this.session = new Thread(){

            @Override
            public void run() {
                CompetitionSetupService.this.cc.setAuthorizedBrokerList(brokers);
                CompetitionSetupService.this.cc.setInputQueueName(inputQueueName);
                if (CompetitionSetupService.this.preGame(bootDataset)) {
                    CompetitionSetupService.this.cc.setBootstrapDataset(CompetitionSetupService.this.processBootDataset(bootDataset));
                    CompetitionSetupService.this.cc.runOnce(false);
                    CompetitionSetupService.this.gameId += 1;
                }
            }
        };
        this.session.start();
    }

    public void preGame() {
        String suffix = this.serverProps.getProperty("server.logfileSuffix", "x");
        this.logService.startLog(suffix);
        log.info((Object)"preGame() - start");
        IdGenerator.recycle();
        this.competition = Competition.newInstance((String)("game-" + this.gameId));
        log.info((Object)"pre-game initialization");
        this.configureCompetition(this.competition);
        List repos = SpringApplicationContext.listBeansOfType(DomainRepo.class);
        log.debug((Object)("found " + repos.size() + " repos"));
        for (DomainRepo repo : repos) {
            repo.recycle();
        }
        this.loadSeedsMaybe();
        List initializers = SpringApplicationContext.listBeansOfType(InitializationService.class);
        log.debug((Object)("found " + initializers.size() + " initializers"));
        for (InitializationService init : initializers) {
            init.setDefaults();
        }
    }

    private void configureCompetition(Competition competition) {
        this.serverProps.configureMe(competition);
    }

    public boolean preGame(URL bootFile) {
        log.info((Object)"preGame(File) - start");
        this.preGame();
        Competition bootstrapCompetition = null;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/config/competition");
            NodeList nodes = (NodeList)exp.evaluate(new InputSource(bootFile.openStream()), XPathConstants.NODESET);
            String xml = this.nodeToString(nodes.item(0));
            bootstrapCompetition = (Competition)this.messageConverter.fromXML(xml);
        }
        catch (XPathExpressionException xee) {
            log.error((Object)("preGame: Error reading boot dataset: " + xee.toString()));
            System.out.println("preGame: Error reading boot dataset: " + xee.toString());
            return false;
        }
        catch (IOException ioe) {
            log.error((Object)("preGame: Error opening file " + bootFile + ": " + ioe.toString()));
            System.out.println("preGame: Error opening file " + bootFile + ": " + ioe.toString());
            return false;
        }
        Competition.currentCompetition().update(bootstrapCompetition);
        return true;
    }

    void saveBootstrapData(Writer datasetWriter) {
        BufferedWriter output = new BufferedWriter(datasetWriter);
        List data = this.defaultBroker.collectBootstrapData(this.competition.getBootstrapTimeslotCount());
        try {
            output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            output.newLine();
            output.write("<powertac-bootstrap-data>");
            output.newLine();
            output.write("<config>");
            output.newLine();
            output.write(this.messageConverter.toXML((Object)this.competition));
            output.newLine();
            output.write("</config>");
            output.newLine();
            output.write("<bootstrap>");
            output.newLine();
            for (Object item : data) {
                output.write(this.messageConverter.toXML(item));
                output.newLine();
            }
            output.write("</bootstrap>");
            output.newLine();
            output.write("</powertac-bootstrap-data>");
            output.newLine();
            output.close();
        }
        catch (IOException ioe) {
            log.error((Object)("Error writing bootstrap file: " + ioe.toString()));
        }
    }

    private ArrayList<Object> processBootDataset(URL bootDataset) {
        ArrayList<Object> result = new ArrayList<Object>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            InputSource source = new InputSource(bootDataset.openStream());
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/bootstrap/*");
            NodeList nodes = (NodeList)exp.evaluate(source, XPathConstants.NODESET);
            log.info((Object)("Found " + nodes.getLength() + " bootstrap nodes"));
            for (int i = 0; i < nodes.getLength(); ++i) {
                String xml = this.nodeToString(nodes.item(i));
                Object msg = this.messageConverter.fromXML(xml);
                result.add(msg);
            }
        }
        catch (XPathExpressionException xee) {
            log.error((Object)("runOnce: Error reading config file: " + xee.toString()));
        }
        catch (IOException ioe) {
            log.error((Object)("runOnce: reset fault: " + ioe.toString()));
        }
        return result;
    }

    private String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "no");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            log.error((Object)("nodeToString Transformer Exception " + te.toString()));
        }
        String result = sw.toString();
        return result;
    }
}

