/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.Timeslot;
import org.powertac.common.WeatherForecast;
import org.powertac.common.WeatherForecastPrediction;
import org.powertac.common.WeatherReport;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.exceptions.PowerTacException;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.repo.WeatherForecastRepo;
import org.powertac.common.repo.WeatherReportRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeatherService
extends TimeslotPhaseProcessor
implements InitializationService {
    private static Logger log = Logger.getLogger((String)WeatherService.class.getName());
    private Timeslot currentTime;
    @ConfigurableValue(valueType="Integer", description="Timeslot interval to make requests")
    private int weatherReqInterval = 12;
    @ConfigurableValue(valueType="String", description="Location of weather data to be reported")
    private String weatherLocation = "rotterdam";
    @ConfigurableValue(valueType="String", description="Location of weather server rest url")
    private String serverUrl = "http://wolf-08.fbk.eur.nl:8080/WeatherServer/faces/index.xhtml";
    @ConfigurableValue(valueType="Boolean", description="If network calls to weather server should block until finished")
    private boolean blocking = true;
    @ConfigurableValue(valueType="Integer", description="Length of forecasts (in hours)")
    private int forecastHorizon = 24;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private WeatherReportRepo weatherReportRepo;
    @Autowired
    private WeatherForecastRepo weatherForecastRepo;
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private ServerConfiguration serverProps;

    public int getWeatherReqInterval() {
        return this.weatherReqInterval;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public int getForecastHorizon() {
        return this.forecastHorizon;
    }

    public void activate(Instant time, int phaseNumber) {
        long msec;
        if (this.weatherReqInterval > 24) {
            this.weatherReqInterval = 24;
        }
        if ((msec = time.getMillis()) % ((long)this.getWeatherReqInterval() * 3600000L) != 0L) {
            log.info((Object)"WeatherService reports not time to grab weather data.");
        } else {
            this.requestData();
        }
        this.broadcastWeatherReports();
        this.broadcastWeatherForecasts();
    }

    private void requestData() {
        log.info((Object)("Timeslot " + this.timeslotRepo.currentTimeslot().getId() + " WeatherService reports time to make network request for weather " + "data in blocking = " + this.isBlocking() + " mode."));
        String currentMethod = "";
        try {
            Data data = this.webRequest(this.timeslotRepo.currentTimeslot(), 1);
            this.processData(data, this.timeslotRepo.currentTimeslot());
        }
        catch (Throwable e) {
            log.error((Object)("Unable to get weather from weather " + currentMethod));
            log.error((Object)e.getMessage());
        }
    }

    private Data webRequest(Timeslot time, int randomSeed) {
        this.currentTime = time;
        try {
            int year = this.currentTime.getStartInstant().get(DateTimeFieldType.year());
            int month = this.currentTime.getStartInstant().get(DateTimeFieldType.monthOfYear());
            int day = this.currentTime.getStartInstant().get(DateTimeFieldType.dayOfMonth());
            int hour = this.currentTime.getStartInstant().get(DateTimeFieldType.clockhourOfDay()) % 24;
            String queryDate = String.format("%04d%02d%02d%02d", year, month, day, hour);
            log.info((Object)("Query datetime value for REST call: " + queryDate));
            URL url = new URL(this.getServerUrl() + "?weatherDate=" + queryDate + "&weatherLocation=" + this.weatherLocation);
            URLConnection conn = url.openConnection();
            BufferedReader input = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            XStream xstream = new XStream();
            xstream.alias("data", Data.class);
            xstream.alias("weatherReport", WeatherReport.class);
            xstream.alias("weatherForecast", WeatherForecastPrediction.class);
            xstream.useAttributeFor(WeatherReport.class);
            xstream.registerConverter((Converter)new WeatherReportConverter());
            xstream.useAttributeFor(WeatherForecastPrediction.class);
            xstream.registerConverter((Converter)new WeatherForecastConverter());
            Data data = (Data)xstream.fromXML((Reader)input);
            return data;
        }
        catch (Exception e) {
            log.error((Object)("Exception Raised during newtork call: " + e.toString()));
            System.out.println("Exception Raised: " + e.toString());
            e.printStackTrace();
            return null;
        }
    }

    private void processData(Data data, Timeslot time) {
        this.processWeatherData(data, time);
        this.processForecastDataNew(data, time);
    }

    private void processWeatherData(Data data, Timeslot time) {
        for (WeatherReport report : data.getWeatherReports()) {
            this.weatherReportRepo.add(report);
        }
        this.currentTime = time;
        log.info((Object)(data.getWeatherReports().size() + " WeatherReports fetched from xml response."));
        this.weatherReportRepo.runOnce();
    }

    private void processForecastDataNew(Data data, Timeslot time) {
        ArrayList<WeatherForecastPrediction> currentPredictions = new ArrayList<WeatherForecastPrediction>();
        int j = 0;
        for (WeatherForecastPrediction forecast : data.getWeatherForecasts()) {
            currentPredictions.add(new WeatherForecastPrediction(j % 24 + 1, forecast.getTemperature(), forecast.getWindSpeed(), forecast.getWindDirection(), forecast.getCloudCover()));
            if (++j % this.forecastHorizon != 0) continue;
            WeatherForecast newForecast = new WeatherForecast(this.currentTime, currentPredictions);
            this.weatherForecastRepo.add(newForecast);
            currentPredictions = new ArrayList();
            if (this.currentTime == null) {
                log.error((Object)"Null timeslot when adding forecasts to weatherForecastRepo");
                continue;
            }
            this.currentTime = this.currentTime.getNext();
        }
        log.info((Object)(data.getWeatherForecasts().size() + " WeatherForecasts fetched from xml response."));
        this.weatherForecastRepo.runOnce();
    }

    private void broadcastWeatherReports() {
        WeatherReport report = null;
        try {
            report = this.weatherReportRepo.currentWeatherReport();
        }
        catch (PowerTacException e) {
            log.error((Object)"Weather Service reports Weather Report Repo empty");
        }
        if (report == null) {
            log.error((Object)"null weather-report!");
            this.brokerProxyService.broadcastMessage((Object)new WeatherReport(this.timeslotRepo.currentTimeslot(), 0.0, 0.0, 0.0, 0.0));
        } else {
            this.brokerProxyService.broadcastMessage((Object)report);
        }
    }

    private void broadcastWeatherForecasts() {
        WeatherForecast forecast = null;
        try {
            forecast = this.weatherForecastRepo.currentWeatherForecast();
        }
        catch (PowerTacException e) {
            log.error((Object)"Weather Service reports Weather Forecast Repo emtpy");
        }
        if (forecast == null) {
            log.error((Object)"null weather-forecast!");
            ArrayList<WeatherForecastPrediction> currentPredictions = new ArrayList<WeatherForecastPrediction>();
            for (int j = 1; j <= this.getForecastHorizon(); ++j) {
                currentPredictions.add(new WeatherForecastPrediction(j, 0.0, 0.0, 0.0, 0.0));
            }
            this.brokerProxyService.broadcastMessage((Object)new WeatherForecast(this.timeslotRepo.currentTimeslot(), currentPredictions));
        } else {
            this.brokerProxyService.broadcastMessage((Object)forecast);
        }
    }

    public void setDefaults() {
    }

    public String initialize(Competition competition, List<String> completedInits) {
        super.init();
        this.serverProps.configureMe((Object)this);
        return "WeatherService";
    }

    public class Data {
        private List<WeatherReport> weatherReports = new ArrayList<WeatherReport>();
        private List<WeatherForecastPrediction> weatherForecasts = new ArrayList<WeatherForecastPrediction>();
        private List<EnergyReport> energyReports = new ArrayList<EnergyReport>();

        public List<WeatherReport> getWeatherReports() {
            return this.weatherReports;
        }

        public void setWeatherReports(List<WeatherReport> weatherReports) {
            this.weatherReports = weatherReports;
        }

        public List<WeatherForecastPrediction> getWeatherForecasts() {
            return this.weatherForecasts;
        }

        public void setWeatherForecasts(List<WeatherForecastPrediction> weatherForecasts) {
            this.weatherForecasts = weatherForecasts;
        }

        public List<EnergyReport> getEnergyReports() {
            return this.energyReports;
        }

        public void setEnergyReports(List<EnergyReport> energyReports) {
            this.energyReports = energyReports;
        }
    }

    private class EnergyReport {
        private EnergyReport() {
        }
    }

    public class WeatherForecastConverter
    implements Converter {
        private int idCounter = 0;

        public boolean canConvert(Class clazz) {
            return clazz.equals(WeatherForecastPrediction.class);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String temp = reader.getAttribute("temp");
            String wind = reader.getAttribute("windspeed");
            String dir = reader.getAttribute("winddir");
            String cloudCvr = reader.getAttribute("cloudcover");
            return new WeatherForecastPrediction(this.idCounter++, Double.parseDouble(temp), Double.parseDouble(wind), Double.parseDouble(dir), Double.parseDouble(cloudCvr));
        }
    }

    public class WeatherReportConverter
    implements Converter {
        public boolean canConvert(Class clazz) {
            return clazz.equals(WeatherReport.class);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String temp = reader.getAttribute("temp");
            String wind = reader.getAttribute("windspeed");
            String dir = reader.getAttribute("winddir");
            String cloudCvr = reader.getAttribute("cloudcover");
            WeatherReport wr = new WeatherReport(WeatherService.this.currentTime, Double.parseDouble(temp), Double.parseDouble(wind), Double.parseDouble(dir), Double.parseDouble(cloudCvr));
            try {
                WeatherService.this.currentTime = WeatherService.this.currentTime.getNext();
                return wr;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

