/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.VisualizerMessageListener;
import org.powertac.common.interfaces.VisualizerProxy;
import org.powertac.common.msg.VisualizerStatusRequest;
import org.powertac.server.JmsManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Service;

@Service
public class VisualizerProxyService
implements VisualizerProxy,
InitializationService {
    private static Logger log = Logger.getLogger(VisualizerProxyService.class);
    @Autowired
    private ServerConfiguration serverConfig;
    @Autowired
    private JmsManagementService jmsManagementService;
    @Autowired
    private JmsTemplate template;
    @Autowired
    private XMLMessageConverter converter;
    private ArrayList<VisualizerMessageListener> listeners = new ArrayList();
    @ConfigurableValue(valueType="Boolean", description="true to operate with remote visualizer")
    private boolean remoteVisualizer = false;
    @ConfigurableValue(valueType="String", description="name of queue for remote visualizer")
    private String visualizerQueueName = "remote-visualizer";
    private boolean remoteVizActive = false;

    public void setRemoteVisualizer(boolean remoteVisualizer) {
        this.remoteVisualizer = remoteVisualizer;
    }

    public String getVisualizerQueueName() {
        return this.visualizerQueueName;
    }

    public void registerVisualizerMessageListener(VisualizerMessageListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void forwardMessage(Object message) {
        for (VisualizerMessageListener listener : this.listeners) {
            listener.receiveMessage(message);
        }
        if (this.remoteVisualizer) {
            final String text = this.converter.toXML(message);
            this.template.send(this.visualizerQueueName, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    TextMessage message = session.createTextMessage(text);
                    return message;
                }
            });
        }
    }

    public void setDefaults() {
    }

    public String initialize(Competition competition, List<String> completedInits) {
        this.serverConfig.configureMe((Object)this);
        if (this.remoteVisualizer) {
            log.info((Object)("Remote visualizer on queue " + this.visualizerQueueName));
            this.jmsManagementService.createQueue(this.visualizerQueueName);
        }
        return "VisualizerProxy";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respondToPing() {
        if (this.remoteVisualizer) {
            this.forwardMessage(new VisualizerStatusRequest());
            VisualizerProxyService visualizerProxyService = this;
            synchronized (visualizerProxyService) {
                this.remoteVizActive = true;
                log.info((Object)"ping received from remote viz");
                this.notifyAll();
            }
        }
    }

    public boolean isActive() {
        return this.remoteVizActive;
    }

    public synchronized void waitForRemoteViz(long maxDelay) {
        if (!this.remoteVisualizer || this.remoteVizActive) {
            return;
        }
        long start = new Date().getTime();
        boolean complete = false;
        try {
            while (!complete) {
                this.wait(maxDelay);
                log.info((Object)"woke up");
                if (this.remoteVizActive) {
                    complete = true;
                    continue;
                }
                long now = new Date().getTime();
                if (now - start < maxDelay) continue;
                this.remoteVisualizer = false;
                complete = true;
            }
        }
        catch (InterruptedException ie) {
            log.warn((Object)"failed to hear from remote visualizer");
            this.remoteVisualizer = false;
        }
    }
}

