/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.powertac.common.Broker;
import org.powertac.common.IdGenerator;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.server.VisualizerProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerMessageReceiver
implements MessageListener {
    private static Logger log = Logger.getLogger(ServerMessageReceiver.class);
    @Autowired
    private XMLMessageConverter converter;
    @Autowired
    private BrokerProxy brokerProxy;
    @Autowired
    private VisualizerProxyService visualizerProxy;
    @Autowired
    private BrokerRepo brokerRepo;
    private Pattern brokerRegex = Pattern.compile("<broker>([A-Za-z0-9_ ]+)</broker>");
    private Pattern idRegex = Pattern.compile(" id=\"([0-9]+)\"");

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            this.onMessage((TextMessage)message);
        } else {
            log.warn((Object)("Unable to process incoming message of type " + message.getClass().getName()));
        }
    }

    public void onMessage(TextMessage message) {
        try {
            log.debug((Object)"onMessage(Message) - receiving a message");
            this.onMessage(message.getText());
        }
        catch (JMSException e) {
            log.error((Object)"failed to extract text from TextMessage", (Throwable)e);
        }
    }

    void onMessage(String xml) {
        String validXml = xml;
        if (xml.startsWith("<broker-authentication")) {
            validXml = xml;
        } else {
            if (xml.startsWith("<visualizer-status")) {
                log.info((Object)"received visualizer ping request");
                this.visualizerProxy.respondToPing();
                return;
            }
            validXml = this.validateBrokerPrefix(xml);
            if (null == validXml) {
                log.warn((Object)("Invalid message: ignoring " + xml));
                return;
            }
        }
        log.debug((Object)("onMessage(String) - received message:\n" + validXml));
        Object message = this.converter.fromXML(validXml);
        log.debug((Object)("onMessage(String) - received message of type " + message.getClass().getSimpleName()));
        this.brokerProxy.routeMessage(message);
    }

    private String validateBrokerPrefix(String message) {
        int realMsg = message.indexOf(60);
        if (0 == realMsg) {
            return null;
        }
        String prefix = message.substring(0, realMsg);
        log.debug((Object)("prefix=" + prefix));
        Matcher m = this.brokerRegex.matcher(message);
        if (m.find(realMsg)) {
            String username = m.group(1);
            log.debug((Object)("broker username=" + username));
            Broker broker = this.brokerRepo.findByUsername(username);
            if (broker.getKey().equals(prefix)) {
                m = this.idRegex.matcher(message);
                if (m.find(realMsg)) {
                    long idValue = Long.parseLong(m.group(1));
                    log.debug((Object)("message id: " + idValue));
                    int idPrefix = IdGenerator.extractPrefix((long)idValue);
                    if (broker.getIdPrefix() == idPrefix) {
                        return message.substring(realMsg);
                    }
                } else {
                    log.warn((Object)("Incoming message with no object id: " + message));
                    return message.substring(realMsg);
                }
            }
        }
        return null;
    }
}

