/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.WeatherReport;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.CompetitionControl;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.msg.BrokerAccept;
import org.powertac.common.msg.BrokerAuthentication;
import org.powertac.common.msg.PauseRelease;
import org.powertac.common.msg.PauseRequest;
import org.powertac.common.msg.SimEnd;
import org.powertac.common.msg.SimPause;
import org.powertac.common.msg.SimResume;
import org.powertac.common.msg.SimStart;
import org.powertac.common.msg.TimeslotComplete;
import org.powertac.common.msg.TimeslotUpdate;
import org.powertac.common.repo.BootstrapDataRepo;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.repo.WeatherReportRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.server.JmsManagementService;
import org.powertac.server.LogService;
import org.powertac.server.ServerMessageReceiver;
import org.powertac.server.ServerPropertiesService;
import org.powertac.server.SimulationClockControl;
import org.powertac.server.TournamentSchedulerService;
import org.powertac.server.VisualizerProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompetitionControlService
implements CompetitionControl {
    private static Logger log = LogManager.getLogger(CompetitionControlService.class);
    private Competition competition;
    private SimulationClockControl clock;
    @Autowired
    private TimeService timeService;
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    @Autowired
    private BootstrapDataRepo bootstrapDataRepo;
    @Autowired
    private LogService logService;
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private WeatherReportRepo weatherReportRepo;
    @Autowired
    private ServerPropertiesService configService;
    @Autowired
    private ServerMessageReceiver serverMessageReceiver;
    @Autowired
    private JmsManagementService jmsManagementService;
    @Autowired
    private TournamentSchedulerService tournamentSchedulerService;
    @Autowired
    private VisualizerProxyService visualizerProxyService;
    private String serverQueueName = "serverInput";
    private boolean running = false;
    private int timeslotPhaseCount = 4;
    private ArrayList<List<TimeslotPhaseProcessor>> phaseRegistrations;
    private int timeslotCount = 0;
    private int currentSlot = 0;
    private int bootstrapOffset = 0;
    private RandomSeed randomGen;
    private ArrayList<String> alwaysAuthorizedBrokers;
    private HashMap<String, String> authorizedBrokerMap;
    private List<String> brokerNames;
    @ConfigurableValue(valueType="Integer", description="Maximum time in msec to wait for first broker login")
    private int firstLoginTimeout = 0;
    @ConfigurableValue(valueType="Integer", description="Maximum time in msec to wait for subsequent broker login")
    private int loginTimeout = 0;
    @ConfigurableValue(valueType="Boolean", description="If true, then brokers can send PauseRequest messages")
    private boolean brokerPauseAllowed = false;
    private ArrayList<String> pendingLogins;
    private int loginCount = 0;
    @ConfigurableValue(valueType="Long", description="Milliseconds/timeslot in boot mode. Should be > 300.")
    private long bootstrapTimeslotMillis = 2000L;
    @ConfigurableValue(valueType="String", description="Name of abort file")
    private String abortFileName = "abort";
    @ConfigurableValue(valueType="Integer", description="depth of stack trace on exception")
    private int stackTraceDepth = 5;
    private boolean bootstrapMode = true;
    private boolean simRunning = false;
    String pauseRequester;

    public void init() {
        this.phaseRegistrations = null;
        if (!this.bootstrapMode) {
            this.jmsManagementService.initializeServerQueue(this.serverQueueName);
            this.jmsManagementService.registerMessageListener(this.serverQueueName, this.serverMessageReceiver);
        }
        for (Class messageType : Arrays.asList(BrokerAuthentication.class, PauseRequest.class, PauseRelease.class)) {
            this.brokerProxyService.registerBrokerMessageListener((Object)this, messageType);
        }
    }

    public void setTimeslotPhaseCount(int count) {
        if (count <= 0) {
            log.error("TimeslotPhaseCount must be >= 0");
        } else {
            this.timeslotPhaseCount = count;
        }
    }

    public void setAlwaysAuthorizedBrokers(List<String> brokerList) {
        this.alwaysAuthorizedBrokers = new ArrayList<String>(brokerList);
    }

    public void setAuthorizedBrokerList(List<String> brokerList) {
        this.brokerNames = brokerList;
        this.loginCount = brokerList.size();
        this.pendingLogins = new ArrayList();
        this.authorizedBrokerMap = new HashMap();
        for (String brokerName : this.alwaysAuthorizedBrokers) {
            this.authorizedBrokerMap.put(brokerName, brokerName);
            log.info("pre-authorized " + brokerName);
        }
        for (String broker : brokerList) {
            String brokerName;
            String[] components = broker.split("/");
            if (components.length < 1) {
                log.error("Bad broker spec " + broker);
                continue;
            }
            String queueName = brokerName = components[0];
            if (components.length > 1) {
                queueName = components[1];
            }
            this.authorizedBrokerMap.put(brokerName, queueName);
            log.info("Authorized broker " + brokerName + " / " + queueName);
            this.pendingLogins.add(brokerName);
        }
    }

    void setInputQueueName(String queueName) {
        if (null != queueName && !queueName.isEmpty()) {
            this.serverQueueName = queueName;
        }
    }

    public void runOnce(boolean bootstrapMode) {
        this.bootstrapMode = bootstrapMode;
        this.competition = Competition.currentCompetition();
        if (this.simRunning) {
            log.warn("attempt to start sim on top of running sim");
            return;
        }
        this.simRunning = true;
        if (this.competition == null) {
            log.error("null competition instance");
        }
        if (!bootstrapMode) {
            this.jmsManagementService.start();
        }
        this.init();
        if (!bootstrapMode) {
            this.tournamentSchedulerService.ready();
        }
        if (!this.setup()) {
            this.simRunning = false;
            return;
        }
        this.runSimulation((long)this.competition.getTimeslotLength() * 60000L / this.competition.getSimulationRate());
        this.logBrokerStats();
        this.postBrokerStats();
        this.shutDown();
    }

    private boolean setup() {
        this.randomGen = this.randomSeedRepo.getRandomSeed("CompetitionControlService", this.competition.getId(), "game-setup");
        this.configService.configureMe(this);
        if (!this.bootstrapMode) {
            this.bootstrapOffset = this.competition.getBootstrapTimeslotCount() + this.competition.getBootstrapDiscardedTimeslots();
            this.createInitialTimeslots(this.competition.getSimulationBaseTime(), this.bootstrapOffset + 1, 0);
            log.info("created " + this.timeslotRepo.count() + " bootstrap timeslots");
        }
        this.setTimeParameters();
        this.brokerProxyService.setDeferredBroadcast(true);
        if (!this.configurePlugins()) {
            log.error("failed to configure plugins");
            return false;
        }
        this.createInitialTimeslots(this.timeService.getCurrentTime(), this.competition.getDeactivateTimeslotsAhead(), this.competition.getTimeslotsOpen());
        for (CustomerInfo customer : this.customerRepo.list()) {
            this.competition.addCustomer(customer);
        }
        this.timeslotCount = this.competition.getBootstrapTimeslotCount() + this.competition.getBootstrapDiscardedTimeslots();
        if (!this.bootstrapMode) {
            this.timeslotCount = this.computeGameLength(this.competition.getMinimumTimeslotCount(), this.competition.getExpectedTimeslotCount());
            log.info("timeslotCount = " + this.timeslotCount);
        }
        if (!this.bootstrapMode) {
            this.waitForBrokerLogin();
            this.visualizerProxyService.waitForRemoteViz(this.loginTimeout);
        }
        for (String retailer : this.brokerRepo.findRetailBrokerNames()) {
            this.competition.addBroker(retailer);
        }
        if (!this.bootstrapMode) {
            this.tournamentSchedulerService.inProgress(this.timeslotCount);
        }
        this.brokerProxyService.setDeferredBroadcast(false);
        this.brokerProxyService.broadcastMessage((Object)this.competition);
        this.brokerProxyService.broadcastMessage((Object)this.configService.getPublishedConfiguration());
        if (!this.bootstrapMode) {
            List bootstrapDataset = this.bootstrapDataRepo.getData();
            this.brokerProxyService.broadcastMessages(bootstrapDataset);
            for (Object msg : bootstrapDataset) {
                if (!(msg instanceof WeatherReport)) continue;
                this.weatherReportRepo.add((WeatherReport)msg);
            }
        }
        this.brokerProxyService.broadcastDeferredMessages();
        this.brokerProxyService.broadcastMessage((Object)this.makeTimeslotUpdate());
        return true;
    }

    private TimeslotUpdate makeTimeslotUpdate() {
        List enabled = this.timeslotRepo.enabledTimeslots();
        TimeslotUpdate msg = new TimeslotUpdate(this.timeService.getCurrentTime(), ((Timeslot)enabled.get(0)).getSerialNumber(), ((Timeslot)enabled.get(enabled.size() - 1)).getSerialNumber());
        return msg;
    }

    private synchronized void waitForBrokerLogin() {
        if (this.authorizedBrokerMap == null || this.authorizedBrokerMap.size() == 0) {
            return;
        }
        if (log.isInfoEnabled()) {
            StringBuffer msg = new StringBuffer();
            msg.append("waiting for logins from");
            for (String name : this.authorizedBrokerMap.keySet()) {
                msg.append(" ").append(name);
            }
            log.info(msg.toString());
        }
        log.info("pendingLogins.size()=" + this.pendingLogins.size() + ", loginCount=" + this.loginCount);
        if (this.loginCount == this.pendingLogins.size()) {
            try {
                this.wait(this.firstLoginTimeout);
                log.info("first login observed");
            }
            catch (InterruptedException ie) {
                this.authorizedBrokerMap.clear();
                log.info("first login wait is interrupted");
            }
        }
        try {
            for (int sz = this.authorizedBrokerMap.size(); sz >= this.authorizedBrokerMap.size() && this.authorizedBrokerMap.size() > 0; --sz) {
                this.wait(this.loginTimeout);
            }
        }
        catch (InterruptedException ie) {
            this.authorizedBrokerMap.clear();
        }
        if (this.authorizedBrokerMap.size() > 0) {
            log.warn("Some brokers did not log in: " + this.authorizedBrokerMap);
            this.authorizedBrokerMap.clear();
        }
        if (this.loginCount == this.pendingLogins.size()) {
            this.timeslotCount = 1;
        }
    }

    public synchronized boolean loginBroker(String username) {
        if (this.authorizedBrokerMap == null || this.authorizedBrokerMap.size() == 0 || !this.authorizedBrokerMap.containsKey(username)) {
            log.info("Unauthorized attempt to log in " + username);
            return false;
        }
        Broker broker = this.brokerRepo.findByUsername(username);
        log.info("Log in " + (null == broker ? "" : "existing ") + "broker " + username + ", queue " + this.authorizedBrokerMap.get(username));
        if (null == broker) {
            broker = new Broker(username);
            this.brokerRepo.add(broker);
        }
        broker.setEnabled(true);
        if (!broker.isLocal()) {
            String queueName = this.authorizedBrokerMap.get(username);
            broker.setQueueName(this.authorizedBrokerMap.get(username));
            this.jmsManagementService.createQueue(queueName);
            this.computeBrokerKey(broker);
        }
        int prefix = this.getBrokerPrefix(broker);
        broker.setIdPrefix(prefix);
        log.info("Broker " + broker.getUsername() + " key: " + broker.getKey() + ", prefix: " + prefix);
        this.brokerProxyService.sendMessage(broker, (Object)new BrokerAccept(prefix, broker.getKey()));
        this.authorizedBrokerMap.remove(username);
        if (this.pendingLogins.contains(username)) {
            --this.loginCount;
        }
        this.notifyAll();
        return true;
    }

    private int getBrokerPrefix(Broker broker) {
        return this.brokerNames.indexOf(broker.getUsername()) + 2;
    }

    private void computeBrokerKey(Broker broker) {
        long time = new Date().getTime() & 0xFFFFFFFFFFFFFFFFL;
        int hash = broker.hashCode();
        int code = (int)((long)hash * time & Integer.MAX_VALUE);
        String key = Integer.toString(code, 36);
        broker.setKey(key);
    }

    private void setTimeParameters() {
        Instant base = this.competition.getSimulationBaseTime();
        long rate = this.competition.getSimulationRate();
        this.currentSlot = 0;
        int slotCount = 0;
        if (!this.bootstrapMode) {
            slotCount = this.bootstrapOffset;
            log.info("first slot: " + slotCount);
        } else {
            log.info("bootstrapTimeslotMillis=" + this.bootstrapTimeslotMillis);
            rate = this.competition.getTimeslotDuration() / this.bootstrapTimeslotMillis;
            log.info("bootstrap mode clock rate: " + rate);
        }
        long rem = rate % (long)this.competition.getTimeslotLength();
        if (rem > 0L) {
            long mult = this.competition.getSimulationRate() / (long)this.competition.getTimeslotLength();
            log.warn("Simulation rate " + rate + " not a multiple of " + this.competition.getTimeslotLength() + "; adjust to " + (mult + 1L) * (long)this.competition.getTimeslotLength());
            rate = (mult + 1L) * (long)this.competition.getTimeslotLength();
        }
        this.timeService.setClockParameters(base.getMillis(), rate, this.competition.getTimeslotDuration());
        this.timeService.setCurrentTime(base.plus((long)slotCount * this.competition.getTimeslotDuration()));
    }

    private int computeGameLength(int minLength, int expLength) {
        if (expLength == minLength) {
            log.info("game-length fixed: " + minLength);
            return minLength;
        }
        double roll = this.randomGen.nextDouble();
        double k = Math.log(1.0 - roll) / Math.log(1.0 - 1.0 / (double)(expLength - minLength + 1));
        int length = minLength + (int)Math.floor(k);
        log.info("game-length " + length + "(k=" + k + ", roll=" + roll + ")");
        return length;
    }

    private boolean configurePlugins() {
        String success;
        List initializers = SpringApplicationContext.listBeansOfType(InitializationService.class);
        ArrayList<String> completedPlugins = new ArrayList<String>();
        ArrayList<InitializationService> deferredInitializers = new ArrayList<InitializationService>();
        for (InitializationService initializer : initializers) {
            if (this.bootstrapMode && (initializer.equals(this.visualizerProxyService) || initializer.equals(this.jmsManagementService))) {
                log.info("Skipping initialization of " + initializer.toString());
                continue;
            }
            log.info("attempt to initialize " + initializer.toString());
            success = initializer.initialize(this.competition, completedPlugins);
            if (success == null) {
                log.info("deferring " + initializer.toString());
                deferredInitializers.add(initializer);
                continue;
            }
            if (success.equals("fail")) {
                log.error("Failed to initialize plugin " + initializer.toString());
                return false;
            }
            log.info("completed " + success);
            completedPlugins.add(success);
        }
        int tryCounter = deferredInitializers.size();
        while (deferredInitializers.size() > 0 && tryCounter > 0) {
            InitializationService initializer;
            initializer = (InitializationService)deferredInitializers.get(0);
            log.info("additional attempt to initialize " + initializer.toString());
            if (deferredInitializers.size() > 1) {
                deferredInitializers.remove(0);
            } else {
                deferredInitializers.clear();
            }
            success = initializer.initialize(this.competition, completedPlugins);
            if (success == null) {
                log.info("deferring " + initializer.toString());
                deferredInitializers.add(initializer);
                --tryCounter;
                continue;
            }
            log.info("completed " + success);
            completedPlugins.add(success);
        }
        for (InitializationService initializer : deferredInitializers) {
            log.error("Failed to initialize " + initializer.toString());
        }
        return true;
    }

    private void createInitialTimeslots(Instant base, int initialSlots, int openSlots) {
        log.info("createInitialTimeslots(" + base + ", " + initialSlots + ", " + openSlots + "), at " + this.timeService.getCurrentTime());
    }

    private void logBrokerStats() {
        StringBuffer buf = new StringBuffer();
        buf.append("Final balance (brokername:balance) [");
        for (String brokerName : this.competition.getBrokers()) {
            Broker broker = this.brokerRepo.findByUsername(brokerName);
            buf.append(" \"").append(brokerName).append("\":");
            buf.append(broker.getCashBalance());
        }
        buf.append(" ]");
        log.info(buf.toString());
    }

    private void postBrokerStats() {
        this.tournamentSchedulerService.sendResults(this.composeBrokerStats());
    }

    private String composeBrokerStats() {
        StringBuffer buf = new StringBuffer();
        String delimiter = "";
        for (String brokerName : this.competition.getBrokers()) {
            Broker broker = this.brokerRepo.findByUsername(brokerName);
            buf.append(delimiter).append(brokerName).append(":");
            buf.append(broker.getCashBalance());
            delimiter = ",";
        }
        return buf.toString();
    }

    private void runSimulation(long scheduleMillis) {
        SimRunner runner = new SimRunner(this);
        runner.start();
        try {
            runner.join();
        }
        catch (InterruptedException ie) {
            log.warn("sim interrupted", (Throwable)ie);
        }
    }

    private void step() {
        if (this.checkAbort()) {
            this.stop();
            return;
        }
        Date started = new Date();
        this.clock.checkClockDrift();
        int ts = this.activateNextTimeslot();
        if (!this.running) {
            return;
        }
        Instant time = this.timeService.getCurrentTime();
        log.info("step at " + time.toString());
        this.detectAndKillHangingQueues();
        for (int index = 0; index < this.phaseRegistrations.size(); ++index) {
            log.info("activate phase " + (index + 1));
            for (TimeslotPhaseProcessor fn : this.phaseRegistrations.get(index)) {
                fn.activate(time, index + 1);
            }
        }
        TimeslotComplete msg = new TimeslotComplete(ts);
        this.brokerProxyService.broadcastMessage((Object)msg);
        Date ended = new Date();
        long elapsed = ended.getTime() - started.getTime();
        if (!this.bootstrapMode) {
            this.tournamentSchedulerService.heartbeat(ts, this.composeBrokerStats(), elapsed);
        }
        log.info("Elapsed time: " + elapsed);
        if (--this.timeslotCount <= 0) {
            log.info("Stopping simulation");
            this.stop();
        }
    }

    private void detectAndKillHangingQueues() {
        Set<String> badQueues = this.jmsManagementService.processQueues();
        if (badQueues != null && badQueues.size() > 0) {
            for (Broker broker : this.brokerRepo.list()) {
                if (!badQueues.contains(broker.toQueueName())) continue;
                log.warn("Disabling unresponsive broker " + broker.getUsername());
                broker.setEnabled(false);
            }
            if (badQueues.contains(this.visualizerProxyService.getVisualizerQueueName())) {
                this.visualizerProxyService.setRemoteVisualizer(false);
            }
        }
    }

    private boolean checkAbort() {
        File abortFile = new File(this.abortFileName);
        if (abortFile.canRead()) {
            log.warn("Abort file detected - shutting down");
            abortFile.delete();
            return true;
        }
        return false;
    }

    private int activateNextTimeslot() {
        long timeslotMillis = this.competition.getTimeslotDuration();
        Timeslot current = this.findCurrentTimeslot();
        if (current == null) {
            log.error("current timeslot is null at " + this.timeService.getCurrentTime());
            return -1;
        }
        int oldSerial = current.getSerialNumber() + this.competition.getDeactivateTimeslotsAhead() - 1;
        Timeslot oldTs = this.timeslotRepo.findBySerialNumber(oldSerial);
        log.info("Deactivated timeslot " + oldSerial + ", start " + oldTs.getStartInstant().toString());
        int newSerial = current.getSerialNumber() + this.competition.getDeactivateTimeslotsAhead() - 1 + this.competition.getTimeslotsOpen();
        Timeslot newTs = this.timeslotRepo.findBySerialNumber(newSerial);
        if (newTs == null) {
            log.info("newTS null in activateNextTimeslot");
            long start = current.getStartInstant().getMillis() + (long)(newSerial - current.getSerialNumber()) * timeslotMillis;
            newTs = this.timeslotRepo.makeTimeslot(new Instant(start));
        }
        log.info("Activated timeslot " + newSerial + ", start " + newTs.getStartInstant());
        this.brokerProxyService.broadcastMessage((Object)this.makeTimeslotUpdate());
        return current.getSerialNumber();
    }

    private synchronized Timeslot findCurrentTimeslot() {
        int expectedIndex = this.currentSlot + this.bootstrapOffset;
        Timeslot currentTimeslot = this.timeslotRepo.findBySerialNumber(expectedIndex);
        if (currentTimeslot == null) {
            return null;
        }
        Timeslot next = this.timeslotRepo.currentTimeslot();
        if (next.getSerialNumber() > expectedIndex) {
            int missingTicks = next.getSerialNumber() - expectedIndex;
            log.error("Missed " + missingTicks + " ticks - adjusting");
            this.stop();
        }
        return currentTimeslot;
    }

    public boolean isRunning() {
        return this.simRunning;
    }

    public void stop() {
        this.running = false;
    }

    public void shutDown() {
        this.running = false;
        SimEnd endMsg = new SimEnd();
        this.brokerProxyService.broadcastMessage((Object)endMsg);
        this.simRunning = false;
        if (this.clock != null) {
            this.clock.waitUntilStop();
        }
        this.jmsManagementService.stop();
        this.logService.stopLog();
    }

    public void registerTimeslotPhase(TimeslotPhaseProcessor thing, int phase) {
        if (phase <= 0 || phase > this.timeslotPhaseCount) {
            log.error("phase " + phase + " out of range (1.." + this.timeslotPhaseCount + ")");
        } else {
            if (this.phaseRegistrations == null) {
                this.phaseRegistrations = new ArrayList();
                for (int index = 0; index < this.timeslotPhaseCount; ++index) {
                    this.phaseRegistrations.add(new ArrayList());
                }
            }
            this.phaseRegistrations.get(phase - 1).add(thing);
        }
    }

    public boolean isBootstrapMode() {
        return this.bootstrapMode;
    }

    public void pause() {
        log.info("pause");
        SimPause msg = new SimPause();
        this.brokerProxyService.broadcastMessage((Object)msg);
    }

    public void resume(long newStart) {
        log.info("resume");
        SimResume msg = new SimResume(new Instant(newStart));
        this.brokerProxyService.broadcastMessage((Object)msg);
    }

    public synchronized void handleMessage(PauseRequest msg) {
        if (!this.brokerPauseAllowed) {
            log.info("Pause request by " + msg.getBroker().getUsername() + " disallowed");
            return;
        }
        if (this.pauseRequester != null) {
            log.info("Pause request by " + msg.getBroker().getUsername() + " rejected; already paused by " + this.pauseRequester);
            return;
        }
        this.pauseRequester = msg.getBroker().getUsername();
        log.info("Pause request by " + msg.getBroker().getUsername());
        this.clock.requestPause();
    }

    public synchronized void handleMessage(PauseRelease msg) {
        if (this.pauseRequester == null) {
            log.info("Release request by " + msg.getBroker().getUsername() + ", but no pause currently requested");
            return;
        }
        if (this.pauseRequester != msg.getBroker().getUsername()) {
            log.info("Release request by " + msg.getBroker().getUsername() + ", but pause request was by " + this.pauseRequester);
            return;
        }
        log.info("Pause released by " + msg.getBroker().getUsername());
        this.clock.releasePause();
        this.pauseRequester = null;
    }

    public void handleMessage(BrokerAuthentication msg) {
        log.info("receiveMessage(BrokerAuthentication) " + msg.getUsername() + ", time offset = " + (msg.getBrokerTime() - new Date().getTime()));
        this.loginBroker(msg.getUsername());
    }

    public void setBootstrapTimeslotMillis(long length) {
        this.bootstrapTimeslotMillis = length;
    }

    long getBootstrapTimeslotMillis() {
        return this.bootstrapTimeslotMillis;
    }

    class SimRunner
    extends Thread {
        CompetitionControlService parent;
        int maxSequentialExceptions = 4;

        public SimRunner(CompetitionControlService instance) {
            this.parent = instance;
        }

        @Override
        public void run() {
            int sequentialExceptions = 0;
            SimulationClockControl.initialize(this.parent, CompetitionControlService.this.timeService);
            CompetitionControlService.this.clock = SimulationClockControl.getInstance();
            long now = new Date().getTime();
            long startOffset = 0L;
            if (!CompetitionControlService.this.bootstrapMode) {
                startOffset = (long)CompetitionControlService.this.bootstrapOffset * CompetitionControlService.this.competition.getTimeslotDuration() / CompetitionControlService.this.competition.getSimulationRate();
            }
            long start = now - startOffset + 3000L;
            SimStart startMsg = new SimStart(new Instant(start));
            CompetitionControlService.this.brokerProxyService.broadcastMessage((Object)startMsg);
            CompetitionControlService.this.clock.setStart(start);
            log.info("sim start at " + CompetitionControlService.this.timeService.getCurrentTime());
            CompetitionControlService.this.timeService.init(CompetitionControlService.this.timeService.getCurrentTime());
            CompetitionControlService.this.running = true;
            CompetitionControlService.this.clock.scheduleTick();
            while (CompetitionControlService.this.running) {
                block7: {
                    log.info("Wait for tick " + CompetitionControlService.this.currentSlot);
                    CompetitionControlService.this.clock.waitForTick(CompetitionControlService.this.currentSlot);
                    try {
                        CompetitionControlService.this.step();
                        sequentialExceptions = 0;
                    }
                    catch (Exception e) {
                        try {
                            StackTraceElement[] trace = e.getStackTrace();
                            StringBuffer sb = new StringBuffer();
                            sb.append(e.toString());
                            int depth = Math.min(CompetitionControlService.this.stackTraceDepth, trace.length);
                            for (int index = 0; index < depth; ++index) {
                                sb.append("\n.. " + trace[index].toString());
                            }
                            log.error(sb.toString());
                        }
                        catch (Exception e1) {
                            log.error("Exception " + e1.toString() + " trying to log exception " + e.toString());
                        }
                        if (++sequentialExceptions < this.maxSequentialExceptions) break block7;
                        CompetitionControlService.this.running = false;
                    }
                }
                CompetitionControlService.this.currentSlot = CompetitionControlService.this.currentSlot + 1;
                CompetitionControlService.this.clock.complete();
            }
            log.info("Stop simulation");
            CompetitionControlService.this.clock.stop();
        }
    }
}

