/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class TournamentSchedulerService {
    private static Logger log = LogManager.getLogger((String)TournamentSchedulerService.class.getName());
    private String tournamentSchedulerUrl = "";
    private String interfaceUrl = "faces/serverInterface.jsp";
    private String propertiesUrl = "faces/properties.jsp";
    private String gameId = "0";

    public String getGameId() {
        return this.gameId;
    }

    public void setGameId(String gameId) {
        this.gameId = gameId;
    }

    public String getTournamentSchedulerUrl() {
        return this.tournamentSchedulerUrl;
    }

    public void setTournamentSchedulerUrl(String tournamentSchedulerUrl) {
        this.tournamentSchedulerUrl = tournamentSchedulerUrl;
    }

    public URL getBootUrl() {
        URL result = null;
        String urlString = this.tournamentSchedulerUrl + this.interfaceUrl + "?action=boot" + "&gameId=" + this.gameId;
        try {
            result = new URL(urlString);
        }
        catch (MalformedURLException e) {
            log.error("Bad URL: " + urlString);
            e.printStackTrace();
        }
        return result;
    }

    public URL getConfigUrl() {
        URL result = null;
        String urlString = this.tournamentSchedulerUrl + this.propertiesUrl + "?gameId=" + this.gameId;
        try {
            result = new URL(urlString);
        }
        catch (MalformedURLException e) {
            log.error("Bad URL: " + urlString);
            e.printStackTrace();
        }
        return result;
    }

    public void ready() {
        if (this.tournamentSchedulerUrl.isEmpty()) {
            return;
        }
        String finalUrl = this.tournamentSchedulerUrl + this.interfaceUrl + "?action=status" + "&gameId=" + this.gameId + "&status=game_ready";
        log.info("Sending game_ready to controller at: " + finalUrl);
        try {
            URL url = new URL(finalUrl);
            URLConnection conn = url.openConnection();
            conn.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Jenkins failure");
        }
    }

    public void inProgress(int gameLength) {
        if (this.tournamentSchedulerUrl.isEmpty()) {
            return;
        }
        String finalUrl = this.tournamentSchedulerUrl + this.interfaceUrl + "?action=status" + "&gameId=" + this.gameId + "&status=game_in_progress" + "&gameLength=" + gameLength;
        log.info("Sending game_in_progress message to controller at: " + finalUrl);
        try {
            URL url = new URL(finalUrl);
            URLConnection conn = url.openConnection();
            conn.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Jenkins failure");
        }
    }

    public void heartbeat(int timeslotIndex, String standings, long elapsed) {
        if (this.tournamentSchedulerUrl.isEmpty()) {
            return;
        }
        try {
            String finalUrl = this.tournamentSchedulerUrl + this.interfaceUrl + "?action=heartbeat" + "&gameId=" + this.gameId + "&message=" + timeslotIndex + "&standings=" + URLEncoder.encode(standings, "UTF-8") + "&elapsedTime=" + elapsed;
            URL url = new URL(finalUrl);
            URLConnection conn = url.openConnection();
            conn.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("heartbeat failure");
        }
    }

    public void sendResults(String results) {
        if (this.tournamentSchedulerUrl.isEmpty()) {
            return;
        }
        try {
            String finalUrl = this.tournamentSchedulerUrl + this.interfaceUrl;
            String postData = "action=gameresults&gameId=" + this.gameId + "&message=" + URLEncoder.encode(results, "UTF-8");
            URL url = new URL(finalUrl);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(postData);
            wr.flush();
            conn.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("heartbeat failure");
        }
    }
}

