/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.springframework.stereotype.Service;

@Service
public class LogService {
    private String filenamePrefix = "powertac";

    public void setPrefix(String prefix) {
        this.filenamePrefix = prefix;
    }

    public String getPrefix() {
        return this.filenamePrefix;
    }

    public Logger getStateLogger() {
        return LogManager.getLogger((String)"State");
    }

    public void startLog() {
        this.startLog(null);
    }

    public void startLog(String id) {
        try {
            String filename = this.filenamePrefix;
            if (id != null && id.length() > 0) {
                filename = filename + "-" + id;
            }
            String logDir = System.getProperty("logdir", "log");
            System.setProperty("logfile", logDir + "/" + filename + ".trace");
            System.setProperty("statefile", logDir + "/" + filename + ".state");
            ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
        }
        catch (Exception ioe) {
            System.out.println("Can't open log file");
            System.exit(0);
        }
    }

    public void stopLog() {
        this.reset();
    }

    private void reset() {
        Logger root = LogManager.getRootLogger();
        Logger state = this.getStateLogger();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration cfg = ctx.getConfiguration();
        ConsoleAppender console = ConsoleAppender.createAppender(null, null, (String)"SYSTEM_OUT", (String)"Console", (String)"true", (String)"true");
        AppenderRef[] refs = new AppenderRef[]{AppenderRef.createAppenderRef((String)"Console", null, null)};
        LoggerConfig newRoot = LoggerConfig.createLogger((String)"false", (Level)Level.OFF, (String)root.getName(), (String)"true", (AppenderRef[])refs, null, (Configuration)cfg, null);
        newRoot.addAppender((Appender)console, null, null);
        LoggerConfig newState = LoggerConfig.createLogger((String)"false", (Level)Level.OFF, (String)state.getName(), (String)"true", (AppenderRef[])refs, null, (Configuration)cfg, null);
        newState.addAppender((Appender)console, null, null);
        console.start();
        cfg.addAppender((Appender)console);
        cfg.removeLogger(root.getName());
        cfg.addLogger(root.getName(), newRoot);
        cfg.removeLogger(state.getName());
        cfg.addLogger(state.getName(), newState);
        ctx.updateLoggers(cfg);
    }
}

