/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.msg.BrokerAuthentication;
import org.powertac.util.MessageDispatcher;
import org.springframework.stereotype.Service;

@Service
public class MessageRouter
implements InitializationService {
    private static Logger log = LogManager.getLogger(MessageRouter.class);
    private HashMap<Class<?>, Set<Object>> registrations = new HashMap();

    public Set<Object> getRegistrations(Object message) {
        return this.registrations.get(message.getClass());
    }

    public void registerBrokerMessageListener(Object listener, Class<?> clazz) {
        Set<Object> targetSet = this.registrations.get(clazz);
        if (null == targetSet) {
            targetSet = new HashSet<Object>();
            this.registrations.put(clazz, targetSet);
        }
        targetSet.add(listener);
    }

    public void recycle() {
        this.registrations = new HashMap();
    }

    public String initialize(Competition competition, List<String> completedInits) {
        return "Router";
    }

    public boolean route(Object message) {
        boolean routed = false;
        boolean byPassed = message instanceof BrokerAuthentication;
        String username = "unknown";
        Broker broker = null;
        if (!byPassed) {
            try {
                broker = (Broker)PropertyUtils.getSimpleProperty((Object)message, (String)"broker");
                username = broker.getUsername();
            }
            catch (IllegalAccessException e) {
                log.error("Failed to extract broker", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error("Failed to extract broker", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.error("Failed to extract broker", (Throwable)e);
            }
        }
        if (byPassed || broker != null && broker.isEnabled()) {
            log.debug("route(Object) - routing " + message.getClass().getSimpleName() + " from " + username);
            Set<Object> targets = this.registrations.get(message.getClass());
            if (targets == null) {
                log.warn("no targets for message of type " + message.getClass().getSimpleName());
            } else {
                for (Object target : targets) {
                    MessageDispatcher.dispatch((Object)target, (String)"handleMessage", (Object[])new Object[]{message});
                }
                routed = true;
            }
        }
        log.debug("route(Object) - routed:" + routed);
        return routed;
    }
}

