/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.IdGenerator;
import org.powertac.common.TimeService;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.interfaces.BootstrapDataCollector;
import org.powertac.common.interfaces.BootstrapState;
import org.powertac.common.interfaces.CompetitionSetup;
import org.powertac.common.repo.BootstrapDataRepo;
import org.powertac.common.repo.DomainRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.server.CompetitionControlService;
import org.powertac.server.LogService;
import org.powertac.server.MessageRouter;
import org.powertac.server.ServerPropertiesService;
import org.powertac.server.TournamentSchedulerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
public class CompetitionSetupService
implements CompetitionSetup {
    private static Logger log = LogManager.getLogger(CompetitionSetupService.class);
    @Autowired
    private CompetitionControlService cc;
    @Autowired
    private BootstrapDataCollector defaultBroker;
    @Autowired
    private ServerPropertiesService serverProps;
    @Autowired
    private BootstrapDataRepo bootstrapDataRepo;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    @Autowired
    private MessageRouter messageRouter;
    @Autowired
    private XMLMessageConverter messageConverter;
    @Autowired
    private LogService logService;
    @Autowired
    private TournamentSchedulerService tss;
    @Autowired
    private TimeService timeService;
    private Competition competition;
    private int sessionCount = 0;
    private String gameId = null;
    private URL controllerURL;
    private String seedSource = null;
    private Thread session = null;

    public void processCmdLine(String[] args) {
        if (args.length > 1) {
            this.processCli(args);
            this.waitForSession();
        }
    }

    private void waitForSession() {
        if (this.session != null) {
            try {
                this.session.join();
            }
            catch (InterruptedException e) {
                System.out.println("Error waiting for session completion: " + e.toString());
            }
        }
    }

    private void processCli(String[] args) {
        OptionParser parser = new OptionParser();
        parser.accepts("sim");
        ArgumentAcceptingOptionSpec bootOutput = parser.accepts("boot").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec controllerOption = parser.accepts("control").withRequiredArg().ofType(URL.class);
        ArgumentAcceptingOptionSpec gameOpt = parser.accepts("game-id").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec serverConfigUrl = parser.accepts("config").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec logSuffixOption = parser.accepts("log-suffix").withRequiredArg();
        ArgumentAcceptingOptionSpec bootData = parser.accepts("boot-data").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec seedData = parser.accepts("random-seeds").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec weatherData = parser.accepts("weather-data").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec jmsUrl = parser.accepts("jms-url").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec inputQueue = parser.accepts("input-queue").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec brokerList = parser.accepts("brokers").withRequiredArg().withValuesSeparatedBy(',');
        OptionSet options = parser.parse(args);
        try {
            this.seedSource = null;
            String logSuffix = (String)options.valueOf((OptionSpec)logSuffixOption);
            this.controllerURL = (URL)options.valueOf((OptionSpec)controllerOption);
            String game = (String)options.valueOf((OptionSpec)gameOpt);
            String serverConfig = (String)options.valueOf((OptionSpec)serverConfigUrl);
            if (null == game) {
                log.error("gameId not given");
                game = Integer.toString(this.sessionCount);
            }
            this.gameId = game;
            if (this.controllerURL != null) {
                this.tss.setTournamentSchedulerUrl(this.controllerURL.toString());
                this.tss.setGameId(game);
                serverConfig = this.tss.getConfigUrl().toExternalForm();
            }
            if (options.has((OptionSpec)bootOutput)) {
                this.bootSession((String)options.valueOf((OptionSpec)bootOutput), serverConfig, game, logSuffix, (String)options.valueOf((OptionSpec)seedData), (String)options.valueOf((OptionSpec)weatherData));
            } else if (options.has("sim")) {
                this.simSession((String)options.valueOf((OptionSpec)bootData), serverConfig, (String)options.valueOf((OptionSpec)jmsUrl), game, logSuffix, options.valuesOf((OptionSpec)brokerList), (String)options.valueOf((OptionSpec)seedData), (String)options.valueOf((OptionSpec)weatherData), (String)options.valueOf((OptionSpec)inputQueue));
            } else {
                System.err.println("Must provide either --boot or --sim to run server");
                System.exit(1);
            }
        }
        catch (OptionException e) {
            System.err.println("Bad command argument: " + e.toString());
        }
    }

    private void setLogSuffix(String logSuffix, String defaultSuffix) throws IOException {
        if (logSuffix == null) {
            logSuffix = defaultSuffix;
        }
        this.serverProps.setProperty("server.logfileSuffix", logSuffix);
    }

    public String bootSession(String bootFilename, String config, String game, String logSuffix, String seedData, String weatherData) {
        String error = null;
        try {
            log.info("bootSession: bootFilename=" + bootFilename + ", config=" + config + ", game=" + game + ", logSuffix=" + logSuffix);
            this.serverProps.recycle();
            this.setConfigMaybe(config);
            this.useWeatherDataMaybe(weatherData, true);
            this.seedSource = seedData;
            this.loadTimeslotCountsMaybe();
            this.ensureGameId(game);
            this.setLogSuffix(logSuffix, "boot-" + this.gameId);
            File bootFile = new File(bootFilename);
            if (!bootFile.getAbsoluteFile().getParentFile().canWrite()) {
                error = "Cannot write to bootstrap data file " + bootFilename;
                System.out.println(error);
            } else {
                this.startBootSession(bootFile);
            }
        }
        catch (NullPointerException npe) {
            error = "Bootstrap filename not given";
        }
        catch (MalformedURLException e) {
            error = "Malformed URL: " + e.toString();
            System.out.println(error);
        }
        catch (IOException e) {
            error = "Error reading configuration";
        }
        catch (ConfigurationException e) {
            error = "Error setting configuration";
        }
        return error;
    }

    public String simSession(String bootData, String config, String jmsUrl, String game, String logSuffix, List<String> brokerUsernames, String seedData, String weatherData, String inputQueueName) {
        String error = null;
        try {
            log.info("simSession: bootData=" + bootData + ", config=" + config + ", jmsUrl=" + jmsUrl + ", game=" + game + ", logSuffix=" + logSuffix + ", seedData=" + seedData + ", weatherData=" + weatherData + ", inputQueue=" + inputQueueName);
            this.serverProps.recycle();
            this.setConfigMaybe(config);
            this.useWeatherDataMaybe(weatherData, false);
            this.seedSource = seedData;
            this.loadTimeslotCountsMaybe();
            this.ensureGameId(game);
            this.setLogSuffix(logSuffix, "sim-" + this.gameId);
            if (jmsUrl != null) {
                this.serverProps.setProperty("server.jmsManagementService.jmsBrokerUrl", jmsUrl);
            }
            URL bootUrl = null;
            if (this.controllerURL != null) {
                bootUrl = this.tss.getBootUrl();
            } else if (bootData != null) {
                if (!bootData.contains(":")) {
                    bootData = "file:" + bootData;
                }
                bootUrl = new URL(bootData);
            }
            if (null == bootUrl) {
                error = "bootstrap data source not given";
                System.out.println(error);
            } else {
                log.info("bootUrl=" + bootUrl.toExternalForm());
                this.startSimSession(brokerUsernames, inputQueueName, bootUrl);
            }
        }
        catch (MalformedURLException e) {
            error = "Malformed URL: " + e.toString();
            System.out.println(error);
        }
        catch (IOException e) {
            error = "Error reading configuration " + config;
        }
        catch (ConfigurationException e) {
            error = "Error setting configuration " + config;
        }
        return error;
    }

    private void setConfigMaybe(String config) throws ConfigurationException, IOException {
        if (config == null) {
            return;
        }
        log.info("Reading configuration from " + config);
        this.serverProps.setUserConfig(this.makeUrl(config));
    }

    private void loadTimeslotCountsMaybe() {
        if (this.seedSource == null) {
            return;
        }
        log.info("Getting minimumTimeslotCount and expectedTimeslotCount from " + this.seedSource);
        int minCount = -1;
        int expCount = -1;
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.seedSource));
            while ((line = br.readLine()) != null) {
                String[] s;
                if (line.contains("withMinimumTimeslotCount")) {
                    s = line.split("::");
                    minCount = Integer.valueOf(s[s.length - 1]);
                }
                if (line.contains("withExpectedTimeslotCount")) {
                    s = line.split("::");
                    expCount = Integer.valueOf(s[s.length - 1]);
                }
                if (minCount == -1 || expCount == -1) continue;
            }
            br.close();
            if (minCount != -1) {
                this.serverProps.setProperty("common.competition.minimumTimeslotCount", minCount);
            }
            if (expCount != -1) {
                this.serverProps.setProperty("common.competition.expectedTimeslotCount", expCount);
            }
        }
        catch (IOException e) {
            log.error("Cannot load minimumTimeslotCount and expectedTimeslotCount from " + this.seedSource);
        }
    }

    private void loadSeedsMaybe() {
        if (this.seedSource == null) {
            return;
        }
        log.info("Reading random seeds from " + this.seedSource);
        try {
            InputStreamReader stream = new InputStreamReader(this.makeUrl(this.seedSource).openStream());
            this.randomSeedRepo.loadSeeds(stream);
        }
        catch (Exception e) {
            log.error("Cannot load seeds from " + this.seedSource);
        }
    }

    private void useWeatherDataMaybe(String weatherData, boolean bootstrapMode) {
        if (weatherData == null || weatherData.isEmpty()) {
            return;
        }
        log.info("Getting BaseTime from " + weatherData);
        String baseTime = null;
        if (weatherData.endsWith(".xml")) {
            baseTime = this.getBaseTimeXML(weatherData);
        } else if (weatherData.endsWith(".state")) {
            baseTime = this.getBaseTimeState(weatherData);
        } else {
            log.warn("Only XML and state files are allowed for weather data");
        }
        if (baseTime != null) {
            if (bootstrapMode) {
                this.serverProps.setProperty("common.competition.simulationBaseTime", baseTime);
            }
            this.serverProps.setProperty("server.weatherService.weatherData", weatherData);
        }
    }

    private String getBaseTimeXML(String weatherData) {
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse(weatherData);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            XPathExpression expr = xPath.compile("/data/weatherReports/weatherReport/@date");
            String earliest = "ZZZZ-ZZ-ZZ";
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                String date = nodes.item(i).toString().split(" ")[0].split("\"")[1];
                earliest = date.compareTo(earliest) < 0 ? date : earliest;
            }
            return earliest;
        }
        catch (Exception e) {
            log.error("Error extracting BaseTime from : " + weatherData);
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBaseTimeState(String weatherData) {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(this.makeUrl(weatherData).openStream()));
            while ((line = br.readLine()) != null) {
                if (!line.contains("withSimulationBaseTime")) continue;
                String millis = line.substring(line.lastIndexOf("::") + 2);
                Date date = new Date(Long.parseLong(millis));
                String string = new SimpleDateFormat("yyyy-MM-dd").format(date.getTime());
                return string;
            }
        }
        catch (Exception e) {
            log.error("Error extracting BaseTime from : " + weatherData);
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        log.error("Error extracting BaseTime from : " + weatherData);
        log.error("No 'withSimulationBaseTime' found!");
        return null;
    }

    private URL makeUrl(String name) throws MalformedURLException {
        String urlName = name;
        if (!urlName.contains(":")) {
            urlName = "file:" + urlName;
        }
        return new URL(urlName);
    }

    private void startBootSession(File bootstrapFile) throws IOException {
        final FileWriter bootWriter = new FileWriter(bootstrapFile);
        this.session = new Thread(){

            @Override
            public void run() {
                CompetitionSetupService.this.cc.setAuthorizedBrokerList(new ArrayList<String>());
                CompetitionSetupService.this.preGame();
                CompetitionSetupService.this.cc.runOnce(true);
                CompetitionSetupService.this.saveBootstrapData(bootWriter);
            }
        };
        this.session.start();
    }

    private void startSimSession(final List<String> brokers, final String inputQueueName, final URL bootUrl) {
        this.session = new Thread(){

            @Override
            public void run() {
                CompetitionSetupService.this.cc.setAuthorizedBrokerList(brokers);
                CompetitionSetupService.this.cc.setInputQueueName(inputQueueName);
                Document document = CompetitionSetupService.this.getDocument(bootUrl);
                if (document != null && CompetitionSetupService.this.preGame(document)) {
                    CompetitionSetupService.this.bootstrapDataRepo.add((List)CompetitionSetupService.this.processBootDataset(document));
                    CompetitionSetupService.this.cc.runOnce(false);
                    CompetitionSetupService.this.nextGameId();
                }
            }
        };
        this.session.start();
    }

    private Document getDocument(URL bootUrl) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(bootUrl.openStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    private void ensureGameId(String game) {
        this.gameId = null == game ? Integer.toString(this.sessionCount) : game;
    }

    private void nextGameId() {
        ++this.sessionCount;
        this.gameId = Integer.toString(this.sessionCount);
    }

    public void preGame() {
        String suffix = this.serverProps.getProperty("server.logfileSuffix", "x");
        this.logService.startLog(suffix);
        this.extractPomId();
        log.info("preGame() - start game " + this.gameId);
        log.info("POM version ID: {}", (Object)this.serverProps.getProperty("common.competition.pomId"));
        IdGenerator.recycle();
        this.competition = Competition.newInstance((String)this.gameId);
        Competition.setCurrent((Competition)this.competition);
        log.info("pre-game initialization");
        this.configureCompetition(this.competition);
        this.timeService.setClockParameters(this.competition);
        this.timeService.setCurrentTime(this.competition.getSimulationBaseTime());
        List repos = SpringApplicationContext.listBeansOfType(DomainRepo.class);
        log.debug("found " + repos.size() + " repos");
        for (DomainRepo repo : repos) {
            repo.recycle();
        }
        this.messageRouter.recycle();
        this.loadSeedsMaybe();
    }

    private void configureCompetition(Competition competition) {
        this.serverProps.configureMe(competition);
    }

    private boolean preGame(Document document) {
        log.info("preGame(File) - start");
        this.preGame();
        Competition bootstrapCompetition = this.readBootRecord(document);
        if (null == bootstrapCompetition) {
            return false;
        }
        Competition.currentCompetition().update(bootstrapCompetition);
        this.timeService.setClockParameters(this.competition);
        this.timeService.setCurrentTime(this.competition.getSimulationBaseTime());
        return true;
    }

    Competition readBootRecord(Document document) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        Competition bootstrapCompetition = null;
        try {
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/config/competition");
            NodeList nodes = (NodeList)exp.evaluate(document, XPathConstants.NODESET);
            String xml = this.nodeToString(nodes.item(0));
            bootstrapCompetition = (Competition)this.messageConverter.fromXML(xml);
            exp = xPath.compile("/powertac-bootstrap-data/bootstrap-state/properties");
            nodes = (NodeList)exp.evaluate(document, XPathConstants.NODESET);
            if (null != nodes && nodes.getLength() > 0) {
                xml = this.nodeToString(nodes.item(0));
                Properties bootState = (Properties)this.messageConverter.fromXML(xml);
                this.serverProps.addProperties(bootState);
            }
        }
        catch (XPathExpressionException xee) {
            log.error("preGame: Error reading boot dataset: " + xee.toString());
            System.out.println("preGame: Error reading boot dataset: " + xee.toString());
        }
        return bootstrapCompetition;
    }

    void saveBootstrapData(Writer datasetWriter) {
        BufferedWriter output = new BufferedWriter(datasetWriter);
        List data = this.defaultBroker.collectBootstrapData(this.competition.getBootstrapTimeslotCount());
        try {
            output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            output.newLine();
            output.write("<powertac-bootstrap-data>");
            output.newLine();
            output.write("<config>");
            output.newLine();
            output.write(this.messageConverter.toXML((Object)this.competition));
            output.newLine();
            output.write("</config>");
            output.newLine();
            output.write("<bootstrap-state>");
            output.newLine();
            output.write(this.gatherBootstrapState());
            output.newLine();
            output.write("</bootstrap-state>");
            output.newLine();
            output.write("<bootstrap>");
            output.newLine();
            for (Object item : data) {
                output.write(this.messageConverter.toXML(item));
                output.newLine();
            }
            output.write("</bootstrap>");
            output.newLine();
            output.write("</powertac-bootstrap-data>");
            output.newLine();
            output.close();
        }
        catch (IOException ioe) {
            log.error("Error writing bootstrap file: " + ioe.toString());
        }
    }

    private String gatherBootstrapState() {
        List collectors = SpringApplicationContext.listBeansOfType(BootstrapState.class);
        for (BootstrapState collector : collectors) {
            collector.saveBootstrapState();
        }
        Properties result = this.serverProps.getBootstrapState();
        String output = this.messageConverter.toXML((Object)result);
        return output;
    }

    private ArrayList<Object> processBootDataset(Document document) {
        ArrayList<Object> result = new ArrayList<Object>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/bootstrap/*");
            NodeList nodes = (NodeList)exp.evaluate(document, XPathConstants.NODESET);
            log.info("Found " + nodes.getLength() + " bootstrap nodes");
            for (int i = 0; i < nodes.getLength(); ++i) {
                String xml = this.nodeToString(nodes.item(i));
                Object msg = this.messageConverter.fromXML(xml);
                result.add(msg);
            }
        }
        catch (XPathExpressionException xee) {
            log.error("runOnce: Error reading config file: " + xee.toString());
        }
        return result;
    }

    private String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "no");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            log.error("nodeToString Transformer Exception " + te.toString());
        }
        return sw.toString();
    }

    private void extractPomId() {
        try {
            Properties props = new Properties();
            InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/org.powertac/server-main/pom.properties");
            if (null != is) {
                props.load(is);
                this.serverProps.setProperty("common.competition.pomId", props.getProperty("version"));
            }
        }
        catch (Exception e) {
            log.error("Failed to load properties from manifest");
        }
    }
}

