/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.config.ConfigurationRecorder;
import org.powertac.common.config.Configurator;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.ServerProperties;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class ServerPropertiesService
implements ServerProperties,
ServerConfiguration,
ApplicationContextAware {
    private static Logger log = LogManager.getLogger(ServerPropertiesService.class);
    private ApplicationContext context;
    private CompositeConfiguration config;
    private Configurator configurator;
    private ConfigurationPublisher publisher;
    private ConfigurationPublisher bootstrapStateRecorder = null;
    private boolean initialized = false;
    private String[] excludedPaths = new String[]{".*/test-classes/.*", ".*/log4j2*.xml"};

    public ServerPropertiesService() {
        this.recycle();
    }

    public void recycle() {
        this.config = new CompositeConfiguration();
        this.configurator = new Configurator();
        this.publisher = new ConfigurationPublisher();
        this.bootstrapStateRecorder = null;
        this.initialized = false;
    }

    void lazyInit() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        log.info("lazyInit");
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.exists() && !file.isDirectory() && !file.getName().equals("server.properties");
            }
        };
        File[] files = new File("config/").listFiles(filter);
        if (files != null) {
            for (File file : files) {
                try {
                    if (file.toString().endsWith(".xml")) {
                        log.debug("adding " + file.getName());
                        this.config.addConfiguration((Configuration)Configurator.readXML((File)file));
                        continue;
                    }
                    if (!file.toString().endsWith(".properties")) continue;
                    log.debug("adding " + file.getName());
                    this.config.addConfiguration((Configuration)Configurator.readProperties((File)file));
                }
                catch (Exception e) {
                    log.warn("Unable to load properties file: " + file);
                }
            }
        }
        try {
            File defaultProps = new File("config/server.properties");
            if (defaultProps.canRead()) {
                log.debug("adding " + defaultProps.getName());
                this.config.addConfiguration((Configuration)Configurator.readProperties((File)defaultProps));
            }
        }
        catch (Exception e1) {
            log.warn("config/server.properties not found: " + e1.toString());
        }
        try {
            Resource[] propResources;
            Resource[] xmlResources;
            for (Resource xml : xmlResources = this.context.getResources("classpath*:config/*.xml")) {
                if (!this.validXmlResource(xml)) continue;
                log.info("loading config from " + xml.getURI());
                this.config.addConfiguration((Configuration)Configurator.readXML((URL)xml.getURL()));
            }
            for (Resource prop : propResources = this.context.getResources("classpath*:config/*.properties")) {
                if (!this.validPropResource(prop)) continue;
                log.info("loading config from " + prop.getURI());
                this.config.addConfiguration((Configuration)Configurator.readProperties((URL)prop.getURL()));
            }
        }
        catch (Exception e) {
            log.error("Error loading configuration: " + e.toString());
        }
        this.configurator.setConfiguration((AbstractConfiguration)this.config);
    }

    public void setUserConfig(URL userConfigURL) throws ConfigurationException, IOException {
        this.config.addConfiguration((Configuration)Configurator.readProperties((URL)userConfigURL));
        log.debug("setUserConfig " + userConfigURL);
        this.lazyInit();
    }

    public void addProperties(Properties props) {
        this.lazyInit();
        for (Object key : props.keySet()) {
            Object value = props.get(key);
            if (value instanceof String && ((String)value).startsWith("[")) {
                String str = (String)value;
                value = str.substring(1, str.length() - 2);
            }
            this.config.setProperty((String)key, value);
        }
    }

    public void configureMe(Object target) {
        this.lazyInit();
        this.configurator.configureSingleton(target);
    }

    public Collection<?> configureInstances(Class<?> target) {
        this.lazyInit();
        Collection result = this.configurator.configureInstances(target);
        return result;
    }

    public Collection<?> configureNamedInstances(List<?> instances) {
        this.lazyInit();
        return this.configurator.configureNamedInstances(instances);
    }

    public void publishConfiguration(Object target) {
        this.configurator.gatherPublishedConfiguration(target, (ConfigurationRecorder)this.publisher);
    }

    public Properties getPublishedConfiguration() {
        log.debug("published config: " + this.publisher.getConfig());
        return this.publisher.getConfig();
    }

    public void saveBootstrapState(Object thing) {
        if (null == this.bootstrapStateRecorder) {
            this.bootstrapStateRecorder = new ConfigurationPublisher();
        }
        this.configurator.gatherBootstrapState(thing, (ConfigurationRecorder)this.bootstrapStateRecorder);
    }

    public Properties getBootstrapState() {
        if (null == this.bootstrapStateRecorder) {
            return new Properties();
        }
        return this.bootstrapStateRecorder.getConfig();
    }

    public String getProperty(String name) {
        this.lazyInit();
        return this.config.getString(name);
    }

    public String getProperty(String name, String defaultValue) {
        this.lazyInit();
        return this.config.getString(name, defaultValue);
    }

    public Integer getIntegerProperty(String name, Integer defaultValue) {
        this.lazyInit();
        return this.config.getInteger(name, defaultValue);
    }

    public Double getDoubleProperty(String name, Double defaultValue) {
        this.lazyInit();
        return this.config.getDouble(name, defaultValue);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setProperty(String key, Object value) {
        this.lazyInit();
        this.config.setProperty(key, value);
    }

    private boolean validXmlResource(Resource xml) {
        log.debug("resource class: " + xml.getClass().getName());
        try {
            String path = xml.getURI().toString();
            for (String regex : this.excludedPaths) {
                if (!path.matches(regex)) continue;
                log.debug("invalid path " + path);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            log.error("Should not happen: " + e.toString());
            return false;
        }
    }

    private boolean validPropResource(Resource prop) {
        return this.validXmlResource(prop);
    }

    void allowTestPaths() {
        this.excludedPaths = new String[]{".*/log4j2*.xml"};
    }

    Configuration getConfig() {
        return this.config;
    }

    class ConfigurationPublisher
    implements ConfigurationRecorder {
        Properties publishedConfig = new Properties();

        ConfigurationPublisher() {
        }

        public void recordItem(String key, Object value) {
            this.publishedConfig.put(key, value);
        }

        Properties getConfig() {
            return this.publishedConfig;
        }
    }
}

