/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.springframework.stereotype.Service;

@Service
public class LogService {
    private String filenamePrefix = "powertac";

    public void setPrefix(String prefix) {
        this.filenamePrefix = prefix;
    }

    public String getPrefix() {
        return this.filenamePrefix;
    }

    public Logger getStateLogger() {
        return LogManager.getLogger((String)"State");
    }

    public void startLog() {
        this.startLog(null);
    }

    public void startLog(String id) {
        try {
            String filename = this.filenamePrefix;
            if (id != null && id.length() > 0) {
                filename = filename + "-" + id;
            }
            String logDir = System.getProperty("logdir", "log");
            System.setProperty("logfile", logDir + "/" + filename + ".trace");
            System.setProperty("statefile", logDir + "/" + filename + ".state");
            ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
        }
        catch (Exception ioe) {
            System.out.println("Can't open log file");
            System.exit(0);
        }
    }

    public void stopLog() {
        System.getProperties().remove("logfile");
        System.getProperties().remove("statefile");
        ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
    }
}

