/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.WeatherForecast;
import org.powertac.common.WeatherForecastPrediction;
import org.powertac.common.WeatherReport;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.exceptions.PowerTacException;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.repo.WeatherForecastRepo;
import org.powertac.common.repo.WeatherReportRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
public class WeatherService
extends TimeslotPhaseProcessor
implements InitializationService {
    private static Logger log = LogManager.getLogger(WeatherService.class);
    @ConfigurableValue(valueType="String", bootstrapState=true, description="Location of weather data to be reported")
    private String weatherLocation = "rotterdam";
    @ConfigurableValue(valueType="String", bootstrapState=true, description="Location of weather server rest url")
    private String serverUrl = "http://weather.powertac.org:8080/WeatherServer/faces/index.xhtml";
    @ConfigurableValue(valueType="Boolean", description="If network calls to weather server should block until finished")
    private boolean blocking = true;
    @ConfigurableValue(valueType="String", description="Location of weather file (XML or state) or URL (state)")
    private String weatherData = "";
    @ConfigurableValue(valueType="Integer", description="Timeslot interval to make requests")
    private int weatherReqInterval = 24;
    @ConfigurableValue(valueType="Integer", description="Length of forecasts (in hours)")
    private int forecastHorizon = 24;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private WeatherReportRepo weatherReportRepo;
    @Autowired
    private WeatherForecastRepo weatherForecastRepo;
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private ServerConfiguration serverProps;
    private List<DateTime> aheadDays;
    private DateTime simulationBaseTime;
    private int daysAhead = 3;

    public int getWeatherReqInterval() {
        return this.weatherReqInterval;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public int getForecastHorizon() {
        return this.forecastHorizon;
    }

    private String dateString(DateTime dateTime) {
        int y = dateTime.get(DateTimeFieldType.year());
        int m = dateTime.get(DateTimeFieldType.monthOfYear());
        int d = dateTime.get(DateTimeFieldType.dayOfMonth());
        int h = dateTime.get(DateTimeFieldType.clockhourOfDay()) % 24;
        return String.format("%04d%02d%02d%02d", y, m, d, h);
    }

    private String dateStringLong(DateTime dateTime) {
        int y = dateTime.get(DateTimeFieldType.year());
        int m = dateTime.get(DateTimeFieldType.monthOfYear());
        int d = dateTime.get(DateTimeFieldType.dayOfMonth());
        int h = dateTime.get(DateTimeFieldType.clockhourOfDay()) % 24;
        return String.format("%04d-%02d-%02d %02d:00", y, m, d, h);
    }

    private int getTimeIndex(DateTime dateTime) {
        if (this.simulationBaseTime == null) {
            this.simulationBaseTime = this.timeslotRepo.currentTimeslot().getStartTime();
        }
        long diff = dateTime.getMillis() - this.simulationBaseTime.getMillis();
        return (int)(diff / 3600000L);
    }

    public void activate(Instant time, int phaseNumber) {
        long msec = time.getMillis();
        if (msec % ((long)this.getWeatherReqInterval() * 3600000L) != 0L) {
            log.info("WeatherService reports not time to grab weather data.");
        } else {
            log.info("Timeslot " + this.timeslotRepo.currentTimeslot().getId() + " WeatherService reports time to make request for weather data");
            DateTime dateTime = this.timeslotRepo.currentTimeslot().getStartTime();
            if (this.blocking) {
                WeatherRequester wr = new WeatherRequester(dateTime);
                wr.run();
            } else {
                this.aheadDays.add(dateTime.plusDays(this.daysAhead));
                while (this.aheadDays.size() > 0) {
                    WeatherRequester wr = new WeatherRequester(this.aheadDays.remove(0));
                    new Thread(wr).start();
                }
            }
        }
        this.broadcastWeatherReports();
        this.broadcastWeatherForecasts();
    }

    private void broadcastWeatherReports() {
        WeatherReport report = null;
        try {
            report = this.weatherReportRepo.currentWeatherReport();
        }
        catch (PowerTacException e) {
            log.error("Weather Service reports Weather Report Repo empty");
        }
        if (report == null) {
            log.error("null weather-report for : " + this.timeslotRepo.currentSerialNumber() + " " + this.timeslotRepo.currentTimeslot());
            this.brokerProxyService.broadcastMessage((Object)new WeatherReport(this.timeslotRepo.currentSerialNumber(), 0.0, 0.0, 0.0, 0.0));
        } else {
            this.brokerProxyService.broadcastMessage((Object)report);
        }
    }

    private void broadcastWeatherForecasts() {
        WeatherForecast forecast = null;
        try {
            forecast = this.weatherForecastRepo.currentWeatherForecast();
        }
        catch (PowerTacException e) {
            log.error("Weather Service reports Weather Forecast Repo emtpy");
        }
        if (forecast == null) {
            log.error("null weather-forecast for : " + this.timeslotRepo.currentSerialNumber() + " " + this.timeslotRepo.currentTimeslot());
            ArrayList<WeatherForecastPrediction> currentPredictions = new ArrayList<WeatherForecastPrediction>();
            for (int j = 1; j <= this.getForecastHorizon(); ++j) {
                currentPredictions.add(new WeatherForecastPrediction(j, 0.0, 0.0, 0.0, 0.0));
            }
            this.brokerProxyService.broadcastMessage((Object)new WeatherForecast(this.timeslotRepo.currentSerialNumber(), currentPredictions));
        } else {
            this.brokerProxyService.broadcastMessage((Object)forecast);
        }
    }

    public String initialize(Competition competition, List<String> completedInits) {
        super.init();
        this.aheadDays = new CopyOnWriteArrayList<DateTime>();
        this.serverProps.configureMe((Object)this);
        this.weatherReqInterval = Math.min(24, this.weatherReqInterval);
        this.simulationBaseTime = competition.getSimulationBaseTime().toDateTime();
        if (this.weatherData != null && (this.weatherData.endsWith(".xml") || this.weatherData.endsWith(".state"))) {
            log.info("read from file in blocking mode");
            this.blocking = true;
        }
        if (!this.blocking) {
            DateTime dateTime = this.timeslotRepo.currentTimeslot().getStartTime();
            for (int i = 0; i < this.daysAhead; ++i) {
                WeatherRequester weatherRequester = new WeatherRequester(dateTime);
                weatherRequester.run();
                dateTime = dateTime.plusDays(1);
            }
        }
        return "WeatherService";
    }

    private class StateFileExtractor {
        private URL weatherSource = null;
        private String report = "org.powertac.common.WeatherReport";
        private String forecast = "org.powertac.common.WeatherForecastPrediction";

        public StateFileExtractor(String weatherData) {
            try {
                String urlName = weatherData;
                if (!urlName.contains(":")) {
                    urlName = "file:" + urlName;
                }
                this.weatherSource = new URL(urlName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Data extractData() {
            int startIndex = WeatherService.this.timeslotRepo.currentSerialNumber();
            if (this.weatherSource == null) {
                return null;
            }
            BufferedReader br = null;
            try {
                String line;
                Data data = new Data();
                br = new BufferedReader(new InputStreamReader(this.weatherSource.openStream()));
                boolean inRange = false;
                int timeIndex = startIndex;
                while ((line = br.readLine()) != null) {
                    if (!line.contains(this.report) && !line.contains(this.forecast)) continue;
                    String[] temp = line.split("::");
                    if (line.contains(this.report)) {
                        int stamp = Integer.parseInt(temp[3]);
                        if (stamp < startIndex) continue;
                        if (stamp >= startIndex + WeatherService.this.weatherReqInterval) {
                            log.error("Forecast underflow: " + data.getWeatherForecasts().size());
                            break;
                        }
                        inRange = true;
                        data.getWeatherReports().add(new WeatherReport(timeIndex, Double.parseDouble(temp[4]), Double.parseDouble(temp[5]), Double.parseDouble(temp[6]), Double.parseDouble(temp[7])));
                        ++timeIndex;
                    } else if (inRange && line.contains(this.forecast)) {
                        data.getWeatherForecasts().add(new WeatherForecastPrediction(Integer.parseInt(temp[3]), Double.parseDouble(temp[4]), Double.parseDouble(temp[5]), Double.parseDouble(temp[6]), Double.parseDouble(temp[7])));
                    }
                    if (data.getWeatherForecasts().size() != WeatherService.this.weatherReqInterval * WeatherService.this.forecastHorizon) continue;
                    break;
                }
                Data data2 = data;
                return data2;
            }
            catch (Exception e) {
                e.printStackTrace();
                Data data = null;
                return data;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private class WeatherXmlExtractor {
        private NodeList nodeListRead = null;
        private Document documentWrite;
        private Element weatherReports;
        private Element weatherForecasts;

        public WeatherXmlExtractor(String fileName) {
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilderRead = docBuilderFactory.newDocumentBuilder();
                Document documentRead = docBuilderRead.parse(new File(fileName));
                Element rootNode = documentRead.getDocumentElement();
                this.nodeListRead = rootNode.getChildNodes();
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilderWrite = docFactory.newDocumentBuilder();
                this.documentWrite = docBuilderWrite.newDocument();
                this.documentWrite.setXmlStandalone(true);
                Element rootElement = this.documentWrite.createElement("data");
                this.documentWrite.appendChild(rootElement);
                this.weatherReports = this.documentWrite.createElement("weatherReports");
                rootElement.appendChild(this.weatherReports);
                this.weatherForecasts = this.documentWrite.createElement("weatherForecasts");
                rootElement.appendChild(this.weatherForecasts);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private String extractPartialXml(DateTime requestDate) {
            if (this.nodeListRead == null) {
                return null;
            }
            try {
                int i;
                for (i = 0; i < this.nodeListRead.getLength(); ++i) {
                    Node currentNode = this.nodeListRead.item(i);
                    if (!currentNode.getNodeName().equals("weatherReports")) continue;
                    NodeList nodeListReports = currentNode.getChildNodes();
                    this.findReports(nodeListReports, WeatherService.this.dateStringLong(requestDate));
                }
                for (i = 0; i < WeatherService.this.weatherReqInterval; ++i) {
                    for (int j = 0; j < this.nodeListRead.getLength(); ++j) {
                        Node currentNode = this.nodeListRead.item(j);
                        if (!currentNode.getNodeName().equals("weatherForecasts")) continue;
                        String origin = WeatherService.this.dateStringLong(requestDate.plusHours(i));
                        NodeList nodes = currentNode.getChildNodes();
                        this.findForecasts(nodes, origin);
                    }
                }
                if (this.weatherReports.getChildNodes().getLength() != WeatherService.this.weatherReqInterval || this.weatherForecasts.getChildNodes().getLength() != WeatherService.this.weatherReqInterval * WeatherService.this.forecastHorizon) {
                    return null;
                }
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                StringWriter buffer = new StringWriter();
                transformer.transform(new DOMSource(this.documentWrite), new StreamResult(buffer));
                return buffer.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private void findReports(NodeList nodes, String startDate) {
            for (int j = 0; j < nodes.getLength(); ++j) {
                String date;
                Node report = nodes.item(j);
                if (!report.getNodeName().equals("weatherReport") || (date = ((Element)report).getAttribute("date")).compareTo(startDate) < 0) continue;
                Node temp = this.documentWrite.importNode(report, true);
                this.weatherReports.appendChild(temp);
                if (this.weatherReports.getChildNodes().getLength() == WeatherService.this.weatherReqInterval) break;
            }
        }

        private void findForecasts(NodeList nodes, String target) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                String origin;
                Node forecast = nodes.item(i);
                if (!forecast.getNodeName().equals("weatherForecast") || !(origin = ((Element)forecast).getAttribute("origin")).equals(target)) continue;
                Node temp = this.documentWrite.importNode(forecast, true);
                this.weatherForecasts.appendChild(temp);
            }
        }
    }

    private class Data {
        private List<WeatherReport> weatherReports = new ArrayList<WeatherReport>();
        private List<WeatherForecastPrediction> weatherForecasts = new ArrayList<WeatherForecastPrediction>();
        private List<EnergyReport> energyReports = new ArrayList<EnergyReport>();

        private Data() {
        }

        public List<WeatherReport> getWeatherReports() {
            return this.weatherReports;
        }

        public List<WeatherForecastPrediction> getWeatherForecasts() {
            return this.weatherForecasts;
        }

        public List<EnergyReport> getEnergyReports() {
            return this.energyReports;
        }
    }

    private class EnergyReport {
        private EnergyReport() {
        }
    }

    private class WeatherForecastConverter
    implements Converter {
        public boolean canConvert(Class clazz) {
            return clazz.equals(WeatherForecastPrediction.class);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String id = reader.getAttribute("id");
            String temp = reader.getAttribute("temp");
            String wind = reader.getAttribute("windspeed");
            String dir = reader.getAttribute("winddir");
            String cloudCvr = reader.getAttribute("cloudcover");
            return new WeatherForecastPrediction(Integer.parseInt(id), Double.parseDouble(temp), Double.parseDouble(wind), Double.parseDouble(dir), Double.parseDouble(cloudCvr));
        }
    }

    private class WeatherReportConverter
    implements Converter {
        private int timeIndex;

        public WeatherReportConverter(DateTime requestDate) {
            this.timeIndex = WeatherService.this.getTimeIndex(requestDate);
        }

        public boolean canConvert(Class clazz) {
            return clazz.equals(WeatherReport.class);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String temp = reader.getAttribute("temp");
            String wind = reader.getAttribute("windspeed");
            String dir = reader.getAttribute("winddir");
            String cloudCvr = reader.getAttribute("cloudcover");
            return new WeatherReport(this.timeIndex++, Double.parseDouble(temp), Double.parseDouble(wind), Double.parseDouble(dir), Double.parseDouble(cloudCvr));
        }
    }

    private class WeatherRequester
    implements Runnable {
        private DateTime requestDate;

        public WeatherRequester(DateTime requestDate) {
            this.requestDate = requestDate;
        }

        @Override
        public void run() {
            String currentMethod = "";
            try {
                Data data = null;
                if (WeatherService.this.weatherData != null && WeatherService.this.weatherData.endsWith(".xml")) {
                    currentMethod = "xml file";
                    WeatherXmlExtractor wxe = new WeatherXmlExtractor(WeatherService.this.weatherData);
                    String weatherXml = wxe.extractPartialXml(this.requestDate);
                    data = this.parseXML(weatherXml);
                } else if (WeatherService.this.weatherData != null && WeatherService.this.weatherData.endsWith(".state")) {
                    currentMethod = "state file";
                    StateFileExtractor sfe = new StateFileExtractor(WeatherService.this.weatherData);
                    data = sfe.extractData();
                }
                if (data == null) {
                    currentMethod = "web";
                    data = this.webRequest();
                }
                this.processData(data);
                log.debug("Got data via a " + currentMethod + " request");
            }
            catch (Exception e) {
                log.error("Unable to get weather from weather : " + currentMethod);
                if (!WeatherService.this.blocking) {
                    log.warn("Retrying : " + WeatherService.this.dateStringLong(this.requestDate));
                    WeatherService.this.aheadDays.add(this.requestDate);
                }
                log.error(e.getMessage());
            }
        }

        private Data webRequest() {
            String queryDate = WeatherService.this.dateString(this.requestDate);
            log.info("Query datetime value for REST call: " + queryDate);
            String urlString = String.format("%s?weatherDate=%s&weatherLocation=%s", WeatherService.this.getServerUrl(), queryDate, WeatherService.this.weatherLocation);
            try {
                URL url = new URL(urlString);
                URLConnection conn = url.openConnection();
                conn.setReadTimeout(10000);
                BufferedReader input = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                return this.parseXML(input);
            }
            catch (FileNotFoundException fnfe) {
                log.warn("FileNotFoundException on : " + urlString);
            }
            catch (SocketTimeoutException ste) {
                log.warn("SocketTimeoutException on : " + urlString);
            }
            catch (Exception e) {
                log.error("Exception Raised during network call on : " + urlString);
                e.printStackTrace();
            }
            return null;
        }

        private Data parseXML(Object input) {
            if (input == null) {
                log.warn("Input to parseXML was null");
                return null;
            }
            Data data = null;
            try {
                XStream xstream = XMLMessageConverter.getXStream();
                xstream.alias("data", Data.class);
                xstream.alias("weatherReport", WeatherReport.class);
                xstream.alias("weatherForecast", WeatherForecastPrediction.class);
                xstream.useAttributeFor(WeatherReport.class);
                xstream.registerConverter((Converter)new WeatherReportConverter(this.requestDate));
                xstream.useAttributeFor(WeatherForecastPrediction.class);
                xstream.registerConverter((Converter)new WeatherForecastConverter());
                if (input.getClass().equals(BufferedReader.class)) {
                    data = (Data)xstream.fromXML((Reader)((BufferedReader)input));
                } else if (input.getClass().equals(String.class)) {
                    data = (Data)xstream.fromXML((String)input);
                }
                if (data != null && (data.weatherReports.size() != WeatherService.this.weatherReqInterval || data.weatherForecasts.size() != WeatherService.this.weatherReqInterval * WeatherService.this.forecastHorizon)) {
                    data = null;
                }
            }
            catch (Exception e) {
                log.error("Exception Raised parsing XML : " + e.toString());
                e.printStackTrace();
                data = null;
            }
            return data;
        }

        private void processData(Data data) throws Exception {
            this.processWeatherData(data);
            this.processForecastData(data);
        }

        private void processWeatherData(Data data) throws NullPointerException {
            for (WeatherReport report : data.getWeatherReports()) {
                WeatherService.this.weatherReportRepo.add(report);
            }
            log.info(data.getWeatherReports().size() + " WeatherReports fetched from xml response.");
        }

        private void processForecastData(Data data) throws Exception {
            int timeIndex = WeatherService.this.getTimeIndex(this.requestDate);
            ArrayList<WeatherForecastPrediction> currentPredictions = new ArrayList<WeatherForecastPrediction>();
            for (WeatherForecastPrediction prediction : data.getWeatherForecasts()) {
                currentPredictions.add(prediction);
                if (currentPredictions.size() != WeatherService.this.forecastHorizon) continue;
                WeatherForecast newForecast = new WeatherForecast(timeIndex++, currentPredictions);
                WeatherService.this.weatherForecastRepo.add(newForecast);
                currentPredictions = new ArrayList();
            }
            log.info(data.getWeatherForecasts().size() + " WeatherForecasts fetched from xml response.");
        }
    }
}

