/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.metadata.StateLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogService {
    @Autowired
    private StateLogService stateLogService;
    @Autowired
    private ServerConfiguration configService;
    private String filenamePrefix = "powertac";
    @ConfigurableValue(valueType="Boolean", description="if true, then abbreviate package names in the state log")
    private boolean abbreviateClassnames = false;

    public void setPrefix(String prefix) {
        this.filenamePrefix = prefix;
    }

    public String getPrefix() {
        return this.filenamePrefix;
    }

    public Logger getStateLogger() {
        return LogManager.getLogger((String)"State");
    }

    public void startLog() {
        this.startLog(null);
    }

    public void startLog(String id) {
        this.configService.configureMe((Object)this);
        try {
            Object filename = this.filenamePrefix;
            if (id != null && id.length() > 0) {
                filename = (String)filename + "-" + id;
            }
            String logDir = System.getProperty("logdir", "log");
            System.setProperty("logfile", logDir + "/" + (String)filename + ".trace");
            System.setProperty("statefile", logDir + "/" + (String)filename + ".state");
            ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
            if (this.abbreviateClassnames) {
                this.stateLogService.init(true);
            } else {
                this.stateLogService.init(false);
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            System.out.println("Can't open log file");
        }
    }

    public void stopLog() {
        System.getProperties().remove("logfile");
        System.getProperties().remove("statefile");
        ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
    }
}

