/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.TimeService;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.server.CompetitionControlService;

public class SimulationClockControl {
    private static Logger log = LogManager.getLogger(SimulationClockControl.class);
    Status state = Status.CLEAR;
    private TimeService timeService;
    private CompetitionControlService competitionControl;
    @ConfigurableValue(valueType="Double", publish=true, description="portion of timeslot allocated to agents")
    private double agentShare = 0.6;
    private Integer minAgentWindow = 1000;
    private int minWindow = 10;
    private int minPauseInterval = 100;
    private double maxTickOffsetRatio = 0.2;
    private long base;
    private long start;
    private long rate;
    private long modulo;
    private long tickInterval;
    private long scheduledTickTime;
    private int nextTick = -1;
    private boolean pauseRequested = false;
    private Timer theTimer;
    private WatchdogAction currentWatchdog;
    private Set<Semaphore> waitUntilStopSemaphores;
    private static SimulationClockControl instance;

    public static void initialize(CompetitionControlService competitionControl, TimeService timeService) {
        instance = new SimulationClockControl(competitionControl, timeService);
        ServerConfiguration serverConfig = (ServerConfiguration)SpringApplicationContext.getBean((String)"serverPropertiesService");
        serverConfig.configureMe((Object)instance);
    }

    public static SimulationClockControl getInstance() {
        return instance;
    }

    private SimulationClockControl(CompetitionControlService competitionControl, TimeService timeService) {
        this.competitionControl = competitionControl;
        this.timeService = timeService;
        this.base = timeService.getBase();
        this.rate = timeService.getRate();
        this.modulo = timeService.getModulo();
        this.tickInterval = this.modulo / this.rate;
        this.theTimer = new Timer();
        this.waitUntilStopSemaphores = Collections.synchronizedSet(new HashSet());
    }

    public void adjustAgentWindow(double simulationTimeslotSeconds) {
        this.minAgentWindow = (int)Math.round(Math.floor(simulationTimeslotSeconds * 1000.0 * this.agentShare));
        log.info("minAgentWindow = {}", (Object)this.minAgentWindow);
    }

    private int getMinAgentWindow() {
        if (this.minAgentWindow == 0) {
            log.error("minAgentWindow not yet initialized");
            return 3000;
        }
        return this.minAgentWindow;
    }

    public void setStart(long start) {
        this.start = start;
        this.timeService.setStart(start);
        if (!this.competitionControl.isBootstrapMode()) {
            this.minWindow = this.getMinAgentWindow();
        }
    }

    public void scheduleTick() {
        long nextTick = this.computeNextTickTime();
        boolean success = false;
        while (!success) {
            try {
                this.theTimer.schedule((TimerTask)new TickAction(this), new Date(nextTick));
                success = true;
            }
            catch (IllegalStateException ise) {
                this.theTimer = new Timer();
            }
        }
    }

    public synchronized void complete() {
        if (this.state == Status.DELAYED) {
            if (this.pauseRequested) {
                this.state = Status.PAUSED;
                this.pauseRequested = false;
                return;
            }
            this.resume();
        }
        this.state = Status.COMPLETE;
    }

    public synchronized void stop() {
        this.state = Status.STOPPED;
        if (this.currentWatchdog != null) {
            this.currentWatchdog.cancel();
            this.currentWatchdog = null;
        }
        for (Semaphore sem : this.waitUntilStopSemaphores) {
            sem.release();
        }
        this.waitUntilStopSemaphores.clear();
    }

    public void waitUntilStop() {
        Status state = this.getState();
        if (state != Status.STOPPED) {
            Semaphore sem = new Semaphore(0);
            this.waitUntilStopSemaphores.add(sem);
            try {
                sem.acquire();
            }
            catch (InterruptedException e) {
                log.info("Who dares wake me up??", (Throwable)e);
            }
        }
    }

    public synchronized void waitForTick(int n) {
        while (this.nextTick < n) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        long offset = new Date().getTime() - this.scheduledTickTime;
        if (offset > (long)((double)this.tickInterval / this.maxTickOffsetRatio)) {
            log.warn("clock delay: " + offset + " msec");
            this.updateStart(offset);
        }
        this.timeService.updateTime();
        this.setState(Status.CLEAR);
        long earliestPause = new Date().getTime() + (long)this.minPauseInterval;
        long wdTime = this.computeNextTickTime() - (long)this.minWindow;
        if (wdTime < earliestPause) {
            wdTime = earliestPause;
        }
        this.currentWatchdog = new WatchdogAction(this);
        this.theTimer.schedule((TimerTask)this.currentWatchdog, new Date(wdTime));
    }

    public void checkClockDrift() {
        long offset = this.timeService.getOffset();
        if (offset > (long)((double)this.tickInterval / this.maxTickOffsetRatio)) {
            log.warn("clock drift " + offset);
            this.updateStart(offset);
        }
    }

    public synchronized void requestPause() {
        this.pauseRequested = true;
    }

    public synchronized void releasePause() {
        if (this.state != Status.PAUSED) {
            this.pauseRequested = false;
        } else {
            this.state = Status.COMPLETE;
            this.resume();
        }
    }

    private synchronized void notifyTick() {
        ++this.nextTick;
        this.notifyAll();
    }

    private synchronized void delayMaybe() {
        if (this.state == Status.CLEAR) {
            this.state = Status.DELAYED;
            this.competitionControl.pause();
        } else if (this.pauseRequested) {
            this.state = Status.PAUSED;
            this.competitionControl.pause();
            this.pauseRequested = false;
        } else if (this.state == Status.COMPLETE) {
            this.scheduleTick();
        }
    }

    private void resume() {
        long originalNextTick = this.computeNextTickTime();
        long actualNextTick = new Date().getTime() + (long)this.minWindow;
        this.updateStart(actualNextTick - originalNextTick);
        this.scheduleTick();
    }

    private void updateStart(long offset) {
        this.start += offset;
        this.timeService.setStart(this.start);
        this.competitionControl.resume(this.start);
    }

    synchronized Status getState() {
        return this.state;
    }

    synchronized void setState(Status newState) {
        this.state = newState;
    }

    private long computeNextTickTime() {
        long current = new Date().getTime();
        if (current < this.start) {
            return this.start;
        }
        long simTime = this.timeService.getCurrentTime().getMillis();
        long nextSimTime = simTime + this.modulo;
        long nextTick = this.start + (nextSimTime - this.base) / this.rate;
        return nextTick;
    }

    private class WatchdogAction
    extends TimerTask {
        SimulationClockControl scc;

        WatchdogAction(SimulationClockControl scc) {
            this.scc = scc;
        }

        @Override
        public void run() {
            this.scc.delayMaybe();
            SimulationClockControl.this.currentWatchdog = null;
        }
    }

    private class TickAction
    extends TimerTask {
        SimulationClockControl scc;

        TickAction(SimulationClockControl scc) {
            this.scc = scc;
        }

        @Override
        public void run() {
            this.scc.scheduledTickTime = this.scheduledExecutionTime();
            this.scc.notifyTick();
        }
    }

    public static enum Status {
        CLEAR,
        COMPLETE,
        DELAYED,
        PAUSED,
        STOPPED;

    }
}

