/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.IdGenerator;
import org.powertac.common.RandomSeed;
import org.powertac.common.TimeService;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.interfaces.BootstrapDataCollector;
import org.powertac.common.interfaces.BootstrapState;
import org.powertac.common.interfaces.CompetitionSetup;
import org.powertac.common.msg.MarketBootstrapData;
import org.powertac.common.repo.BootstrapDataRepo;
import org.powertac.common.repo.DomainRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.logtool.LogtoolContext;
import org.powertac.logtool.LogtoolCore;
import org.powertac.logtool.ifc.Analyzer;
import org.powertac.logtool.ifc.ObjectReader;
import org.powertac.server.CompetitionControlService;
import org.powertac.server.LogService;
import org.powertac.server.MessageRouter;
import org.powertac.server.ServerPropertiesService;
import org.powertac.server.TournamentSchedulerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
public class CompetitionSetupService
implements CompetitionSetup {
    private static Logger log = LogManager.getLogger(CompetitionSetupService.class);
    private static ApplicationContext context;
    @Autowired
    private CompetitionControlService cc;
    @Autowired
    private BootstrapDataCollector defaultBroker;
    @Autowired
    private ServerPropertiesService serverProps;
    @Autowired
    private BootstrapDataRepo bootstrapDataRepo;
    @Autowired
    private LogtoolCore logtoolCore;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    @Autowired
    private MessageRouter messageRouter;
    @Autowired
    private XMLMessageConverter messageConverter;
    @Autowired
    private LogService logService;
    @Autowired
    private TournamentSchedulerService tss;
    @Autowired
    private TimeService timeService;
    private Competition competition;
    private SeedLoader seedLoader;
    private String gameId = null;
    private URL controllerURL;
    private Thread session = null;

    public void processCmdLine(String[] args) {
        File abortFile = new File("abort");
        if (abortFile.exists()) {
            abortFile.delete();
        }
        if (args.length > 1) {
            this.processCli(args);
            this.waitForSession();
        }
    }

    private void waitForSession() {
        if (this.session != null) {
            try {
                this.session.join();
            }
            catch (InterruptedException e) {
                System.out.println("Error waiting for session completion: " + e.toString());
            }
        }
    }

    private void processCli(String[] args) {
        OptionParser parser = new OptionParser();
        parser.accepts("sim");
        ArgumentAcceptingOptionSpec bootOutput = parser.accepts("boot").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec controllerOption = parser.accepts("control").withRequiredArg().ofType(URL.class);
        ArgumentAcceptingOptionSpec gameOpt = parser.accepts("game-id").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec serverConfigUrl = parser.accepts("config").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec bootData = parser.accepts("boot-data").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec seedData = parser.accepts("random-seeds").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec weatherData = parser.accepts("weather-data").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec jmsUrl = parser.accepts("jms-url").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec inputQueue = parser.accepts("input-queue").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec brokerList = parser.accepts("brokers").withRequiredArg().withValuesSeparatedBy(',');
        ArgumentAcceptingOptionSpec configDump = parser.accepts("config-dump").withRequiredArg().ofType(String.class);
        OptionSet options = parser.parse(args);
        try {
            this.controllerURL = (URL)options.valueOf((OptionSpec)controllerOption);
            String game = (String)options.valueOf((OptionSpec)gameOpt);
            if (null == game) {
                game = "0";
            }
            String serverConfig = (String)options.valueOf((OptionSpec)serverConfigUrl);
            if (this.controllerURL != null) {
                this.tss.setTournamentSchedulerUrl(this.controllerURL.toString());
                this.tss.setGameId(game);
                serverConfig = this.tss.getConfigUrl().toExternalForm();
            }
            if (options.has((OptionSpec)bootOutput)) {
                this.bootSession((String)options.valueOf((OptionSpec)bootOutput), serverConfig, game, (String)options.valueOf((OptionSpec)configDump));
            } else if (options.has("sim")) {
                this.simSession((String)options.valueOf((OptionSpec)bootData), serverConfig, (String)options.valueOf((OptionSpec)jmsUrl), game, options.valuesOf((OptionSpec)brokerList), (String)options.valueOf((OptionSpec)seedData), (String)options.valueOf((OptionSpec)weatherData), (String)options.valueOf((OptionSpec)inputQueue), (String)options.valueOf((OptionSpec)configDump));
            } else if (options.has("config-dump")) {
                this.bootSession(null, serverConfig, game, (String)options.valueOf((OptionSpec)configDump));
            } else {
                System.err.println("Must provide either --boot or --sim to run server");
                System.exit(1);
            }
        }
        catch (OptionException e) {
            System.err.println("Bad command argument: " + e.toString());
        }
    }

    public String bootSession(String bootFilename, String config, String game, String configDump) {
        Object error = null;
        this.gameId = game;
        String sessionType = null != configDump ? "config-" : "boot-";
        this.logService.startLog(sessionType + game);
        try {
            if (null != bootFilename) {
                log.info("bootSession: bootFilename={}, config={}, game={}", (Object)bootFilename, (Object)config, (Object)game);
            } else {
                if (null == configDump) {
                    log.error("Nothing to do here, both bootFilename and configDump are null");
                    return "Invalid boot session";
                }
                log.info("config dump: config={}, configDump={}", (Object)config, (Object)configDump);
            }
            this.setupConfig(config, configDump);
            if (null != bootFilename) {
                File bootFile = new File(bootFilename);
                if (!bootFile.getAbsoluteFile().getParentFile().canWrite()) {
                    error = "Cannot write to bootstrap data file " + bootFilename;
                    System.out.println((String)error);
                } else {
                    this.startBootSession(bootFile);
                }
            } else {
                this.startBootSession(null);
            }
        }
        catch (NullPointerException npe) {
            error = "Bootstrap filename not given";
        }
        catch (MalformedURLException e) {
            error = "Malformed URL: " + e.toString();
            System.out.println((String)error);
        }
        catch (IOException e) {
            error = "Error reading configuration";
        }
        catch (ConfigurationException e) {
            error = "Error setting configuration";
        }
        this.logService.stopLog();
        return error;
    }

    public String bootSession(String bootFilename, String configFilename, String gameId) {
        return this.bootSession(bootFilename, configFilename, gameId, null);
    }

    public String simSession(String bootData, String config, String jmsUrl, String game, List<String> brokerUsernames, String seedData, String weatherData, String inputQueueName, String configOutput) {
        Object error = null;
        this.gameId = game;
        this.logService.startLog("sim-" + game);
        try {
            log.info("simSession: bootData=" + (String)bootData + ", config=" + config + ", jmsUrl=" + jmsUrl + ", game=" + game + ", seedData=" + seedData + ", weatherData=" + weatherData + ", inputQueue=" + inputQueueName);
            this.setupConfig(config, configOutput);
            this.loadCompetitionMaybe(seedData, weatherData);
            this.useWeatherDataMaybe(weatherData);
            this.createSeedLoader(seedData);
            if (jmsUrl != null) {
                this.serverProps.setProperty("server.jmsManagementService.jmsBrokerUrl", jmsUrl);
            }
            URL bootUrl = null;
            if (this.controllerURL != null) {
                bootUrl = this.tss.getBootUrl();
            } else if (bootData != null) {
                if (!((String)bootData).contains(":")) {
                    bootData = "file:" + (String)bootData;
                }
                bootUrl = new URL((String)bootData);
            }
            if (null == bootUrl) {
                error = "bootstrap data source not given";
                System.out.println((String)error);
            } else {
                log.info("bootUrl=" + bootUrl.toExternalForm());
                this.startSimSession(brokerUsernames, inputQueueName, bootUrl);
            }
        }
        catch (MalformedURLException e) {
            error = "Malformed URL: " + e.toString();
            System.out.println((String)error);
        }
        catch (IOException e) {
            error = "Error reading configuration " + config;
        }
        catch (ConfigurationException e) {
            error = "Error setting configuration " + config;
        }
        this.logService.stopLog();
        return error;
    }

    public String simSession(String bootData, String config, String jmsUrl, String gameId, List<String> brokerUsernames, String seedData, String weatherData, String inputQueueName) {
        return this.simSession(bootData, config, jmsUrl, gameId, brokerUsernames, seedData, weatherData, inputQueueName, null);
    }

    private void loadCompetitionMaybe(String seedData, String weatherData) {
        CompetitionLoader loader = null;
        Competition tempCompetition = null;
        if (null != seedData) {
            log.info("Loading seeds from {}", (Object)seedData);
            loader = new CompetitionLoader(seedData);
            tempCompetition = loader.extractCompetition();
            if (null == tempCompetition) {
                System.exit(1);
            }
            this.loadTimeslotCounts(tempCompetition);
        }
        if (null != weatherData) {
            log.info("Loading weather data from {}", (Object)weatherData);
            loader = new CompetitionLoader(weatherData);
            tempCompetition = loader.extractCompetition();
            if (null == tempCompetition) {
                System.exit(1);
            }
            this.loadStartTime(tempCompetition);
        }
    }

    private void setupConfig(String config, String configDump) throws ConfigurationException, IOException {
        this.serverProps.recycle();
        if (null != configDump) {
            this.serverProps.setConfigOutput(configDump);
        }
        if (config == null) {
            return;
        }
        log.info("Reading configuration from " + config);
        this.serverProps.setUserConfig(this.makeUrl(config));
        log.info("Server version {}", (Object)System.getProperty("server.pomId"));
    }

    private void loadStartTime(Competition comp) {
        this.serverProps.setProperty("common.competition.simulationBaseTime", comp.getSimulationBaseTime().getMillis());
    }

    private void loadTimeslotCounts(Competition comp) {
        log.info("Getting minimumTimeslotCount and expectedTimeslotCount from Competition");
        this.serverProps.setProperty("common.competition.minimumTimeslotCount", comp.getMinimumTimeslotCount());
        this.serverProps.setProperty("common.competition.expectedTimeslotCount", comp.getExpectedTimeslotCount());
    }

    void createSeedLoader(String seedSource) {
        if (null == seedSource || 0 == seedSource.length()) {
            return;
        }
        this.seedLoader = new SeedLoader(seedSource);
    }

    void loadSeedsMaybe() {
        if (null == this.seedLoader) {
            return;
        }
        log.info("Reading random seeds");
        this.seedLoader.loadSeeds();
    }

    private void useWeatherDataMaybe(String weatherData) {
        if (weatherData == null || weatherData.isEmpty()) {
            return;
        }
        log.info("Using weather data from {}", (Object)weatherData);
        this.serverProps.setProperty("server.weatherService.weatherData", weatherData);
    }

    private URL makeUrl(String name) throws MalformedURLException {
        Object urlName = name;
        if (!((String)urlName).contains(":")) {
            urlName = "file:" + (String)urlName;
        }
        return new URL((String)urlName);
    }

    private void startBootSession(File bootstrapFile) throws IOException {
        final boolean dumpOnly = null == bootstrapFile;
        final FileWriter bootWriter = dumpOnly ? null : new FileWriter(bootstrapFile);
        this.session = new Thread(){

            @Override
            public void run() {
                CompetitionSetupService.this.cc.setAuthorizedBrokerList(new ArrayList<String>());
                CompetitionSetupService.this.preGame();
                CompetitionSetupService.this.cc.runOnce(true, dumpOnly);
                if (null != bootWriter) {
                    CompetitionSetupService.this.saveBootstrapData(bootWriter);
                }
            }
        };
        this.session.start();
        try {
            this.session.join();
        }
        catch (InterruptedException e) {
            log.error("Unexpected", (Throwable)e);
        }
    }

    private void startSimSession(final List<String> brokers, final String inputQueueName, final URL bootUrl) {
        this.session = new Thread(){

            @Override
            public void run() {
                CompetitionSetupService.this.cc.setAuthorizedBrokerList(brokers);
                CompetitionSetupService.this.cc.setInputQueueName(inputQueueName);
                Document document = CompetitionSetupService.this.getDocument(bootUrl);
                if (document != null && CompetitionSetupService.this.preGame(document)) {
                    CompetitionSetupService.this.bootstrapDataRepo.add(CompetitionSetupService.this.processBootDataset(document));
                    List mbd = CompetitionSetupService.this.bootstrapDataRepo.getData(MarketBootstrapData.class);
                    if (null == mbd) {
                        log.error("marketBootstrapData is null");
                        return;
                    }
                    if (0 == mbd.size()) {
                        log.error("marketBootstrapData is empty");
                        return;
                    }
                    Competition.currentCompetition().setMarketBootstrapData((MarketBootstrapData)mbd.get(0));
                    CompetitionSetupService.this.cc.runOnce(false);
                }
            }
        };
        this.session.start();
        try {
            this.session.join();
        }
        catch (InterruptedException e) {
            log.error("Unexpected", (Throwable)e);
        }
    }

    private Document getDocument(URL bootUrl) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(bootUrl.openStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public void preGame() {
        this.extractPomId();
        log.info("preGame() - start game " + this.gameId);
        log.info("POM version ID: {}", (Object)this.serverProps.getProperty("common.competition.pomId"));
        IdGenerator.recycle();
        this.competition = Competition.newInstance((String)this.gameId);
        Competition.setCurrent((Competition)this.competition);
        log.info("pre-game initialization");
        this.configureCompetition(this.competition);
        this.timeService.setClockParameters(this.competition);
        this.timeService.setCurrentTime(this.competition.getSimulationBaseTime());
        List repos = SpringApplicationContext.listBeansOfType(DomainRepo.class);
        log.debug("found " + repos.size() + " repos");
        for (DomainRepo repo : repos) {
            repo.recycle();
        }
        this.messageRouter.recycle();
        this.loadSeedsMaybe();
    }

    private void configureCompetition(Competition competition) {
        this.serverProps.configureMe(competition);
    }

    private boolean preGame(Document document) {
        log.info("preGame(File) - start");
        this.preGame();
        Competition bootstrapCompetition = this.readBootRecord(document);
        if (null == bootstrapCompetition) {
            return false;
        }
        Competition.currentCompetition().update(bootstrapCompetition);
        this.timeService.setClockParameters(this.competition);
        this.timeService.setCurrentTime(this.competition.getSimulationBaseTime());
        return true;
    }

    Competition readBootRecord(Document document) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        Competition bootstrapCompetition = null;
        try {
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/config/competition");
            NodeList nodes = (NodeList)exp.evaluate(document, XPathConstants.NODESET);
            String xml = this.nodeToString(nodes.item(0));
            bootstrapCompetition = (Competition)this.messageConverter.fromXML(xml);
            exp = xPath.compile("/powertac-bootstrap-data/bootstrap-state/properties");
            nodes = (NodeList)exp.evaluate(document, XPathConstants.NODESET);
            if (null != nodes && nodes.getLength() > 0) {
                xml = this.nodeToString(nodes.item(0));
                Properties bootState = (Properties)this.messageConverter.fromXML(xml);
                this.serverProps.addProperties(bootState);
            }
        }
        catch (XPathExpressionException xee) {
            log.error("preGame: Error reading boot dataset: " + xee.toString());
            System.out.println("preGame: Error reading boot dataset: " + xee.toString());
        }
        return bootstrapCompetition;
    }

    void saveBootstrapData(Writer datasetWriter) {
        BufferedWriter output = new BufferedWriter(datasetWriter);
        List data = this.defaultBroker.collectBootstrapData(this.competition.getBootstrapTimeslotCount());
        try {
            output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            output.newLine();
            output.write("<powertac-bootstrap-data>");
            output.newLine();
            output.write("<config>");
            output.newLine();
            output.write(this.messageConverter.toXML((Object)this.competition));
            output.newLine();
            output.write("</config>");
            output.newLine();
            output.write("<bootstrap-state>");
            output.newLine();
            output.write(this.gatherBootstrapState());
            output.newLine();
            output.write("</bootstrap-state>");
            output.newLine();
            output.write("<bootstrap>");
            output.newLine();
            for (Object item : data) {
                output.write(this.messageConverter.toXML(item));
                output.newLine();
            }
            output.write("</bootstrap>");
            output.newLine();
            output.write("</powertac-bootstrap-data>");
            output.newLine();
            output.close();
        }
        catch (IOException ioe) {
            log.error("Error writing bootstrap file: " + ioe.toString());
        }
    }

    private String gatherBootstrapState() {
        List collectors = SpringApplicationContext.listBeansOfType(BootstrapState.class);
        for (BootstrapState collector : collectors) {
            log.info("Calling saveBootstrapState() on collector {}", (Object)collector.getClass().getName());
            collector.saveBootstrapState();
        }
        Properties result = this.serverProps.getBootstrapState();
        String output = this.messageConverter.toXML((Object)result);
        return output;
    }

    private ArrayList<Object> processBootDataset(Document document) {
        ArrayList<Object> result = new ArrayList<Object>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/bootstrap/*");
            NodeList nodes = (NodeList)exp.evaluate(document, XPathConstants.NODESET);
            log.info("Found " + nodes.getLength() + " bootstrap nodes");
            for (int i = 0; i < nodes.getLength(); ++i) {
                String xml = this.nodeToString(nodes.item(i));
                Object msg = this.messageConverter.fromXML(xml);
                result.add(msg);
            }
        }
        catch (XPathExpressionException xee) {
            log.error("runOnce: Error reading config file: " + xee.toString());
        }
        return result;
    }

    private String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "no");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            log.error("nodeToString Transformer Exception " + te.toString());
        }
        return sw.toString();
    }

    private void extractPomId() {
        try {
            Properties props = new Properties();
            InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/org.powertac/server-main/pom.properties");
            if (null != is) {
                props.load(is);
                this.serverProps.setProperty("common.competition.pomId", props.getProperty("version"));
            }
        }
        catch (Exception e) {
            log.error("Failed to load properties from manifest");
        }
    }

    public class SeedLoader
    extends LogtoolContext
    implements Analyzer {
        private String source;

        public SeedLoader(String seedSource) {
            this.source = seedSource;
            this.core = CompetitionSetupService.this.logtoolCore;
            this.dor = CompetitionSetupService.this.logtoolCore.getDOR();
        }

        void loadSeeds() {
            CompetitionSetupService.this.logtoolCore.resetDOR(false);
            CompetitionSetupService.this.logtoolCore.includeClassname("org.powertac.common.RandomSeed");
            this.registerMessageHandlers();
            Analyzer[] tools = new Analyzer[]{this};
            CompetitionSetupService.this.logtoolCore.readStateLog(this.source, tools);
        }

        public void handleMessage(RandomSeed thing) {
            log.info("Restoring RandomSeed {}", (Object)thing.getRequesterClass());
            CompetitionSetupService.this.randomSeedRepo.restoreRandomSeed(thing);
        }

        public void setup() throws FileNotFoundException {
        }

        public void report() {
        }
    }

    public class CompetitionLoader
    extends LogtoolContext {
        private String source;
        private Competition tempCompetition;

        public CompetitionLoader(String source) {
            this.source = source;
            this.core = CompetitionSetupService.this.logtoolCore;
            this.dor = CompetitionSetupService.this.logtoolCore.getDOR();
        }

        Competition extractCompetition() {
            CompetitionSetupService.this.logtoolCore.resetDOR(true);
            CompetitionSetupService.this.logtoolCore.includeClassname("org.powertac.common.RandomSeed");
            CompetitionSetupService.this.logtoolCore.includeClassname("org.powertac.common.Competition");
            ObjectReader reader = CompetitionSetupService.this.logtoolCore.getObjectReader(this.source);
            if (null == reader) {
                log.error("Cannot read from {}", (Object)this.source);
                return null;
            }
            boolean flag = false;
            while (!flag) {
                Object thing = reader.getNextObject();
                if (thing.getClass() == RandomSeed.class) {
                    log.debug("extractCompetition found RandomSeed");
                    flag = true;
                    continue;
                }
                if (thing.getClass() != Competition.class) continue;
                this.tempCompetition = (Competition)thing;
                log.info("extractCompetition found Competition {}", (Object)this.tempCompetition.getName());
            }
            CompetitionSetupService.this.logtoolCore.resetDOR(false);
            return this.tempCompetition;
        }
    }
}

