/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.beans;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.WeatherForecast;
import org.powertac.common.WeatherReport;
import org.powertac.common.msg.TimeslotUpdate;
import org.powertac.visualizer.VisualizerApplicationContext;
import org.powertac.visualizer.beans.AppearanceListBean;
import org.powertac.visualizer.domain.DayOverview;
import org.powertac.visualizer.interfaces.Recyclable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualizerBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(VisualizerBean.class);
    private int messageCounter;
    private int visualizerRunCount;
    private DayOverview dayOverview;
    private Competition competition;
    private Instant firstTimeslotInstant;
    private TimeslotUpdate timeslotUpdate;
    private String simulationStatus;
    private WeatherReport weatherReport;
    private WeatherForecast weatherForecast;
    private int currentTimeslotSerialNumber;
    private int relativeTimeslotIndex;
    private int week;
    private int day;
    private int hour;
    private boolean finished;
    private boolean running;
    private int firstTimeslotIndex;
    @Autowired
    private AppearanceListBean appearanceList;

    public VisualizerBean() {
        this.init();
    }

    public void incrementMessageCounter() {
        ++this.messageCounter;
    }

    public int getMessageCount() {
        return this.messageCounter;
    }

    public void newRun() {
        this.init();
        this.appearanceList.resetAvailableList();
        List recyclables = VisualizerApplicationContext.listBeansOfType(Recyclable.class);
        for (Recyclable rec : recyclables) {
            this.log.info((Object)("recycling..." + rec.getClass().getName()));
            rec.recycle();
        }
    }

    public void init() {
        this.messageCounter = 0;
        ++this.visualizerRunCount;
        this.dayOverview = null;
        this.competition = null;
        this.firstTimeslotInstant = null;
        this.timeslotUpdate = null;
        this.simulationStatus = null;
        this.weatherReport = null;
        this.weatherForecast = null;
        this.currentTimeslotSerialNumber = -1;
        this.relativeTimeslotIndex = -1;
        this.week = -1;
        this.day = -1;
        this.hour = -1;
        this.finished = false;
        this.running = false;
        this.firstTimeslotIndex = -1;
    }

    public int getVisualizerRunCount() {
        return this.visualizerRunCount;
    }

    public Competition getCompetition() {
        return this.competition;
    }

    public void setCompetition(Competition competition) {
        this.competition = competition;
    }

    public TimeslotUpdate getTimeslotUpdate() {
        return this.timeslotUpdate;
    }

    public void setTimeslotUpdate(TimeslotUpdate timeslotUpdate) {
        this.timeslotUpdate = timeslotUpdate;
    }

    public int getCurrentFirstEnabledTimeslotSerialNumber() {
        if (this.timeslotUpdate != null) {
            return this.timeslotUpdate.getFirstEnabled();
        }
        return -1;
    }

    public String getSimulationStatus() {
        return this.simulationStatus;
    }

    public void setSimulationStatus(String simulationStatus) {
        this.simulationStatus = simulationStatus;
    }

    public WeatherReport getWeatherReport() {
        return this.weatherReport;
    }

    public void setWeatherReport(WeatherReport weatherReport) {
        this.weatherReport = weatherReport;
    }

    public WeatherForecast getWeatherForecast() {
        return this.weatherForecast;
    }

    public void setWeatherForecast(WeatherForecast weatherForecast) {
        this.weatherForecast = weatherForecast;
    }

    public int getCurrentTimeslotSerialNumber() {
        return this.currentTimeslotSerialNumber;
    }

    public void setCurrentTimeslotSerialNumber(int currentTimeslotSerialNumber) {
        this.currentTimeslotSerialNumber = currentTimeslotSerialNumber;
    }

    public void setRelativeTimeslotIndex(int relativeTimeslotIndex) {
        this.relativeTimeslotIndex = relativeTimeslotIndex;
    }

    public int getRelativeTimeslotIndex() {
        return this.relativeTimeslotIndex;
    }

    public void setFirstTimeslotInstant(Instant firstTimeslot) {
        this.firstTimeslotInstant = firstTimeslot;
    }

    public Instant getFirstTimeslotInstant() {
        return this.firstTimeslotInstant;
    }

    public DayOverview getDayOverview() {
        return this.dayOverview;
    }

    public void setDayOverview(DayOverview dayOverview) {
        this.dayOverview = dayOverview;
    }

    public int getWeek() {
        return this.week;
    }

    public void setWeek(int week) {
        this.week = week;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public int getFirstTimeslotIndex() {
        return this.firstTimeslotIndex;
    }

    public void setFirstTimeslotIndex(int firstTimeslotIndex) {
        this.firstTimeslotIndex = firstTimeslotIndex;
    }
}

