/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.beans.backing;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.application.PrimeResource;
import org.primefaces.model.StreamedContent;

public class CustomResourceHandler
extends ResourceHandlerWrapper {
    private static final Logger logger = Logger.getLogger(CustomResourceHandler.class.getName());
    public static final String DYNAMIC_CONTENT_PARAM = "pfdrid";
    private ResourceHandler wrapped;

    public CustomResourceHandler(ResourceHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public Resource createResource(String resourceName, String libraryName) {
        Resource resource = super.createResource(resourceName, libraryName);
        if (resource != null && libraryName != null && libraryName.equalsIgnoreCase("primefaces")) {
            return new PrimeResource(resource);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResourceRequest(FacesContext context) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        String library = (String)params.get("ln");
        String dynamicContentId = (String)params.get(DYNAMIC_CONTENT_PARAM);
        if (dynamicContentId != null && library != null && library.equals("primefaces")) {
            Map session = context.getExternalContext().getSessionMap();
            try {
                int length;
                String dynamicContentEL = (String)session.get(dynamicContentId);
                ELContext eLContext = context.getELContext();
                ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), dynamicContentEL, StreamedContent.class);
                StreamedContent content = (StreamedContent)ve.getValue(eLContext);
                HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
                response.setContentType(content.getContentType());
                byte[] buffer = new byte[2048];
                InputStream inputStream = content.getStream();
                while ((length = inputStream.read(buffer)) >= 0) {
                    response.getOutputStream().write(buffer, 0, length);
                }
                response.setStatus(200);
                ServletOutputStream outputStream = response.getOutputStream();
                context.responseComplete();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in streaming dynamic resource.\n" + e.toString());
            }
            finally {
                session.remove(dynamicContentId);
            }
        } else {
            super.handleResourceRequest(context);
        }
    }
}

