/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.broker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;
import org.powertac.common.BalancingTransaction;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffTransaction;
import org.powertac.visualizer.Helper;
import org.powertac.visualizer.domain.Appearance;
import org.powertac.visualizer.domain.broker.CustomerModel;
import org.powertac.visualizer.domain.broker.DayState;
import org.powertac.visualizer.interfaces.DisplayableBroker;
import org.powertac.visualizer.interfaces.TimeslotModelUpdate;
import org.powertac.visualizer.interfaces.VisualBroker;
import org.powertac.visualizer.json.BrokerJSON;
import org.primefaces.json.JSONArray;
import org.primefaces.json.JSONException;
import org.primefaces.json.JSONObject;

public class BrokerModel
implements VisualBroker,
DisplayableBroker,
TimeslotModelUpdate {
    Logger log = Logger.getLogger(BrokerModel.class);
    private String name;
    private Appearance appearance;
    private String id;
    private int customerCount;
    private double cashBalance;
    private double energyBalance;
    private HashMap<Integer, DayState> dayStates = new HashMap();
    private DayState currentDayState = new DayState((DisplayableBroker)this);
    private DayState displayableDayState;
    private List<TariffSpecification> tariffSpecifications;
    private List<TariffTransaction> tariffTransactions;
    private List<BalancingTransaction> balancingTransactions;
    private Set<CustomerModel> customerModels;
    private int firstTimeslotIndex;
    private BrokerJSON json;

    public BrokerModel(String name, Appearance appearance) {
        this.name = name;
        this.appearance = appearance;
        this.tariffSpecifications = new ArrayList();
        this.tariffTransactions = new ArrayList();
        this.balancingTransactions = new ArrayList();
        this.customerModels = new HashSet();
        this.id = RandomStringUtils.random((int)7, (char[])"abcdefghijklomnopqrstuvxy".toCharArray());
        JSONObject seriesOptions = new JSONObject();
        try {
            seriesOptions.put("color", (Object)appearance.getColorCode()).put("label", (Object)name);
        }
        catch (JSONException e) {
            this.log.warn((Object)"Broker JSON series options fail.");
        }
        this.json = new BrokerJSON(seriesOptions);
    }

    public void updateCashBalance(double balance) {
        this.cashBalance = Helper.roundNumberTwoDecimal((double)balance);
    }

    public void updateEnergyBalance(double balance) {
        this.energyBalance = Helper.roundNumberTwoDecimal((double)balance);
    }

    public void addBalancingTransaction(BalancingTransaction balancingTransaction) {
        this.energyBalance = Helper.roundNumberTwoDecimal((double)balancingTransaction.getKWh());
        this.balancingTransactions.add(balancingTransaction);
        this.currentDayState.addBalancingTransaction(balancingTransaction);
    }

    public void addTariffSpecification(TariffSpecification tariffSpecification) {
        this.tariffSpecifications.add(tariffSpecification);
        this.log.info((Object)("\n" + this.name + ": my tariffSpec: +\n" + tariffSpecification.toString()));
        this.currentDayState.addTariffSpecification(tariffSpecification);
    }

    public void addTariffTransaction(TariffTransaction tariffTransaction) {
        this.log.info((Object)("\n" + this.name + ": my tariffTrans: +\n" + tariffTransaction.toString()));
        this.tariffTransactions.add(tariffTransaction);
        if (tariffTransaction.getCustomerInfo() != null) {
            for (CustomerModel customerModel : this.customerModels) {
                if (customerModel.getCustomerInfo().getId() != tariffTransaction.getCustomerInfo().getId()) continue;
                customerModel.addTariffTransaction(tariffTransaction);
                break;
            }
        }
        int customerCount = Helper.getCustomerCount((TariffTransaction)tariffTransaction);
        this.customerCount += customerCount;
        this.currentDayState.addTariffTransaction(tariffTransaction);
    }

    public void setCustomerModels(Set<CustomerModel> customerModels) {
        this.customerModels = customerModels;
        this.buildCustomerTicks();
    }

    private void buildCustomerTicks() {
        JSONArray customerTicks = new JSONArray();
        for (CustomerModel customerModel : this.customerModels) {
            customerTicks.put((Object)customerModel.getCustomerInfo().getName());
        }
        this.json.setCustomerTicks(customerTicks);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public void setAppereance(Appearance appearance) {
        this.appearance = appearance;
    }

    public void buildCustomersBubble() {
        JSONArray newCustomersBubbleJSONArray = new JSONArray();
        Iterator iterator = this.customerModels.iterator();
        while (iterator.hasNext()) {
            JSONArray customerBubbleJson = new JSONArray();
            CustomerModel customer = (CustomerModel)iterator.next();
            customerBubbleJson.put((int)customer.getTotalCash()).put((int)customer.getTotalEnergy()).put(customer.getCustomerCount()).put((Object)customer.getCustomerInfo().getName());
            newCustomersBubbleJSONArray.put((Object)customerBubbleJson);
        }
        this.json.setCustomersBubbleJson(newCustomersBubbleJSONArray);
    }

    public double getCashBalance() {
        return this.cashBalance;
    }

    public void setCashBalance(double cashBalance) {
        this.cashBalance = cashBalance;
    }

    public double getEnergyBalance() {
        return this.energyBalance;
    }

    public void setEnergyBalance(double energyBalance) {
        this.energyBalance = energyBalance;
    }

    public DayState getDisplayableDayState() {
        return this.displayableDayState;
    }

    public long getOfferedTarrifsCount() {
        return this.tariffSpecifications.size();
    }

    public List<TariffSpecification> getTariffSpecifications() {
        return this.tariffSpecifications;
    }

    public List<TariffTransaction> getTariffTransactions() {
        return this.tariffTransactions;
    }

    public List<BalancingTransaction> getBalancingTransactions() {
        return this.balancingTransactions;
    }

    public Set<CustomerModel> getCustomerModels() {
        return this.customerModels;
    }

    public HashMap<Integer, DayState> getDayStates() {
        return this.dayStates;
    }

    public String getId() {
        return this.id;
    }

    public int getCustomerCount() {
        return this.customerCount;
    }

    public DayState getCurrentDayState() {
        return this.currentDayState;
    }

    public void update(int timeslotIndex) {
        boolean DAY_FIX = true;
        int currentDay = timeslotIndex / 24 + 1;
        if (this.currentDayState.getDay() == -1) {
            this.currentDayState.setDay(currentDay);
            this.dayStates.put(currentDay, this.currentDayState);
            this.firstTimeslotIndex = timeslotIndex;
        }
        int hour = (timeslotIndex - this.firstTimeslotIndex) % 24;
        this.currentDayState.addTimeslotValues(hour, this.cashBalance, this.energyBalance);
        this.json.getCashBalanceJson().put((Object)Helper.pointJSON((int)timeslotIndex, (double)this.cashBalance));
        this.json.getEnergyBalanceJson().put((Object)Helper.pointJSON((int)timeslotIndex, (double)this.energyBalance));
        if (hour == 23 && this.firstTimeslotIndex != timeslotIndex) {
            this.json.getEnergyBalanceDailyAVGJson().put((Object)Helper.pointJSON((int)currentDay, (double)((DayState)this.dayStates.get(currentDay)).getAvgEnergyBalance()));
            this.json.getCashBalanceDailyJson().put((Object)Helper.pointJSON((int)currentDay, (double)this.cashBalance));
            this.displayableDayState = this.currentDayState;
            int newDay = currentDay + 1;
            this.currentDayState = new DayState(newDay, (DisplayableBroker)this);
            this.dayStates.put(newDay, this.currentDayState);
        }
        this.buildCustomersBubble();
    }

    public BrokerJSON getJson() {
        return this.json;
    }
}

