/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.customer;

import org.apache.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.TariffTransaction;
import org.powertac.common.msg.CustomerBootstrapData;
import org.powertac.visualizer.domain.broker.CustomerModel;
import org.powertac.visualizer.interfaces.TimeslotModelUpdate;
import org.powertac.visualizer.json.CustomerJSON;
import org.primefaces.json.JSONArray;
import org.primefaces.json.JSONException;

public class Customer
implements TimeslotModelUpdate {
    private Logger log = Logger.getLogger(Customer.class);
    private CustomerModel customerModel;
    private CustomerInfo customerInfo;
    private CustomerJSON customerJson = new CustomerJSON();
    private CustomerBootstrapData bootstrapData;
    private double currentKWhProduced;
    private double currentKWhConsumed;
    private double currentInflowCharge;
    private double currentOutflowCharge;

    public Customer(CustomerInfo customerInfo) {
        this.customerModel = new CustomerModel(customerInfo);
        this.customerInfo = customerInfo;
    }

    public CustomerModel getCustomerModel() {
        return this.customerModel;
    }

    public CustomerJSON getCustomerJson() {
        return this.customerJson;
    }

    public void addCustomerBootstrapData(CustomerBootstrapData data) {
        this.bootstrapData = data;
        this.buildBootstrapDataJSON();
    }

    public void addTariffTransaction(TariffTransaction transaction) {
        double kWh = transaction.getKWh();
        double charge = -1.0 * transaction.getCharge();
        if (kWh < 0.0) {
            this.currentKWhConsumed += kWh;
        } else {
            this.currentKWhProduced += kWh;
        }
        if (charge > 0.0) {
            this.currentInflowCharge += charge;
        } else {
            this.currentOutflowCharge += charge;
        }
        this.customerModel.addTariffTransaction(transaction);
    }

    private void buildBootstrapDataJSON() {
        try {
            JSONArray array = new JSONArray((Object)this.bootstrapData.getNetUsage());
            this.customerJson.setBootstrapLineChartData(array);
        }
        catch (JSONException e) {
            this.log.warn((Object)"Unable to create JSON Array from bootstrap data");
        }
    }

    public void update(int timeslotIndex) {
        try {
            JSONArray chargeTotal = new JSONArray().put(timeslotIndex).put(this.currentInflowCharge + this.currentOutflowCharge);
            this.customerJson.getTotalChargeLineChartData().put((Object)chargeTotal);
            JSONArray kWhTotal = new JSONArray().put(timeslotIndex).put(this.currentKWhConsumed + this.currentKWhProduced);
            this.customerJson.getTotalkWhLineChartData().put((Object)kWhTotal);
            JSONArray chargeInflow = new JSONArray().put(timeslotIndex).put(this.currentInflowCharge);
            this.customerJson.getInflowChargeLineChartData().put((Object)chargeInflow);
            JSONArray chargeOutflow = new JSONArray().put(timeslotIndex).put(this.currentOutflowCharge);
            this.customerJson.getOutflowChargeLineChartData().put((Object)chargeOutflow);
            JSONArray kWhProd = new JSONArray().put(timeslotIndex).put(this.currentKWhProduced);
            this.customerJson.getProductionKWhLineChartData().put((Object)kWhProd);
            JSONArray kWhCons = new JSONArray().put(timeslotIndex).put(this.currentKWhConsumed);
            this.customerJson.getConsumptionKWhLineChartData().put((Object)kWhCons);
        }
        catch (JSONException e) {
            this.log.warn((Object)"Problem with customers JSON object update!");
        }
        this.currentInflowCharge = 0.0;
        this.currentOutflowCharge = 0.0;
        this.currentKWhConsumed = 0.0;
        this.currentKWhProduced = 0.0;
    }

    public CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }
}

