/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.wholesale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.log4j.Logger;
import org.powertac.common.ClearedTrade;
import org.powertac.visualizer.Helper;
import org.powertac.visualizer.domain.wholesale.WholesaleSnapshot;

public class WholesaleMarket {
    private static Logger log = Logger.getLogger(WholesaleMarket.class);
    private int timeslotSerialNumber;
    private Map<Integer, WholesaleSnapshot> snapshotsMap = new ConcurrentSkipListMap();
    private ClearedTrade lastClearedTrade;
    private double totalTradedQuantityMWh;
    private double weightSumTradedQuantityMWh;
    private double avgWeightPrice;
    private boolean closed;

    public WholesaleMarket(Integer timeslotSerialNumber) {
        this.timeslotSerialNumber = timeslotSerialNumber;
    }

    public int getTimeslotSerialNumber() {
        return this.timeslotSerialNumber;
    }

    public WholesaleSnapshot findSnapshot(int timeslotSerialNumber) {
        return (WholesaleSnapshot)this.snapshotsMap.get(timeslotSerialNumber);
    }

    public Map<Integer, WholesaleSnapshot> getSnapshotsMap() {
        return this.snapshotsMap;
    }

    public ClearedTrade getLastClearedTrade() {
        return this.lastClearedTrade;
    }

    public double getTotalTradedQuantityMWh() {
        return this.totalTradedQuantityMWh;
    }

    public double getAvgWeightPrice() {
        return this.avgWeightPrice;
    }

    public double getWeightSumTradedQuantityMWh() {
        return this.weightSumTradedQuantityMWh;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.finish();
        this.closed = true;
        log.debug((Object)("Market: TS serial num:" + this.getTimeslotSerialNumber() + "Total traded quantity:" + this.getTotalTradedQuantityMWh() + " is closed"));
    }

    private void finish() {
        Collection wholesaleSnapshots = this.snapshotsMap.values();
        for (WholesaleSnapshot wholesaleSnapshot : wholesaleSnapshots) {
            if (wholesaleSnapshot.getClearedTrade() == null) continue;
            double quantity = wholesaleSnapshot.getClearedTrade().getExecutionMWh();
            double price = wholesaleSnapshot.getClearedTrade().getExecutionPrice();
            this.totalTradedQuantityMWh += quantity;
            this.weightSumTradedQuantityMWh += quantity * price;
        }
        this.avgWeightPrice = this.totalTradedQuantityMWh != 0.0 ? this.weightSumTradedQuantityMWh / this.totalTradedQuantityMWh : 0.0;
        this.truncateNumbers();
    }

    private void truncateNumbers() {
        this.avgWeightPrice = Helper.roundNumberTwoDecimal((double)this.avgWeightPrice);
        this.totalTradedQuantityMWh = Helper.roundNumberTwoDecimal((double)this.totalTradedQuantityMWh);
        this.weightSumTradedQuantityMWh = Helper.roundNumberTwoDecimal((double)this.weightSumTradedQuantityMWh);
    }

    public String toString() {
        return "TS Number: " + this.timeslotSerialNumber + " AVG WEIGHT PRICE: " + this.avgWeightPrice + " totalTradedQuantity: " + this.totalTradedQuantityMWh;
    }

    public String getName() {
        return "Market" + this.timeslotSerialNumber;
    }

    public String getType() {
        return "Wholesale Market";
    }

    public String getTotalTradedQuantity() {
        return "" + this.totalTradedQuantityMWh;
    }

    public ArrayList<WholesaleSnapshot> getSnapshots() {
        return new ArrayList<WholesaleSnapshot>(this.snapshotsMap.values());
    }
}

