/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.wholesale;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.apache.log4j.Logger;
import org.powertac.common.ClearedTrade;
import org.powertac.common.Order;
import org.powertac.common.Orderbook;
import org.powertac.common.OrderbookOrder;
import org.powertac.common.Timeslot;
import org.powertac.visualizer.Helper;
import org.powertac.visualizer.json.WholesaleSnapshotJSON;
import org.primefaces.json.JSONArray;
import org.primefaces.json.JSONException;

public class WholesaleSnapshot {
    private static final int MARKET_PRICE = 100;
    Logger log = Logger.getLogger((String)WholesaleSnapshot.class.getName());
    private int timeslotSerialNumberCreated;
    private int timeslotSerialNumber;
    private Timeslot timeslot;
    private double totalTradedQuantity;
    private WholesaleSnapshotJSON wholesaleSnapshotJSON;
    private Orderbook orders;
    private ClearedTrade clearedTrade;
    private Orderbook orderbook;
    private boolean closed;
    private OrderbookOrder marketAskOrder;
    private OrderbookOrder marketBidOrder;
    private List<OrderbookOrder> beforeAsks;
    private List<OrderbookOrder> beforeBids;
    private List<OrderbookOrder> afterAsks;
    private List<OrderbookOrder> afterBids;

    public WholesaleSnapshot(Timeslot timeslot, int timeslotSerialNumberCreated) {
        this.timeslotSerialNumber = timeslot.getSerialNumber();
        this.orders = new Orderbook(timeslot, null, null);
        this.timeslot = timeslot;
        this.timeslotSerialNumberCreated = timeslotSerialNumberCreated;
    }

    public void addOrder(Order order) {
        OrderbookOrder orderbookOrder = new OrderbookOrder(order.getMWh(), order.getLimitPrice());
        if (order.getMWh() > 0.0) {
            if (order.getLimitPrice() == null) {
                this.marketBidOrder = orderbookOrder;
            } else {
                this.orders.addBid(orderbookOrder);
            }
        } else if (order.getLimitPrice() == null) {
            this.marketAskOrder = orderbookOrder;
        } else {
            this.orders.addAsk(orderbookOrder);
        }
    }

    public Orderbook getOrders() {
        return this.orders;
    }

    public void setOrders(Orderbook orders) {
        this.orders = orders;
    }

    public ClearedTrade getClearedTrade() {
        return this.clearedTrade;
    }

    public void setClearedTrade(ClearedTrade clearedTrade) {
        this.clearedTrade = clearedTrade;
    }

    public Orderbook getOrderbook() {
        return this.orderbook;
    }

    public void setOrderbook(Orderbook orderbook) {
        this.orderbook = orderbook;
    }

    public Timeslot getTimeslot() {
        return this.timeslot;
    }

    public WholesaleSnapshotJSON getWholesaleSnapshotJSON() {
        return this.wholesaleSnapshotJSON;
    }

    public String toString() {
        SortedSet bids;
        SortedSet asks;
        StringBuilder builder = new StringBuilder();
        builder.append("____________ORDERS:________\n");
        if (this.orders != null) {
            builder.append("ASKS:\n");
            asks = this.orders.getAsks();
            for (OrderbookOrder orderbookOrder : asks) {
                builder.append(orderbookOrder).append("\n");
            }
            builder.append("ORDERS:\nBIDS:");
            bids = this.orders.getBids();
            for (OrderbookOrder orderbookOrder : bids) {
                builder.append(orderbookOrder).append("\n");
            }
            if (this.marketAskOrder != null) {
                builder.append("MARKET ASK ORDER:\n");
                builder.append(this.marketAskOrder).append("\n");
            }
            if (this.marketBidOrder != null) {
                builder.append("MARKET BID ORDER:\n");
                builder.append(this.marketBidOrder).append("\n");
            }
        }
        builder.append("____________ORDERBOOK:________\n");
        if (this.orderbook != null) {
            builder.append("ASKS:\n");
            asks = this.orderbook.getAsks();
            for (OrderbookOrder orderbookOrder : asks) {
                builder.append(orderbookOrder).append("\n");
            }
            builder.append("BIDS:\n");
            bids = this.orderbook.getBids();
            for (OrderbookOrder orderbookOrder : bids) {
                builder.append(orderbookOrder).append("\n");
            }
        }
        return "" + builder + "\n\n" + this.clearedTrade;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getTimeslotSerialNumber() {
        return this.timeslotSerialNumber;
    }

    public void close() {
        this.finish();
        this.closed = true;
    }

    private void finish() {
        WholesaleSnapshotJSON json;
        if (this.clearedTrade != null) {
            this.totalTradedQuantity = Helper.roundNumberTwoDecimal((double)this.clearedTrade.getExecutionMWh());
        }
        JSONArray graphDataBeforeClearing = new JSONArray();
        JSONArray seriesColorsBeforeClearing = new JSONArray();
        SortedSet asks = this.orders.getAsks();
        SortedSet bids = this.orders.getBids();
        this.modifyMarketOrders();
        this.buildBeforeData(asks, bids, graphDataBeforeClearing, seriesColorsBeforeClearing);
        JSONArray graphDataAfterClearing = new JSONArray();
        JSONArray seriesColorsAfterClearing = new JSONArray();
        SortedSet asksAfter = this.orderbook.getAsks();
        SortedSet bidsAfter = this.orderbook.getBids();
        this.buildAfterData(asksAfter, bidsAfter, graphDataAfterClearing, seriesColorsAfterClearing);
        this.wholesaleSnapshotJSON = json = new WholesaleSnapshotJSON(graphDataBeforeClearing, seriesColorsBeforeClearing, graphDataAfterClearing, seriesColorsAfterClearing);
        this.log.debug((Object)("Snapshot " + this.getTimeslotSerialNumber() + "@" + this.getTimeslotSerialNumberCreated() + " is closed: \n" + this.toString()));
        this.beforeAsks = new ArrayList(this.orders.getAsks());
        this.beforeBids = new ArrayList(this.orders.getBids());
        this.afterAsks = new ArrayList(this.orderbook.getAsks());
        this.afterBids = new ArrayList(this.orderbook.getBids());
    }

    private void modifyMarketOrders() {
        double newPrice;
        SortedSet asks = this.orders.getAsks();
        SortedSet bids = this.orders.getBids();
        OrderbookOrder lowestAsk = null;
        OrderbookOrder highestAsk = null;
        OrderbookOrder lowestBid = null;
        OrderbookOrder highestBid = null;
        if (!asks.isEmpty()) {
            lowestAsk = (OrderbookOrder)asks.first();
            highestAsk = (OrderbookOrder)asks.last();
        }
        if (!bids.isEmpty()) {
            highestBid = (OrderbookOrder)bids.first();
            lowestBid = (OrderbookOrder)bids.last();
        }
        if (this.marketAskOrder != null) {
            newPrice = highestBid != null && lowestAsk != null ? (Math.abs(highestBid.getLimitPrice()) < Math.abs(lowestAsk.getLimitPrice()) ? 0.8 * Math.abs(highestBid.getLimitPrice()) : 0.8 * Math.abs(lowestAsk.getLimitPrice())) : 100.0;
            this.marketAskOrder = new OrderbookOrder(this.marketAskOrder.getMWh(), Double.valueOf(newPrice));
        }
        if (this.marketBidOrder != null) {
            newPrice = lowestBid != null && highestAsk != null ? (Math.abs(lowestBid.getLimitPrice()) > Math.abs(highestAsk.getLimitPrice()) ? -1.2 * Math.abs(lowestBid.getLimitPrice()) : -1.2 * Math.abs(highestAsk.getLimitPrice())) : -100.0;
            this.marketBidOrder = new OrderbookOrder(this.marketBidOrder.getMWh(), Double.valueOf(newPrice));
        }
    }

    private void buildAfterData(SortedSet<OrderbookOrder> asksAfter, SortedSet<OrderbookOrder> bidsAfter, JSONArray graphDataAfterClearing, JSONArray seriesColorsAfterClearing) {
        double clearedTradeOffset = 0.0;
        if (this.clearedTrade != null) {
            clearedTradeOffset = this.buildLine(Math.abs(this.clearedTrade.getExecutionMWh()), Math.abs(this.clearedTrade.getExecutionPrice()), graphDataAfterClearing, seriesColorsAfterClearing, 0.0, WholesaleSnapshotJSON.getClearedTradeColor());
        }
        double askOffset = clearedTradeOffset;
        for (OrderbookOrder orderbookOrder : asksAfter) {
            if (orderbookOrder.getLimitPrice() == null) {
                OrderbookOrder newMarketAskOrder = this.modifyMarketOrder(orderbookOrder, asksAfter);
                askOffset = this.buildLine(Math.abs(newMarketAskOrder.getMWh()), Math.abs(newMarketAskOrder.getLimitPrice()), graphDataAfterClearing, seriesColorsAfterClearing, askOffset, WholesaleSnapshotJSON.getMarketAskOrderColor());
                continue;
            }
            askOffset = this.buildLine(Math.abs(orderbookOrder.getMWh()), Math.abs(orderbookOrder.getLimitPrice()), graphDataAfterClearing, seriesColorsAfterClearing, askOffset, WholesaleSnapshotJSON.getLimitAskOrderColor());
        }
        double bidOffset = clearedTradeOffset;
        for (OrderbookOrder orderbookOrder : bidsAfter) {
            if (orderbookOrder.getLimitPrice() == null) {
                OrderbookOrder newMarketAskOrder = this.modifyMarketOrder(orderbookOrder, bidsAfter);
                bidOffset = this.buildLine(Math.abs(newMarketAskOrder.getMWh()), Math.abs(newMarketAskOrder.getLimitPrice()), graphDataAfterClearing, seriesColorsAfterClearing, bidOffset, WholesaleSnapshotJSON.getMarketBidOrderColor());
                continue;
            }
            bidOffset = this.buildLine(Math.abs(orderbookOrder.getMWh()), Math.abs(orderbookOrder.getLimitPrice()), graphDataAfterClearing, seriesColorsAfterClearing, bidOffset, WholesaleSnapshotJSON.getLimitBidOrderColor());
        }
    }

    private void buildBeforeData(SortedSet<OrderbookOrder> asks, SortedSet<OrderbookOrder> bids, JSONArray graphData, JSONArray seriesColors) {
        double askOffset = 0.0;
        if (this.marketAskOrder != null) {
            askOffset = this.buildLine(Math.abs(this.marketAskOrder.getMWh()), Math.abs(this.marketAskOrder.getLimitPrice()), graphData, seriesColors, askOffset, WholesaleSnapshotJSON.getMarketAskOrderColor());
        }
        for (OrderbookOrder orderbookOrder : asks) {
            askOffset = this.buildLine(Math.abs(orderbookOrder.getMWh()), Math.abs(orderbookOrder.getLimitPrice()), graphData, seriesColors, askOffset, WholesaleSnapshotJSON.getLimitAskOrderColor());
        }
        double bidOffset = 0.0;
        if (this.marketBidOrder != null) {
            bidOffset = this.buildLine(Math.abs(this.marketBidOrder.getMWh()), Math.abs(this.marketBidOrder.getLimitPrice()), graphData, seriesColors, bidOffset, WholesaleSnapshotJSON.getMarketBidOrderColor());
        }
        for (OrderbookOrder orderbookOrder : bids) {
            bidOffset = this.buildLine(Math.abs(orderbookOrder.getMWh()), Math.abs(orderbookOrder.getLimitPrice()), graphData, seriesColors, bidOffset, WholesaleSnapshotJSON.getLimitBidOrderColor());
        }
    }

    private OrderbookOrder modifyMarketOrder(OrderbookOrder marketOrder, SortedSet<OrderbookOrder> offers) {
        try {
            OrderbookOrder first = offers.first();
            Double limitPrice = first.getLimitPrice();
            double newMarketPrice = limitPrice == null ? (first.getMWh() > 0.0 ? -100.0 : 100.0) : (first.getMWh() > 0.0 ? -1.2 * limitPrice : 0.8 * limitPrice);
            return new OrderbookOrder(marketOrder.getMWh(), Double.valueOf(newMarketPrice));
        }
        catch (NoSuchElementException e) {
            this.log.debug((Object)"market order is forever alone.");
            return new OrderbookOrder(marketOrder.getMWh(), Double.valueOf(0.0));
        }
    }

    private double buildLine(double x, double y, JSONArray graphData, JSONArray seriesColors, double offset, String color) {
        try {
            double leftX_Axis = offset;
            JSONArray lineData = new JSONArray();
            JSONArray leftCoordData = new JSONArray();
            JSONArray rightCoordData = new JSONArray();
            leftCoordData.put(leftX_Axis).put(y);
            rightCoordData.put(offset += x).put(y);
            lineData.put((Object)leftCoordData).put((Object)rightCoordData);
            graphData.put((Object)lineData);
            seriesColors.put((Object)color);
            return offset;
        }
        catch (JSONException e) {
            this.log.warn((Object)"Building JSON Array failed.");
            return 0.0;
        }
    }

    public String getName() {
        return "Snapshot" + this.timeslotSerialNumberCreated;
    }

    public String getType() {
        return "Wholsale snapshot";
    }

    public String getTotalTradedQuantity() {
        return "" + this.totalTradedQuantity;
    }

    public int getTimeslotSerialNumberCreated() {
        return this.timeslotSerialNumberCreated;
    }

    public OrderbookOrder getMarketAskOrder() {
        return this.marketAskOrder;
    }

    public OrderbookOrder getMarketBidOrder() {
        return this.marketBidOrder;
    }

    public List<OrderbookOrder> getAfterAsks() {
        return this.afterAsks;
    }

    public List<OrderbookOrder> getAfterBids() {
        return this.afterBids;
    }

    public List<OrderbookOrder> getBeforeAsks() {
        return this.beforeAsks;
    }

    public List<OrderbookOrder> getBeforeBids() {
        return this.beforeBids;
    }
}

