/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.interfaces.Recyclable;
import org.powertac.visualizer.interfaces.TimeslotCompleteActivation;
import org.powertac.visualizer.json.BrokersJSON;
import org.primefaces.json.JSONArray;
import org.springframework.stereotype.Service;

@Service
public class BrokerService
implements TimeslotCompleteActivation,
Recyclable,
Serializable {
    private Logger log = Logger.getLogger(BrokerService.class);
    private static final long serialVersionUID = 1L;
    private Map<String, BrokerModel> map;
    private ArrayList<BrokerModel> brokers = new ArrayList();
    private BrokersJSON json = new BrokersJSON();

    public void setMap(Map<String, BrokerModel> map) {
        this.map = map;
    }

    public void setBrokers(ArrayList<BrokerModel> brokers) {
        this.brokers = brokers;
    }

    public BrokerModel findBrokerByName(String name) {
        return (BrokerModel)this.map.get(name);
    }

    public void recycle() {
        this.map = null;
        this.brokers = new ArrayList();
        this.json = new BrokersJSON();
    }

    public BrokersJSON getJson() {
        return this.json;
    }

    public void setJson(BrokersJSON json) {
        this.json = json;
    }

    public void activate(int timeslotIndex) {
        JSONArray cashChartData = new JSONArray();
        JSONArray customerCountData = new JSONArray();
        for (BrokerModel broker : this.brokers) {
            this.log.trace((Object)("Updating broker model:" + broker.getName()));
            broker.update(timeslotIndex);
            cashChartData.put((Object)broker.getJson().getCashBalanceJson());
            customerCountData.put(broker.getCustomerCount());
        }
        this.json.setCashChartData(cashChartData);
        this.json.setCustomerCountData(customerCountData);
    }

    public List<BrokerModel> getBrokerList() {
        return this.brokers;
    }

    public ArrayList<BrokerModel> getBrokers() {
        return new ArrayList<BrokerModel>(this.brokers);
    }
}

