/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MessageDispatcher {
    private static Logger log = Logger.getLogger(MessageDispatcher.class);
    private HashMap<Class<?>, Set<Object>> registrations = new HashMap();

    public void registerMessageHandler(Object handler, Class<?> messageType) {
        HashSet<Object> reg = (HashSet<Object>)this.registrations.get(messageType);
        if (reg == null) {
            reg = new HashSet<Object>();
            this.registrations.put(messageType, reg);
        }
        reg.add(handler);
    }

    public void routeMessage(Object message) {
        Class<?> clazz = message.getClass();
        log.debug((Object)("Route " + clazz.getName()));
        Set targets = (Set)this.registrations.get(clazz);
        if (targets == null) {
            log.warn((Object)("no targets for message of type " + clazz.getName()));
            return;
        }
        for (Object target : targets) {
            log.trace((Object)("dipatching to:" + target.getClass().getName()));
            MessageDispatcher.dispatch(target, (String)"handleMessage", (Object[])new Object[]{message});
        }
    }

    public static Object dispatch(Object target, String methodName, Object ... args) {
        Logger log = Logger.getLogger((String)target.getClass().getName());
        Object result = null;
        try {
            Class[] classes = new Class[args.length];
            for (int index = 0; index < args.length; ++index) {
                classes[index] = args[index].getClass();
            }
            Method method = target.getClass().getMethod(methodName, classes);
            log.debug((Object)("found method " + method));
            result = method.invoke(target, args);
        }
        catch (NoSuchMethodException nsm) {
            log.debug((Object)("Could not find exact match: " + nsm.toString()));
        }
        catch (InvocationTargetException ite) {
            Throwable thr = ite.getTargetException();
            if (thr.getStackTrace().length > 3) {
                log.error((Object)("Cannot call " + methodName + ": " + thr + "\n  ..at " + thr.getStackTrace()[0] + "\n  ..at " + thr.getStackTrace()[1] + "\n  ..at " + thr.getStackTrace()[2] + "\n  ..at " + thr.getStackTrace()[3] + "\n  ..at "));
            } else {
                log.error((Object)("Cannot call " + methodName + ", StackTrace size is:" + thr.getStackTrace().length));
            }
        }
        catch (Exception ex) {
            log.error((Object)("Exception calling message processor: " + ex.toString()));
        }
        return result;
    }
}

