/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.wholesale;

import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.time.Instant;
import org.powertac.common.Orderbook;
import org.powertac.common.OrderbookOrder;
import org.powertac.common.Timeslot;
import org.powertac.visualizer.domain.wholesale.VisualizerOrderbookOrder;

public class VisualizerOrderbook {
    private Instant dateExecuted;
    private Timeslot timeslot;
    private Double clearingPrice;
    private SortedSet<VisualizerOrderbookOrder> bids = new TreeSet();
    private SortedSet<VisualizerOrderbookOrder> asks = new TreeSet();

    public VisualizerOrderbook(Timeslot timeslot, Double clearingPrice, Instant dateExecuted) {
        this.timeslot = timeslot;
        this.clearingPrice = clearingPrice;
        this.dateExecuted = dateExecuted;
    }

    public VisualizerOrderbook(Orderbook orderbook) {
        this.timeslot = orderbook.getTimeslot();
        this.clearingPrice = orderbook.getClearingPrice();
        this.dateExecuted = orderbook.getDateExecuted();
        SortedSet asks = orderbook.getAsks();
        for (OrderbookOrder orderbookOrder : asks) {
            this.addAsk(new VisualizerOrderbookOrder(orderbookOrder.getMWh(), orderbookOrder.getLimitPrice()));
        }
        SortedSet bids = orderbook.getBids();
        for (OrderbookOrder orderbookOrder : bids) {
            this.addBid(new VisualizerOrderbookOrder(orderbookOrder.getMWh(), orderbookOrder.getLimitPrice()));
        }
    }

    public Double getClearingPrice() {
        return this.clearingPrice;
    }

    public Instant getDateExecuted() {
        return this.dateExecuted;
    }

    public Timeslot getTimeslot() {
        return this.timeslot;
    }

    public SortedSet<VisualizerOrderbookOrder> getBids() {
        return this.bids;
    }

    public VisualizerOrderbook addBid(VisualizerOrderbookOrder bid) {
        this.bids.add(bid);
        return this;
    }

    public SortedSet<VisualizerOrderbookOrder> getAsks() {
        return this.asks;
    }

    public VisualizerOrderbook addAsk(VisualizerOrderbookOrder ask) {
        this.asks.add(ask);
        return this;
    }
}

