/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.WeatherForecast;
import org.powertac.common.WeatherReport;
import org.powertac.visualizer.interfaces.Recyclable;
import org.powertac.visualizer.interfaces.TimeslotCompleteActivation;
import org.powertac.visualizer.json.WeatherServiceJson;
import org.primefaces.json.JSONArray;
import org.primefaces.json.JSONException;
import org.springframework.stereotype.Service;

@Service
public class WeatherInfoService
implements TimeslotCompleteActivation,
Recyclable {
    private static Logger log = Logger.getLogger(WeatherInfoService.class);
    private ArrayList<WeatherReport> reports;
    private ArrayList<WeatherForecast> forecasts;
    private WeatherReport currentReport;
    private WeatherForecast currentForecast;
    private WeatherServiceJson json;

    public WeatherInfoService() {
        this.recycle();
    }

    public void activate(int timeslotIndex, Instant postedTime) {
        if (this.currentReport != null) {
            this.reports.add(this.currentReport);
            this.updateJsonWithReport();
        }
        if (this.currentForecast != null) {
            this.forecasts.add(this.currentForecast);
        }
    }

    private void updateJsonWithReport() {
        try {
            this.json.getCloudCoverData().put((Object)new JSONArray().put(this.currentReport.getCurrentTimeslot().getStartInstant().getMillis()).put(this.currentReport.getCloudCover()));
            this.json.getTemperatureData().put((Object)new JSONArray().put(this.currentReport.getCurrentTimeslot().getStartInstant().getMillis()).put(this.currentReport.getTemperature()));
            this.json.getWindSpeedData().put((Object)new JSONArray().put(this.currentReport.getCurrentTimeslot().getStartInstant().getMillis()).put(this.currentReport.getWindSpeed()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void recycle() {
        this.reports = new ArrayList();
        this.forecasts = new ArrayList();
        this.json = new WeatherServiceJson();
        this.currentForecast = null;
        this.currentReport = null;
    }

    public WeatherReport getCurrentReport() {
        return this.currentReport;
    }

    public void setCurrentReport(WeatherReport currentReport) {
        this.currentReport = currentReport;
    }

    public WeatherForecast getCurrentForecast() {
        return this.currentForecast;
    }

    public void setCurrentForecast(WeatherForecast currentForecast) {
        this.currentForecast = currentForecast;
    }

    public ArrayList<WeatherReport> getReports() {
        return this.reports;
    }

    public ArrayList<WeatherForecast> getForecasts() {
        return this.forecasts;
    }

    public WeatherServiceJson getJson() {
        return this.json;
    }
}

