/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services.handlers;

import java.util.Arrays;
import org.powertac.common.Broker;
import org.powertac.common.CashPosition;
import org.powertac.common.MarketPosition;
import org.powertac.common.MarketTransaction;
import org.powertac.visualizer.MessageDispatcher;
import org.powertac.visualizer.domain.genco.Genco;
import org.powertac.visualizer.interfaces.Initializable;
import org.powertac.visualizer.services.GencoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GencoMessageHandler
implements Initializable {
    @Autowired
    private MessageDispatcher router;
    @Autowired
    private GencoService gencoService;

    public void initialize() {
        for (Class clazz : Arrays.asList(CashPosition.class, MarketTransaction.class, MarketPosition.class)) {
            this.router.registerMessageHandler((Object)this, clazz);
        }
    }

    public void handleMessage(CashPosition position) {
        Broker broker = position.getBroker();
        if (broker.isWholesale()) {
            Genco genco = this.gencoService.findGencoByUsername(broker.getUsername());
            if (genco == null) {
                genco = this.gencoService.addGenco(broker);
            }
            genco.addCashPosition(position);
        }
    }

    public void handleMessage(MarketTransaction transaction) {
        Broker broker = transaction.getBroker();
        if (broker.isWholesale()) {
            Genco genco = this.gencoService.findGencoByUsername(broker.getUsername());
            genco.findWholesaleDataByTimeslot(transaction.getTimeslot()).addMarketTransaction(transaction);
        }
    }

    public void handleMessage(MarketPosition position) {
        Broker broker = position.getBroker();
        if (broker.isWholesale()) {
            Genco genco = this.gencoService.findGencoByUsername(broker.getUsername());
            genco.findWholesaleDataByTimeslot(position.getTimeslot()).addMarketPosition(position);
        }
    }
}

