/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services.handlers;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.BankTransaction;
import org.powertac.common.Competition;
import org.powertac.common.MarketPosition;
import org.powertac.common.MarketTransaction;
import org.powertac.common.msg.DistributionReport;
import org.powertac.common.msg.SimEnd;
import org.powertac.common.msg.SimPause;
import org.powertac.common.msg.SimResume;
import org.powertac.common.msg.SimStart;
import org.powertac.common.msg.TariffExpire;
import org.powertac.common.msg.TariffRevoke;
import org.powertac.common.msg.TariffStatus;
import org.powertac.common.msg.TariffUpdate;
import org.powertac.common.msg.TimeslotComplete;
import org.powertac.common.msg.TimeslotUpdate;
import org.powertac.visualizer.MessageDispatcher;
import org.powertac.visualizer.VisualizerApplicationContext;
import org.powertac.visualizer.beans.AppearanceListBean;
import org.powertac.visualizer.beans.VisualizerBean;
import org.powertac.visualizer.interfaces.Initializable;
import org.powertac.visualizer.interfaces.TimeslotCompleteActivation;
import org.powertac.visualizer.services.handlers.VisualizerMessageHandlerHelperService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualizerMessageHandlerService
implements Initializable {
    private Logger log = Logger.getLogger(VisualizerMessageHandlerService.class);
    @Autowired
    private VisualizerBean visualizerBean;
    @Autowired
    private VisualizerMessageHandlerHelperService helper;
    @Autowired
    private AppearanceListBean appearanceListBean;
    @Autowired
    private MessageDispatcher router;

    public void handleMessage(Competition competition) {
        this.visualizerBean.setRunning(true);
        this.visualizerBean.setCompetition(competition);
    }

    public void handleMessage(TimeslotUpdate timeslotUpdate) {
        this.visualizerBean.setTimeslotUpdate(timeslotUpdate);
        this.visualizerBean.setCurrentMillis(timeslotUpdate.getPostedTime().getMillis());
        if (this.visualizerBean.getFirstTimeslotInstant() == null) {
            this.visualizerBean.setFirstTimeslotInstant(timeslotUpdate.getPostedTime());
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Enabled timeslots:");
        for (int i = timeslotUpdate.getFirstEnabled(); i < timeslotUpdate.getLastEnabled(); ++i) {
            builder.append(" ").append(i);
        }
        this.log.debug((Object)(builder + "\n"));
        int relativeTimeslotIndex = this.helper.computeRelativeTimeslotIndex(timeslotUpdate.getPostedTime());
        this.visualizerBean.setRelativeTimeslotIndex(relativeTimeslotIndex);
        this.log.debug((Object)("\nTimeslot index: " + relativeTimeslotIndex + "\nPostedtime:" + timeslotUpdate.getPostedTime()));
        Competition comp = this.visualizerBean.getCompetition();
        int timeslotSerialNumber = timeslotUpdate.getFirstEnabled() - comp.getDeactivateTimeslotsAhead();
        this.visualizerBean.setCurrentTimeslotSerialNumber(timeslotSerialNumber);
        this.visualizerBean.setWeek(timeslotSerialNumber / 168);
        this.visualizerBean.setDay(timeslotSerialNumber / 24);
        this.visualizerBean.setHour(timeslotSerialNumber % 24);
    }

    public void handleMessage(TimeslotComplete complete) {
        if (this.visualizerBean.getFirstTimeslotIndex() == -1) {
            this.visualizerBean.setFirstTimeslotIndex(complete.getTimeslotIndex());
        }
        List activators = VisualizerApplicationContext.listBeansOfType(TimeslotCompleteActivation.class);
        for (TimeslotCompleteActivation active : activators) {
            this.log.debug((Object)("activating..." + active.getClass().getSimpleName()));
            active.activate(complete.getTimeslotIndex(), this.visualizerBean.getTimeslotUpdate().getPostedTime());
        }
        int relativeTimeslotIndex = complete.getTimeslotIndex() - this.visualizerBean.getFirstTimeslotIndex();
        if (relativeTimeslotIndex % 23 == 0 && this.visualizerBean.getFirstTimeslotIndex() != complete.getTimeslotIndex()) {
            this.helper.buildDayOverview();
        }
    }

    public void handleMessage(SimStart simStart) {
    }

    public void handleMessage(SimEnd simEnd) {
        this.visualizerBean.setRunning(false);
        this.visualizerBean.setFinished(true);
    }

    public void handleMessage(SimPause simPause) {
    }

    public void handleMessage(BankTransaction bankTransaction) {
    }

    public void handleMessage(MarketTransaction marketTransaction) {
        this.log.debug((Object)("\nBroker: " + marketTransaction.getBroker().getUsername() + " MWh: " + marketTransaction.getMWh() + "\n Price: " + marketTransaction.getPrice() + " Postedtime: " + marketTransaction.getPostedTime() + " Timeslot\n Serial Number: " + marketTransaction.getTimeslot().getSerialNumber() + " Index: " + this.helper.computeRelativeTimeslotIndex(marketTransaction.getTimeslot().getStartInstant())));
    }

    public void handleMessage(MarketPosition marketPosition) {
        this.log.debug((Object)("\nBroker: " + marketPosition.getBroker() + " Overall Balance: " + marketPosition.getOverallBalance() + "\n Timeslot:\n serialnumber: " + marketPosition.getTimeslot().getSerialNumber() + " Timeslot\n Serial Number: " + marketPosition.getTimeslot().getSerialNumber() + " Index: " + this.helper.computeRelativeTimeslotIndex(marketPosition.getTimeslot().getStartInstant())));
    }

    public void handleMessage(SimResume simResume) {
    }

    public void handleMessage(DistributionReport report) {
        this.log.debug((Object)("DIST REPORT: PROD " + report.getTotalProduction() + "CONS " + report.getTotalConsumption()));
    }

    public void handleMessage(TariffExpire msg) {
    }

    public void handleMessage(TariffRevoke msg) {
    }

    public void handleMessage(TariffStatus msg) {
    }

    public void handleMessage(TariffUpdate msg) {
    }

    public void initialize() {
        for (Class clazz : Arrays.asList(DistributionReport.class, SimResume.class, SimEnd.class, MarketPosition.class, MarketTransaction.class, BankTransaction.class, SimPause.class, SimStart.class, TimeslotComplete.class, TimeslotUpdate.class, Competition.class, TariffExpire.class, TariffRevoke.class, TariffStatus.class, TariffUpdate.class)) {
            this.router.registerMessageHandler((Object)this, clazz);
        }
    }
}

