/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services.handlers;

import java.util.Arrays;
import java.util.SortedSet;
import org.apache.log4j.Logger;
import org.powertac.common.ClearedTrade;
import org.powertac.common.Order;
import org.powertac.common.Orderbook;
import org.powertac.common.OrderbookOrder;
import org.powertac.visualizer.MessageDispatcher;
import org.powertac.visualizer.beans.VisualizerBean;
import org.powertac.visualizer.domain.wholesale.VisualizerOrderbook;
import org.powertac.visualizer.domain.wholesale.WholesaleMarket;
import org.powertac.visualizer.domain.wholesale.WholesaleSnapshot;
import org.powertac.visualizer.interfaces.Initializable;
import org.powertac.visualizer.json.WholesaleServiceJSON;
import org.powertac.visualizer.services.WholesaleService;
import org.primefaces.json.JSONArray;
import org.primefaces.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WholesaleMessageHandler
implements Initializable {
    private Logger log = Logger.getLogger(WholesaleMessageHandler.class);
    @Autowired
    private VisualizerBean visualizerBean;
    @Autowired
    private MessageDispatcher router;
    @Autowired
    private WholesaleService wholesaleService;

    public void initialize() {
        for (Class clazz : Arrays.asList(Order.class, Orderbook.class, ClearedTrade.class)) {
            this.router.registerMessageHandler((Object)this, clazz);
        }
    }

    public void handleMessage(Order order) {
        WholesaleSnapshot snapshot;
        WholesaleMarket wholesaleMarket;
        this.log.debug((Object)("\nBroker: " + order.getBroker() + "\nLimit Price: " + order.getLimitPrice() + "\nMWh: " + order.getMWh() + " Timeslot\n Serial Number: " + order.getTimeslot().getSerialNumber()));
        int currentTimeslot = this.visualizerBean.getCurrentTimeslotSerialNumber();
        int timeslotSerialNumber = order.getTimeslot().getSerialNumber();
        if (!this.wholesaleService.getWholesaleMarkets().containsKey(timeslotSerialNumber)) {
            this.wholesaleService.getWholesaleMarkets().put(timeslotSerialNumber, new WholesaleMarket(order.getTimeslot(), Integer.valueOf(timeslotSerialNumber)));
        }
        if (!(wholesaleMarket = this.wholesaleService.findWholesaleMarket(Integer.valueOf(timeslotSerialNumber))).getSnapshotsMap().containsKey(currentTimeslot)) {
            snapshot = new WholesaleSnapshot(this.visualizerBean.getCurrentMillis(), order.getTimeslot(), currentTimeslot);
            wholesaleMarket.getSnapshotsMap().put(currentTimeslot, snapshot);
        }
        snapshot = wholesaleMarket.findSnapshot(currentTimeslot);
        snapshot.addOrder(order);
    }

    public void handleMessage(Orderbook orderbook) {
        SortedSet asks = orderbook.getAsks();
        SortedSet bids = orderbook.getBids();
        StringBuilder builder = new StringBuilder();
        builder.append("\nBids:\n");
        for (OrderbookOrder orderbookOrder : bids) {
            builder.append("\nLimitPrice: " + orderbookOrder.getLimitPrice() + " mWh: " + orderbookOrder.getMWh());
        }
        builder.append("\nAsks:\n");
        for (OrderbookOrder orderbookOrder : asks) {
            builder.append("\nLimitPrice: " + orderbookOrder.getLimitPrice() + " mWh: " + orderbookOrder.getMWh());
        }
        builder.append("\n\n Clearing price: " + orderbook.getClearingPrice() + "\nTimeslot\n Serial Number: " + orderbook.getTimeslot().getSerialNumber());
        int targetTimeslotIndex = this.visualizerBean.getCurrentTimeslotSerialNumber() - 1;
        WholesaleMarket market = this.wholesaleService.findWholesaleMarket(Integer.valueOf(orderbook.getTimeslot().getSerialNumber()));
        WholesaleSnapshot snapshot = market.findSnapshot(targetTimeslotIndex);
        snapshot.setOrderbook(new VisualizerOrderbook(orderbook));
        if (orderbook.getClearingPrice() == null) {
            snapshot.close();
            this.checkWholesaleMarket(market);
        }
        this.log.debug((Object)builder.toString());
    }

    private void checkWholesaleMarket(WholesaleMarket market) {
        int offset = market.getTimeslotSerialNumber() - this.visualizerBean.getCurrentTimeslotSerialNumber();
        if (offset == 0) {
            market.close();
            this.wholesaleService.addTradedQuantityMWh(market.getTotalTradedQuantityMWh());
            WholesaleSnapshot lastSnapshot = market.getLastWholesaleSnapshotWithClearing();
            if (lastSnapshot != null) {
                WholesaleServiceJSON json = this.wholesaleService.getJson();
                try {
                    json.getGlobalLastClearingPrices().put((Object)new JSONArray().put(lastSnapshot.getTimeslot().getStartInstant().getMillis()).put(lastSnapshot.getClearedTrade().getExecutionPrice()));
                    json.getGlobalLastClearingVolumes().put((Object)new JSONArray().put(lastSnapshot.getTimeslot().getStartInstant().getMillis()).put(lastSnapshot.getClearedTrade().getExecutionMWh()));
                    json.getGlobalTotalClearingVolumes().put((Object)new JSONArray().put(lastSnapshot.getTimeslot().getStartInstant().getMillis()).put(market.getTotalTradedQuantityMWh()));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void handleMessage(ClearedTrade clearedTrade) {
        this.log.debug((Object)("\nTimeslot\n Serial number: " + clearedTrade.getTimeslot().getSerialNumber() + "\nExecutionPrice:" + clearedTrade.getExecutionPrice() + " ExecutionMWh" + clearedTrade.getExecutionMWh()));
        int targetTimeslotIndex = this.visualizerBean.getCurrentTimeslotSerialNumber() - 1;
        WholesaleMarket market = this.wholesaleService.findWholesaleMarket(Integer.valueOf(clearedTrade.getTimeslot().getSerialNumber()));
        WholesaleSnapshot snapshot = market.findSnapshot(targetTimeslotIndex);
        snapshot.setClearedTrade(clearedTrade);
        snapshot.close();
        market.setLastWholesaleSnapshotWithClearing(snapshot);
        this.checkWholesaleMarket(market);
    }
}

