/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.powertac.visualizer.domain.wholesale.VisualizerOrderbookOrder;
import org.powertac.visualizer.domain.wholesale.WholesaleMarket;
import org.powertac.visualizer.domain.wholesale.WholesaleSnapshot;
import org.powertac.visualizer.services.WholesaleService;
import org.springframework.beans.factory.annotation.Autowired;

public class WholesaleBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private WholesaleSnapshot selectedSnapshot;
    private WholesaleMarket selectedMarket;
    private double totalTradedQuantityMWh;
    private WholesaleService model;
    private Collection<WholesaleMarket> markets;
    private List<VisualizerOrderbookOrder> beforeAsks;
    private List<VisualizerOrderbookOrder> afterAsks;

    @Autowired
    public WholesaleBean(WholesaleService wholesaleService) {
        this.model = wholesaleService;
        this.refresh();
    }

    private void refresh() {
        this.markets = new ArrayList(this.model.getWholesaleMarkets().values());
        this.totalTradedQuantityMWh = this.model.getTotalTradedQuantityMWh();
    }

    public WholesaleSnapshot getSelectedSnapshot() {
        return this.selectedSnapshot;
    }

    public void setSelectedSnapshot(WholesaleSnapshot selectedSnapshot) {
        this.selectedSnapshot = selectedSnapshot;
        this.beforeAsks = selectedSnapshot.getBeforeAsks();
        this.afterAsks = selectedSnapshot.getAfterAsks();
    }

    public WholesaleMarket getSelectedMarket() {
        return this.selectedMarket;
    }

    public void setSelectedMarket(WholesaleMarket selectedMarket) {
        this.selectedMarket = selectedMarket;
    }

    public double getTotalTradedQuantityMWh() {
        return this.totalTradedQuantityMWh;
    }

    public WholesaleService getModel() {
        return this.model;
    }

    public Collection<WholesaleMarket> getMarkets() {
        this.refresh();
        return this.markets;
    }

    public List<VisualizerOrderbookOrder> getAfterAsks() {
        return this.afterAsks;
    }

    public List<VisualizerOrderbookOrder> getBeforeAsks() {
        return this.beforeAsks;
    }

    public void clearSelections() {
        this.selectedSnapshot = null;
        this.selectedMarket = null;
    }
}

