/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.broker;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.BalancingTransaction;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffTransaction;
import org.powertac.visualizer.Helper;
import org.powertac.visualizer.domain.broker.DayState;
import org.powertac.visualizer.interfaces.DisplayableBroker;
import org.powertac.visualizer.json.DayStateJSON;

public class DayState {
    Logger log = Logger.getLogger(DayState.class);
    private int day = -1;
    private DisplayableBroker broker;
    private ArrayList<Double> cashBalances = new ArrayList();
    private double totalCashBalance;
    private double sumCashBalance;
    private double avgCashBalance;
    private ArrayList<Double> energyBalances = new ArrayList();
    private double avgEnergyBalance;
    private double sumEnergyBalance;
    DayStateJSON json = new DayStateJSON();
    private List<TariffSpecification> tariffSpecifications = new ArrayList();
    private List<TariffTransaction> tariffTransactions = new ArrayList();
    private int signupCustomersCount;
    private int withdrawCustomersCount;
    private List<BalancingTransaction> balancingTransactions = new ArrayList();
    private double totalBalancingCharge;
    private double totalBalancingKWh;

    public DayState(int day, DisplayableBroker displayableBroker) {
        this.day = day;
        this.broker = displayableBroker;
    }

    public DayState(DisplayableBroker broker) {
        this.broker = broker;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public void addTimeslotValues(int hour, double cashBalance, double energyBalance) {
        this.cashBalances.add(cashBalance);
        this.json.addDayCashAndEnergyPoint(Helper.pointJSON((int)hour, (double)cashBalance), Helper.pointJSON((int)hour, (double)energyBalance));
        this.sumCashBalance += cashBalance;
        this.totalCashBalance = cashBalance;
        this.avgCashBalance = this.sumCashBalance / (double)this.cashBalances.size();
        this.energyBalances.add(energyBalance);
        this.sumEnergyBalance += energyBalance;
        this.avgEnergyBalance = this.sumEnergyBalance / (double)this.energyBalances.size();
    }

    public void addTariffSpecification(TariffSpecification tariffSpecification) {
        this.tariffSpecifications.add(tariffSpecification);
    }

    public void addTariffTransaction(TariffTransaction tariffTransaction) {
        this.tariffTransactions.add(tariffTransaction);
        switch (1.$SwitchMap$org$powertac$common$TariffTransaction$Type[tariffTransaction.getTxType().ordinal()]) {
            case 1: {
                this.signupCustomersCount += tariffTransaction.getCustomerCount();
                break;
            }
            case 2: 
            case 3: {
                this.withdrawCustomersCount += tariffTransaction.getCustomerCount();
                break;
            }
        }
    }

    public void addBalancingTransaction(BalancingTransaction balancingTransaction) {
        this.balancingTransactions.add(balancingTransaction);
        this.totalBalancingCharge += new BigDecimal(balancingTransaction.getCharge()).setScale(2, 4).doubleValue();
        this.totalBalancingCharge = new BigDecimal(this.totalBalancingCharge).setScale(2, 4).doubleValue();
        this.totalBalancingKWh += new BigDecimal(balancingTransaction.getKWh()).setScale(2, 4).doubleValue();
        this.totalBalancingKWh = new BigDecimal(this.totalBalancingKWh).setScale(2, 4).doubleValue();
    }

    public int getTariffSpecificationsCount() {
        return this.tariffSpecifications.size();
    }

    public DayStateJSON getJson() {
        return this.json;
    }

    public double getAvgCashBalance() {
        return this.avgCashBalance;
    }

    public double getAvgEnergyBalance() {
        return this.avgEnergyBalance;
    }

    public int getDay() {
        return this.day;
    }

    public DisplayableBroker getBroker() {
        return this.broker;
    }

    public double getSumEnergyBalance() {
        return this.sumEnergyBalance;
    }

    public double getTotalCashBalance() {
        return this.totalCashBalance;
    }

    public Logger getLog() {
        return this.log;
    }

    public ArrayList<Double> getCashBalances() {
        return this.cashBalances;
    }

    public double getSumCashBalance() {
        return this.sumCashBalance;
    }

    public ArrayList<Double> getEnergyBalances() {
        return this.energyBalances;
    }

    public List<TariffSpecification> getTariffSpecifications() {
        return this.tariffSpecifications;
    }

    public List<TariffTransaction> getTariffTransactions() {
        return this.tariffTransactions;
    }

    public int getSignupCustomersCount() {
        return this.signupCustomersCount;
    }

    public int getWithdrawCustomersCount() {
        return this.withdrawCustomersCount;
    }

    public List<BalancingTransaction> getBalancingTransactions() {
        return this.balancingTransactions;
    }

    public double getTotalBalancingCharge() {
        return this.totalBalancingCharge;
    }

    public double getTotalBalancingKWh() {
        return this.totalBalancingKWh;
    }
}

