/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.broker;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Rate;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffTransaction;
import org.powertac.visualizer.Helper;
import org.powertac.visualizer.domain.broker.RateInfo;
import org.powertac.visualizer.interfaces.TimeslotModelUpdate;
import org.powertac.visualizer.json.TariffInfoJSON;
import org.primefaces.json.JSONArray;
import org.primefaces.json.JSONException;

public class TariffInfo
implements TimeslotModelUpdate {
    private Logger log = Logger.getLogger(TariffInfo.class);
    private TariffSpecification tariffSpecification;
    private ArrayList<TariffTransaction> tariffTransactions = new ArrayList();
    private ArrayList<String> tariffLifecycle = new ArrayList();
    private ArrayList<RateInfo> rateInfos;
    private TariffInfoJSON json = new TariffInfoJSON();
    private int subscribedPopulation;
    private double totalRevenue;
    private double hourlyRevenue;
    private double totalKWh;
    private double hourlyKWh;

    public TariffInfo(TariffSpecification tariffSpecification) {
        this.tariffSpecification = tariffSpecification;
        List rates = tariffSpecification.getRates();
        this.rateInfos = new ArrayList(rates.size());
        if (rates.size() == 1) {
            RateInfo rateInfo = new RateInfo((Rate)rates.get(0));
            this.rateInfos.add(rateInfo);
            this.json.setRatesLineChartMaxValue(rateInfo.getJson().getRateLineChartMaxValue());
            this.json.setRatesLineChartMinValue(rateInfo.getJson().getRateLineChartMinValue());
        } else {
            JSONArray ratesJsonMax = new JSONArray();
            JSONArray ratesJsonMin = new JSONArray();
            for (Rate rate : rates) {
                int i;
                RateInfo rateInfo = new RateInfo(rate);
                this.rateInfos.add(rateInfo);
                JSONArray maxArray = rateInfo.getJson().getRateLineChartMaxValue();
                JSONArray minArray = rateInfo.getJson().getRateLineChartMinValue();
                for (i = 0; i < maxArray.length(); ++i) {
                    try {
                        ratesJsonMax.put(maxArray.get(i));
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                for (i = 0; i < minArray.length(); ++i) {
                    try {
                        ratesJsonMin.put(minArray.get(i));
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.json.setRatesLineChartMaxValue(ratesJsonMax);
            this.json.setRatesLineChartMinValue(ratesJsonMin);
        }
        this.tariffLifecycle.add(tariffSpecification.toString());
    }

    public void addTariffMessage(String msg) {
        this.tariffLifecycle.add(msg);
    }

    public void addTariffTransaction(TariffTransaction tx) {
        this.tariffTransactions.add(tx);
        this.subscribedPopulation += Helper.getCustomerCount((TariffTransaction)tx);
        this.hourlyRevenue += tx.getCharge();
        this.hourlyKWh += tx.getKWh();
    }

    private void resetHourlyValues() {
        this.hourlyRevenue = 0.0;
        this.hourlyKWh = 0.0;
    }

    public void update(int timeslotIndex, Instant postedTime) {
        this.totalKWh += this.hourlyKWh;
        this.totalRevenue += this.hourlyRevenue;
        try {
            JSONArray totalRevenuePoint = new JSONArray();
            totalRevenuePoint.put(timeslotIndex).put(this.totalRevenue);
            this.json.getTotalRevenueLineChart().put((Object)totalRevenuePoint);
            JSONArray hourlyRevenuePoint = new JSONArray();
            hourlyRevenuePoint.put(timeslotIndex).put(this.hourlyRevenue);
            this.json.getHourlyRevenueLineChart().put((Object)hourlyRevenuePoint);
            JSONArray totalKWhPoint = new JSONArray();
            totalKWhPoint.put(timeslotIndex).put(this.totalKWh);
            this.json.getTotalKWhLineChart().put((Object)totalKWhPoint);
            JSONArray hourlyKWhPoint = new JSONArray();
            hourlyKWhPoint.put(timeslotIndex).put(this.hourlyKWh);
            this.json.getHourlyKWhLineChart().put((Object)hourlyKWhPoint);
            JSONArray subscribedPopulationPoint = new JSONArray();
            subscribedPopulationPoint.put(timeslotIndex).put(this.subscribedPopulation);
            this.json.getSubscribedPopulationLineChart().put((Object)subscribedPopulationPoint);
        }
        catch (JSONException e) {
            this.log.warn((Object)"JSON update for TariffInfo is not working.");
        }
        this.resetHourlyValues();
    }

    public Logger getLog() {
        return this.log;
    }

    public TariffSpecification getTariffSpecification() {
        return this.tariffSpecification;
    }

    public ArrayList<TariffTransaction> getTariffTransactions() {
        return (ArrayList)this.tariffTransactions.clone();
    }

    public ArrayList<String> getTariffLifecycle() {
        return (ArrayList)this.tariffLifecycle.clone();
    }

    public ArrayList<RateInfo> getRateInfos() {
        return (ArrayList)this.rateInfos.clone();
    }

    public TariffInfoJSON getJson() {
        return this.json;
    }

    public int getSubscribedPopulation() {
        return this.subscribedPopulation;
    }

    public double getTotalRevenue() {
        return this.totalRevenue;
    }

    public double getHourlyRevenue() {
        return this.hourlyRevenue;
    }

    public double getTotalKWh() {
        return this.totalKWh;
    }

    public double getHourlyKWh() {
        return this.hourlyKWh;
    }
}

