/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.powertac.visualizer.Helper;
import org.powertac.visualizer.domain.wholesale.WholesaleMarket;
import org.powertac.visualizer.interfaces.Recyclable;
import org.powertac.visualizer.json.WholesaleServiceJSON;
import org.springframework.stereotype.Service;

@Service
public class WholesaleService
implements Serializable,
Recyclable {
    private static final long serialVersionUID = 1L;
    private Map<Integer, WholesaleMarket> wholesaleMarkets;
    private double totalTradedQuantityMWh;
    private WholesaleServiceJSON json;

    public WholesaleService() {
        this.recycle();
    }

    public WholesaleMarket findWholesaleMarket(Integer timeslotSerialNumber) {
        return (WholesaleMarket)this.wholesaleMarkets.get(timeslotSerialNumber);
    }

    public Map<Integer, WholesaleMarket> getWholesaleMarkets() {
        return this.wholesaleMarkets;
    }

    public double getTotalTradedQuantityMWh() {
        return this.totalTradedQuantityMWh;
    }

    public void addTradedQuantityMWh(double quantity) {
        this.totalTradedQuantityMWh += quantity;
        this.totalTradedQuantityMWh = Helper.roundNumberTwoDecimal((double)this.totalTradedQuantityMWh);
    }

    public String getName() {
        return "Root";
    }

    public String getType() {
        return "wholesale model";
    }

    public String getTotalTradedQuantity() {
        return "" + this.totalTradedQuantityMWh;
    }

    public void recycle() {
        this.wholesaleMarkets = new ConcurrentSkipListMap();
        this.totalTradedQuantityMWh = 0.0;
        this.json = new WholesaleServiceJSON();
    }

    public WholesaleServiceJSON getJson() {
        return this.json;
    }
}

