/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services.competitioncontrol;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.powertac.common.interfaces.CompetitionControl;
import org.powertac.common.interfaces.CompetitionSetup;
import org.powertac.common.interfaces.VisualizerProxy;
import org.powertac.visualizer.services.VisualizerResourceLoaderService;
import org.powertac.visualizer.services.VisualizerService;
import org.powertac.visualizer.services.competitioncontrol.FakeBroker;
import org.powertac.visualizer.services.competitioncontrol.GameParamatersBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebCompetitionControlService {
    private static Logger log = Logger.getLogger(WebCompetitionControlService.class);
    @Autowired
    private VisualizerResourceLoaderService resourceLoader;
    @Autowired
    private CompetitionSetup css;
    @Autowired
    private CompetitionControl competitionControl;
    @Autowired
    private VisualizerService visualizerService;
    @Autowired
    private GameParamatersBean gameParamaters;
    @Autowired
    private VisualizerProxy visualizerProxy;
    private String message;

    public void runSim() {
        if (!this.competitionControl.isRunning()) {
            this.visualizerService.init(this.visualizerProxy);
            ArrayList<String> names = new ArrayList<String>();
            for (FakeBroker type : this.gameParamaters.getBrokers()) {
                names.add(type.getName());
            }
            String boot = this.gameParamaters.getBootstrapData().equals("") ? null : this.gameParamaters.getBootstrapData();
            String serverConfig = this.gameParamaters.getServerConfig().equals("") ? null : this.gameParamaters.getServerConfig();
            String jmsUrl = this.gameParamaters.getJmsUrl().equals("") ? null : this.gameParamaters.getJmsUrl();
            String logSuffix = this.gameParamaters.getLogSuffix().equals("") ? null : this.gameParamaters.getLogSuffix();
            System.out.println(boot + serverConfig + jmsUrl + logSuffix + names);
            String result = this.css.simSession(boot, serverConfig, jmsUrl, logSuffix, names, null);
            this.message = result == null ? "Simulation started." : "ERROR: " + result;
        } else {
            this.message = "Unable to run a sim game. The competition is already in progress.";
        }
    }

    public void runBoot() {
        if (!this.competitionControl.isRunning()) {
            this.visualizerService.init(this.visualizerProxy);
            String bootFilename = this.gameParamaters.getBootstrapFilename().equals("") ? null : this.gameParamaters.getBootstrapFilename();
            String serverConfig = this.gameParamaters.getServerConfig().equals("") ? null : this.gameParamaters.getServerConfig();
            String logSuffix = this.gameParamaters.getLogSuffix().equals("") ? null : this.gameParamaters.getLogSuffix();
            System.out.println(bootFilename + serverConfig + logSuffix);
            String result = this.css.bootSession(bootFilename, serverConfig, logSuffix);
            this.message = result == null ? "Bootstrap mode started." : "ERROR: " + result;
        } else {
            this.message = "Unable to run a bootstrap game. The competition is already in progress.";
        }
    }

    public void shutDown() {
        if (this.competitionControl.isRunning()) {
            this.competitionControl.shutDown();
            this.message = "Shut down is complete.";
        } else {
            this.message = "There is no running game to shut down.";
        }
    }

    public String getMessage() {
        return this.message;
    }
}

