/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services.competitioncontrol;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.powertac.common.interfaces.CompetitionControl;
import org.powertac.common.interfaces.CompetitionSetup;
import org.powertac.common.interfaces.VisualizerProxy;
import org.powertac.visualizer.services.VisualizerServiceEmbedded;
import org.powertac.visualizer.services.competitioncontrol.FakeBroker;
import org.powertac.visualizer.services.competitioncontrol.GameParametersBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebCompetitionControlService {
    private static Logger log = Logger.getLogger(WebCompetitionControlService.class);
    @Autowired
    private CompetitionSetup css;
    @Autowired
    private CompetitionControl competitionControl;
    @Autowired
    private VisualizerServiceEmbedded visualizerService;
    @Autowired
    private GameParametersBean gameParameters;
    @Autowired
    private VisualizerProxy visualizerProxy;
    private Boolean tournamentMode = false;
    private String message;

    public void runSim() {
        if (this.tournamentMode.booleanValue()) {
            this.message = "Unable to run sim in tournament configuration.";
            return;
        }
        if (this.competitionControl.isRunning()) {
            this.message = "Unable to run a sim game. The competition is already in progress.";
            return;
        }
        this.visualizerService.init(this.visualizerProxy);
        ArrayList<String> names = new ArrayList<String>();
        for (FakeBroker type : this.gameParameters.getBrokers()) {
            names.add(type.getName());
        }
        String boot = this.gameParameters.getBootstrapData().trim().equals("") ? null : this.gameParameters.getBootstrapData();
        String serverConfig = this.gameParameters.getServerConfig().trim().equals("") ? null : this.gameParameters.getServerConfig();
        String jmsUrl = this.gameParameters.getJmsUrl().trim().equals("") ? null : this.gameParameters.getJmsUrl();
        String logSuffix = this.gameParameters.getLogSuffix().trim().equals("") ? null : this.gameParameters.getLogSuffix();
        String result = this.css.simSession(boot, serverConfig, jmsUrl, logSuffix, names);
        this.message = result == null ? "Simulation started." : "ERROR: " + result;
    }

    public void runBoot() {
        if (this.tournamentMode.booleanValue()) {
            this.message = "Unable to run boot in tournament configuration.";
            return;
        }
        if (this.competitionControl.isRunning()) {
            this.message = "Unable to run a bootstrap game. The competition is already in progress.";
            return;
        }
        this.visualizerService.init(this.visualizerProxy);
        String bootFilename = this.gameParameters.getBootstrapFilename().trim().equals("") ? null : this.gameParameters.getBootstrapFilename();
        String serverConfig = this.gameParameters.getServerConfig().trim().equals("") ? null : this.gameParameters.getServerConfig();
        String logSuffix = this.gameParameters.getLogSuffix().trim().equals("") ? null : this.gameParameters.getLogSuffix();
        String result = this.css.bootSession(bootFilename, serverConfig, logSuffix);
        this.message = result == null ? "Bootstrap mode started." : "ERROR: " + result;
    }

    public void shutDown() {
        if (this.tournamentMode.booleanValue()) {
            this.message = "Not allowed in tournament configuration";
        } else if (this.competitionControl.isRunning()) {
            this.competitionControl.shutDown();
            this.message = "Shut down is complete.";
        } else {
            this.message = "There is no running game to shut down.";
        }
    }

    public String getMessage() {
        return this.message;
    }

    public Boolean getTournamentMode() {
        return this.tournamentMode;
    }

    public void setTournamentMode(Boolean tournamentMode) {
        this.tournamentMode = tournamentMode;
    }
}

