/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.BalancingTransaction;
import org.powertac.common.CashPosition;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.DistributionTransaction;
import org.powertac.common.Rate;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffTransaction;
import org.powertac.common.msg.TariffExpire;
import org.powertac.common.msg.TariffRevoke;
import org.powertac.common.msg.TariffStatus;
import org.powertac.common.msg.TariffUpdate;
import org.powertac.visualizer.MessageDispatcher;
import org.powertac.visualizer.beans.AppearanceListBean;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.domain.broker.CustomerModel;
import org.powertac.visualizer.domain.broker.TariffInfo;
import org.powertac.visualizer.interfaces.Initializable;
import org.powertac.visualizer.services.BrokerService;
import org.primefaces.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BrokerMessageHandler
implements Initializable {
    private Logger log = Logger.getLogger(BrokerMessageHandler.class);
    @Autowired
    private MessageDispatcher router;
    @Autowired
    private BrokerService brokerService;
    @Autowired
    private AppearanceListBean appearanceListBean;

    public void initialize() {
        for (Class clazz : Arrays.asList(Competition.class, TariffSpecification.class, CashPosition.class, TariffTransaction.class, DistributionTransaction.class, BalancingTransaction.class, TariffExpire.class, TariffRevoke.class, TariffStatus.class, TariffUpdate.class)) {
            this.router.registerMessageHandler((Object)this, clazz);
        }
    }

    public void handleMessage(Competition competition) {
        List brokersName = competition.getBrokers();
        HashMap<String, BrokerModel> map = new HashMap<String, BrokerModel>();
        ArrayList<BrokerModel> list = new ArrayList<BrokerModel>();
        JSONArray brokerSeriesColors = new JSONArray();
        JSONArray seriesOptions = new JSONArray();
        for (String name : brokersName) {
            BrokerModel brokerModel = new BrokerModel(name, this.appearanceListBean.getAppereance());
            seriesOptions.put((Object)brokerModel.getJson().getSeriesOptions());
            brokerSeriesColors.put((Object)brokerModel.getAppearance().getColorCode());
            HashSet<CustomerModel> customerModels = new HashSet<CustomerModel>();
            for (CustomerInfo customerInfo : competition.getCustomers()) {
                customerModels.add(new CustomerModel(customerInfo));
            }
            brokerModel.setCustomerModels(customerModels);
            map.put(brokerModel.getName(), brokerModel);
            list.add(brokerModel);
        }
        this.brokerService.setMap(map);
        this.brokerService.setBrokers(list);
        this.brokerService.getJson().setBrokerSeriesColors(brokerSeriesColors);
        this.brokerService.getJson().setSeriesOptions(seriesOptions);
    }

    public void handleMessage(TariffSpecification tariffSpecification) {
        this.log.debug((Object)("\nBroker: " + tariffSpecification.getBroker().getUsername() + " Min duration: " + tariffSpecification.getMinDuration() + " EarlyWithdrPaymnt " + tariffSpecification.getEarlyWithdrawPayment() + " PeriodicPayment: " + tariffSpecification.getPeriodicPayment() + " SignupPayment" + tariffSpecification.getSignupPayment() + " Expiration: " + tariffSpecification.getExpiration() + " PowerType: " + tariffSpecification.getPowerType() + " ID: " + tariffSpecification.getId()));
        if (tariffSpecification.getSupersedes() != null) {
            this.log.debug((Object)("NO of tariffspec:" + tariffSpecification.getSupersedes().size()));
        }
        List rates = tariffSpecification.getRates();
        String ispis = "";
        for (Rate rate : rates) {
            ispis = ispis + "" + rate.toString();
        }
        this.log.debug((Object)("RATE:\n" + ispis));
        BrokerModel brokerModel = this.brokerService.findBrokerByName(tariffSpecification.getBroker().getUsername());
        if (brokerModel != null) {
            brokerModel.addTariffSpecification(tariffSpecification);
        }
    }

    public void handleMessage(CashPosition cashPosition) {
        this.log.debug((Object)("\nBalance: " + cashPosition.getBalance() + " for broker " + cashPosition.getBroker().getUsername()));
        BrokerModel broker = this.brokerService.findBrokerByName(cashPosition.getBroker().getUsername());
        if (broker != null) {
            broker.updateCashBalance(cashPosition.getBalance());
        }
    }

    public void handleMessage(TariffTransaction tariffTransaction) {
        this.log.debug((Object)("Broker: " + tariffTransaction.getBroker() + " Charge: " + tariffTransaction.getCharge() + " CustomerCount: " + tariffTransaction.getCustomerCount() + "\n KWh: " + tariffTransaction.getKWh() + " CustomerInfo: " + tariffTransaction.getCustomerInfo() + "Posted time: " + tariffTransaction.getPostedTime() + "\n TxType: " + tariffTransaction.getTxType()));
        BrokerModel brokerModel = this.brokerService.findBrokerByName(tariffTransaction.getBroker().getUsername());
        if (brokerModel != null) {
            brokerModel.addTariffTransaction(tariffTransaction);
        }
    }

    public void handleMessage(DistributionTransaction distributionTransaction) {
        BrokerModel brokerModel;
        this.log.debug((Object)("Broker: " + distributionTransaction.getBroker() + "\nCharge: " + distributionTransaction.getCharge() + "\nkWh: " + distributionTransaction.getKWh()));
        if (distributionTransaction.getKWh() == 0.0 && (brokerModel = this.brokerService.findBrokerByName(distributionTransaction.getBroker().getUsername())) != null) {
            brokerModel.updateEnergyBalance(0.0);
        }
    }

    public void handleMessage(BalancingTransaction balancingTransaction) {
        this.log.debug((Object)("Broker: " + balancingTransaction.getBroker() + "\nCharge: " + balancingTransaction.getCharge() + "\nkWh: " + balancingTransaction.getKWh() + "\n"));
        BrokerModel broker = this.brokerService.findBrokerByName(balancingTransaction.getBroker().getUsername());
        if (broker != null) {
            broker.addBalancingTransaction(balancingTransaction);
        }
    }

    public void handleMessage(TariffExpire msg) {
        BrokerModel broker = this.brokerService.findBrokerByName(msg.getBroker().getUsername());
        if (broker != null) {
            ((TariffInfo)broker.getTariffInfoMaps().get(msg.getTariffId())).addTariffMessage(msg.getClass().getSimpleName() + ":" + msg.getNewExpiration());
        }
    }

    public void handleMessage(TariffRevoke msg) {
        BrokerModel broker = this.brokerService.findBrokerByName(msg.getBroker().getUsername());
        if (broker != null) {
            ((TariffInfo)broker.getTariffInfoMaps().get(msg.getTariffId())).addTariffMessage(msg.getClass().getSimpleName());
        }
    }

    public void handleMessage(TariffStatus msg) {
    }

    public void handleMessage(TariffUpdate msg) {
        BrokerModel broker = this.brokerService.findBrokerByName(msg.getBroker().getUsername());
        if (broker != null) {
            ((TariffInfo)broker.getTariffInfoMaps().get(msg.getTariffId())).addTariffMessage(msg.getClass().getSimpleName());
        }
    }
}

