/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services.handlers;

import java.util.ArrayList;
import org.joda.time.Instant;
import org.powertac.visualizer.beans.VisualizerBean;
import org.powertac.visualizer.domain.DayOverview;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.domain.broker.DayState;
import org.powertac.visualizer.services.BrokerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualizerMessageHandlerHelperService {
    @Autowired
    private VisualizerBean visualizerBean;
    @Autowired
    private BrokerService brokerService;

    public int computeRelativeTimeslotIndex(Instant timeslot) {
        long millisDifference = timeslot.getMillis() - this.visualizerBean.getFirstTimeslotInstant().getMillis();
        long numberOfHours = millisDifference / 3600000L;
        return (int)numberOfHours;
    }

    public void buildDayOverview() {
        ArrayList<DayState> dayStates = new ArrayList<DayState>();
        for (BrokerModel broker : this.brokerService.getBrokerList()) {
            dayStates.add(broker.getDisplayableDayState());
        }
        int day = this.visualizerBean.getCurrentTimeslotSerialNumber() / 24;
        this.visualizerBean.setDayOverview(new DayOverview(dayStates, day));
    }
}

