/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.broker;

import com.google.gson.Gson;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.ConcurrentHashMap;
import org.powertac.common.CustomerInfo;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffTransaction;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.domain.broker.TariffCustomerStats;

public class TariffData {
    private BrokerModel broker;
    private TariffSpecification spec;
    private double profit;
    private double netKWh;
    private long customers;
    private String powerType;
    private String ratesGraph;
    Gson gson = new Gson();
    private ConcurrentHashMap<CustomerInfo, TariffCustomerStats> tariffCustomerStats;

    public TariffData(TariffSpecification spec, BrokerModel broker) {
        this.spec = spec;
        this.broker = broker;
        this.tariffCustomerStats = new ConcurrentHashMap(20, 0.75f, 1);
        this.powerType = spec.getPowerType().toString();
    }

    public double getNetKWh() {
        return Math.round(this.netKWh);
    }

    public long getCustomers() {
        return this.customers;
    }

    public double getProfit() {
        return Math.round(this.profit);
    }

    public BigDecimal getProfitInThousandsOfEuro() {
        return new BigDecimal(this.profit / 1000.0).setScale(2, RoundingMode.HALF_UP);
    }

    public TariffSpecification getSpec() {
        return this.spec;
    }

    public ConcurrentHashMap<CustomerInfo, TariffCustomerStats> getTariffCustomerStats() {
        return this.tariffCustomerStats;
    }

    public void processTariffTx(TariffTransaction tx) {
        this.profit += tx.getCharge();
        this.netKWh += tx.getKWh();
        if (tx.getCustomerInfo() != null) {
            this.tariffCustomerStats.putIfAbsent(tx.getCustomerInfo(), new TariffCustomerStats(tx.getCustomerInfo(), this.spec));
            ((TariffCustomerStats)this.tariffCustomerStats.get(tx.getCustomerInfo())).addAmounts(tx.getCharge(), tx.getKWh());
        }
    }

    public void setCustomers(long customers) {
        this.customers += customers;
    }

    public String getPowerType() {
        return this.powerType;
    }

    public BrokerModel getBroker() {
        return this.broker;
    }

    public BigDecimal getNetMWh() {
        return new BigDecimal(this.netKWh / 1000.0).setScale(2, RoundingMode.HALF_UP);
    }

    public String toString() {
        return this.tariffCustomerStats.toString();
    }

    public String getRatesGraph() {
        return this.ratesGraph;
    }
}

