/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.MarketTransaction;
import org.powertac.visualizer.beans.VisualizerBean;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.domain.broker.TariffDynamicData;
import org.powertac.visualizer.interfaces.Recyclable;
import org.powertac.visualizer.interfaces.TimeslotCompleteActivation;
import org.powertac.visualizer.push.DynDataPusher;
import org.powertac.visualizer.push.FinancePusher;
import org.powertac.visualizer.push.NominationCategoryPusher;
import org.powertac.visualizer.push.NominationPusher;
import org.powertac.visualizer.push.TariffMarketPusher;
import org.powertac.visualizer.push.WholesaleMarketPusher;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.powertac.visualizer.statistical.BalancingCategory;
import org.powertac.visualizer.statistical.DistributionCategory;
import org.powertac.visualizer.statistical.DynamicData;
import org.powertac.visualizer.statistical.FinanceCategory;
import org.powertac.visualizer.statistical.FinanceDynamicData;
import org.powertac.visualizer.statistical.TariffCategory;
import org.powertac.visualizer.statistical.WholesaleCategory;
import org.primefaces.push.PushContext;
import org.primefaces.push.PushContextFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BrokerService
implements TimeslotCompleteActivation,
Recyclable,
Serializable {
    private Logger log = Logger.getLogger(BrokerService.class);
    private static final long serialVersionUID = 15L;
    private ConcurrentHashMap<String, BrokerModel> brokersMap;
    private ArrayList<BrokerModel> brokers;
    @Autowired
    private VisualizerBean visualizerBean;
    @Autowired
    private VisualizerHelperService helper;
    private final int TIMESLOTS_TO_DISPLAY = 48;

    public BrokerService() {
        this.recycle();
    }

    public ConcurrentHashMap<String, BrokerModel> getBrokersMap() {
        return this.brokersMap;
    }

    public void setBrokers(ArrayList<BrokerModel> brokers) {
        this.brokers = brokers;
    }

    public void setBrokersMap(ConcurrentHashMap<String, BrokerModel> brokersMap) {
        this.brokersMap = brokersMap;
    }

    public BrokerModel findBrokerByName(String name) {
        return (BrokerModel)this.brokersMap.get(name);
    }

    public void recycle() {
        this.brokersMap = new ConcurrentHashMap();
        this.brokers = new ArrayList();
    }

    public void activate(int timeslotIndex, Instant postedTime) {
        PushContext pushContext = PushContextFactory.getDefault().getPushContext();
        Gson gson = new Gson();
        ArrayList<TariffMarketPusher> tariffMarketPushers = new ArrayList<TariffMarketPusher>();
        ArrayList<WholesaleMarketPusher> wholesaleMarketPushers = new ArrayList<WholesaleMarketPusher>();
        ArrayList<DynDataPusher> balancingMarketPushers = new ArrayList<DynDataPusher>();
        ArrayList<DynDataPusher> distributionPushers = new ArrayList<DynDataPusher>();
        ArrayList<FinancePusher> financePushers = new ArrayList<FinancePusher>();
        ArrayList allWholesaleData = new ArrayList();
        ArrayList brokersOverview = new ArrayList();
        NominationPusher np = null;
        for (BrokerModel b : this.brokers) {
            ArrayList wholesaleTxBrokerData = new ArrayList();
            ArrayList<Double> brokerOverview = new ArrayList<Double>();
            TariffCategory tc = b.getTariffCategory();
            TariffDynamicData tdd = tc.getLastTariffDynamicData();
            TariffMarketPusher tp = new TariffMarketPusher(b.getName(), this.helper.getMillisForIndex(tdd.getDynamicData().getTsIndex()), tdd.getDynamicData().getProfit(), tdd.getDynamicData().getEnergy(), tdd.getCustomerCount(), tdd.getDynamicData().getProfitDelta(), tdd.getDynamicData().getEnergyDelta(), tdd.getCustomerCountDelta());
            tariffMarketPushers.add(tp);
            int safetyTxIndex = timeslotIndex - 1;
            WholesaleCategory wc = b.getWholesaleCategory();
            wc.updateAccounts(safetyTxIndex);
            ConcurrentHashMap mtxMap = wc.getMarketTxs();
            NavigableSet<Integer> mtxSortedSet = new TreeSet<Integer>(wc.getMarketTxs().keySet()).headSet(safetyTxIndex, true);
            SortedSet<Integer> mtxSortedSetSubset = mtxSortedSet.subSet(safetyTxIndex - 48 < 0 ? 0 : safetyTxIndex - 48, safetyTxIndex);
            Iterator iterator2 = mtxSortedSetSubset.iterator();
            while (iterator2.hasNext()) {
                int key = (Integer)iterator2.next();
                List mtxList = (List)mtxMap.get(key);
                for (MarketTransaction marketTransaction : mtxList) {
                    ArrayList<Double> transaction = new ArrayList<Double>();
                    transaction.add(marketTransaction.getPrice());
                    transaction.add(marketTransaction.getMWh());
                    wholesaleTxBrokerData.add(transaction);
                }
            }
            allWholesaleData.add(wholesaleTxBrokerData);
            double profitDelta = 0.0;
            double profit = 0.0;
            double energy = 0.0;
            double energyDelta = 0.0;
            NavigableSet<Integer> safeKeys = new TreeSet<Integer>(wc.getDynamicDataMap().keySet()).headSet(safetyTxIndex, true);
            if (!safeKeys.isEmpty()) {
                DynamicData lastWholesaledd = (DynamicData)wc.getDynamicDataMap().get(safeKeys.last());
                profitDelta = lastWholesaledd.getProfitDelta();
                energyDelta = lastWholesaledd.getEnergyDelta();
                profit = lastWholesaledd.getProfit();
                energy = lastWholesaledd.getEnergy();
            }
            WholesaleMarketPusher wmp = new WholesaleMarketPusher(b.getName(), this.helper.getMillisForIndex(safetyTxIndex), profitDelta, energyDelta, profit, energy);
            wholesaleMarketPushers.add(wmp);
            BalancingCategory bc = b.getBalancingCategory();
            DynamicData bdd = bc.getLastDynamicData();
            DynDataPusher bddp = new DynDataPusher(b.getName(), this.helper.getMillisForIndex(bdd.getTsIndex()), bdd.getProfit(), bdd.getEnergy(), bdd.getProfitDelta(), bdd.getEnergyDelta());
            balancingMarketPushers.add(bddp);
            DistributionCategory dc = b.getDistributionCategory();
            DynamicData ddd = dc.getLastDynamicData();
            DynDataPusher dddp = new DynDataPusher(b.getName(), this.helper.getMillisForIndex(ddd.getTsIndex()), ddd.getProfit(), ddd.getEnergy(), ddd.getProfitDelta(), ddd.getEnergyDelta());
            distributionPushers.add(dddp);
            FinanceCategory fc = b.getFinanceCategory();
            FinanceDynamicData fdd = fc.getLastFinanceDynamicData();
            FinancePusher fp = new FinancePusher(b.getName(), this.helper.getMillisForIndex(fdd.getTsIndex()), fdd.getProfit(), fdd.getProfitDelta());
            financePushers.add(fp);
            brokerOverview.add(fdd.getProfit());
            brokerOverview.add(tdd.getDynamicData().getProfit());
            brokerOverview.add(profit);
            brokerOverview.add(bdd.getProfit());
            brokerOverview.add(ddd.getProfit());
            brokersOverview.add(brokerOverview);
            if (np == null) {
                np = new NominationPusher(new NominationCategoryPusher(b.getName(), (long)fc.getProfit()), new NominationCategoryPusher(b.getName(), (long)Math.abs(bc.getEnergy())), new NominationCategoryPusher(b.getName(), (long)tc.getCustomerCount()));
                continue;
            }
            long profitAmount = (long)fc.getProfit();
            long balanceAmount = (long)Math.abs(bc.getEnergy());
            long customerAmount = tc.getCustomerCount();
            if (profitAmount > np.getProfit().getAmount()) {
                np.setProfit(new NominationCategoryPusher(b.getName(), profitAmount));
            }
            if (balanceAmount < Math.abs(np.getBalance().getAmount())) {
                np.setBalance(new NominationCategoryPusher(b.getName(), balanceAmount));
            }
            if (customerAmount <= np.getCustomerNumber().getAmount()) continue;
            np.setCustomerNumber(new NominationCategoryPusher(b.getName(), customerAmount));
        }
        if (np != null) {
            this.visualizerBean.setNominationPusher(np);
        }
        pushContext.push("/tariffpush", (Object)gson.toJson(tariffMarketPushers));
        pushContext.push("/wholesalemarketpush", (Object)gson.toJson(wholesaleMarketPushers));
        pushContext.push("/balancingmarketpush", (Object)gson.toJson(balancingMarketPushers));
        pushContext.push("/distributionpush", (Object)gson.toJson(distributionPushers));
        pushContext.push("/financepush", (Object)gson.toJson(financePushers));
        pushContext.push("/markettransactionepush", (Object)gson.toJson(allWholesaleData));
        pushContext.push("/gameoverview", (Object)gson.toJson(brokersOverview));
    }

    public ArrayList<BrokerModel> getBrokers() {
        return this.brokers;
    }
}

