/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.statistical;

import java.util.concurrent.ConcurrentHashMap;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.statistical.DynamicData;

public abstract class AbstractPerformanceCategory {
    private BrokerModel broker;
    double grade = 0.0;
    double energy;
    double profit;
    DynamicData lastDynamicData = new DynamicData(0, 0.0, 0.0);
    private ConcurrentHashMap<Integer, DynamicData> dynamicDataMap = new ConcurrentHashMap(1500, 0.75f, 1);

    public AbstractPerformanceCategory() {
        this.dynamicDataMap.put(0, this.lastDynamicData);
    }

    public ConcurrentHashMap<Integer, DynamicData> getDynamicDataMap() {
        return this.dynamicDataMap;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getProfit() {
        return this.profit;
    }

    public void update(int tsIndex, double energy, double cash) {
        if (!this.dynamicDataMap.containsKey(tsIndex)) {
            this.lastDynamicData = new DynamicData(tsIndex, this.energy, this.profit);
            this.dynamicDataMap.put(tsIndex, this.lastDynamicData);
        }
        ((DynamicData)this.dynamicDataMap.get(tsIndex)).update(energy, cash);
        this.energy += energy;
        this.profit += cash;
    }

    public AbstractPerformanceCategory(BrokerModel broker) {
        this.broker = broker;
    }

    public double getGrade() {
        return this.grade;
    }

    public void setGrade(double d) {
        this.grade = d;
    }

    public BrokerModel getBroker() {
        return this.broker;
    }

    public DynamicData getLastDynamicData() {
        return this.lastDynamicData;
    }

    public void setLastDynamicData(DynamicData lastDynamicData) {
        this.lastDynamicData = lastDynamicData;
    }
}

