/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.statistical;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.TariffSpecification;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.domain.broker.CustomerTariffData;
import org.powertac.visualizer.domain.broker.TariffData;
import org.powertac.visualizer.domain.broker.TariffDynamicData;
import org.powertac.visualizer.statistical.AbstractPerformanceCategory;
import org.powertac.visualizer.statistical.PerformanceCategory;

public class TariffCategory
extends AbstractPerformanceCategory
implements PerformanceCategory {
    private int customerCount;
    private TariffDynamicData lastTariffDynamicData;
    private Logger log = Logger.getLogger(TariffCategory.class);
    private ConcurrentHashMap<Integer, TariffDynamicData> tariffDynamicDataMap;
    private ConcurrentHashMap<CustomerInfo, CustomerTariffData> customerTariffData;
    private ConcurrentHashMap<TariffSpecification, TariffData> tariffData;

    public TariffCategory(BrokerModel broker) {
        super(broker);
        this.lastTariffDynamicData = new TariffDynamicData(0, 0.0, 0.0, 0);
        this.tariffDynamicDataMap = new ConcurrentHashMap(1000, 0.75f, 1);
        this.customerTariffData = new ConcurrentHashMap(20, 0.75f, 1);
        this.tariffData = new ConcurrentHashMap(20, 0.75f, 1);
    }

    public void processTariffSpecification(TariffSpecification ts) {
        this.tariffData.putIfAbsent(ts, new TariffData(ts, this.getBroker()));
    }

    public int getCustomerCount() {
        return this.customerCount;
    }

    public ConcurrentHashMap<Integer, TariffDynamicData> getTariffDynamicDataMap() {
        return this.tariffDynamicDataMap;
    }

    public ConcurrentHashMap<CustomerInfo, CustomerTariffData> getCustomerTariffData() {
        return this.customerTariffData;
    }

    public ConcurrentHashMap<TariffSpecification, TariffData> getTariffData() {
        return this.tariffData;
    }

    public void update(int tsIndex, double energy, double cash, int customerDelta) {
        this.customerCount += customerDelta;
        ((TariffDynamicData)this.tariffDynamicDataMap.get(tsIndex)).update(cash, energy, customerDelta);
        this.update(tsIndex, energy, cash);
    }

    public void addTariffDynamicData(TariffDynamicData tdd) {
        this.lastTariffDynamicData = tdd;
        this.tariffDynamicDataMap.put(tdd.getDynamicData().getTsIndex(), tdd);
    }

    public TariffDynamicData getLastTariffDynamicData() {
        return this.lastTariffDynamicData;
    }
}

