/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.user;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.powertac.visualizer.display.GameOverviewTemplate;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.services.BrokerService;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.powertac.visualizer.statistical.DynamicData;
import org.springframework.beans.factory.annotation.Autowired;

public class GameOverviewBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String gameOverview;

    @Autowired
    public GameOverviewBean(BrokerService brokerService, VisualizerHelperService helper) {
        Gson gson = new Gson();
        this.createMostRecentOverview(gson, brokerService, helper);
    }

    private void createMostRecentOverview(Gson gson, BrokerService brokerService, VisualizerHelperService helper) {
        ArrayList brokers = brokerService.getBrokers();
        ArrayList<GameOverviewTemplate> allBrokersData = new ArrayList<GameOverviewTemplate>();
        Iterator iterator = brokers.iterator();
        while (iterator.hasNext()) {
            ArrayList<Double> data = new ArrayList<Double>();
            BrokerModel brokerModel = (BrokerModel)iterator.next();
            data.add(brokerModel.getFinanceCategory().getLastFinanceDynamicData().getProfit());
            data.add(brokerModel.getTariffCategory().getLastTariffDynamicData().getDynamicData().getProfit());
            NavigableSet<Integer> safeKeys = new TreeSet<Integer>(brokerModel.getWholesaleCategory().getDynamicDataMap().keySet()).headSet(helper.getSafetyWholesaleTimeslotIndex(), true);
            if (!safeKeys.isEmpty()) {
                DynamicData lastWholesaledd = (DynamicData)brokerModel.getWholesaleCategory().getDynamicDataMap().get(safeKeys.last());
                double profit = lastWholesaledd.getProfit();
                data.add(profit);
            }
            data.add(brokerModel.getBalancingCategory().getLastDynamicData().getProfit());
            data.add(brokerModel.getDistributionCategory().getLastDynamicData().getProfit());
            allBrokersData.add(new GameOverviewTemplate(brokerModel.getName(), data));
        }
        this.gameOverview = gson.toJson(allBrokersData);
    }

    public String getGameOverview() {
        return this.gameOverview;
    }
}

