/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.user;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.powertac.common.ClearedTrade;
import org.powertac.common.MarketTransaction;
import org.powertac.visualizer.display.BrokerSeriesTemplate;
import org.powertac.visualizer.display.WholesaleAnalysisTemplate;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.services.BrokerService;
import org.powertac.visualizer.services.WholesaleService;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.powertac.visualizer.statistical.DynamicData;
import org.springframework.beans.factory.annotation.Autowired;

public class WholesaleMarketBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(WholesaleMarketBean.class);
    private String energyMostRecentClearingsJson;
    private String cashMostRecentClearingsJson;
    private String clearedTradesDataJson;
    private String allMarketTransactionsData;
    private String wholesaleDynData;
    private String wholesaleDynDataOneTimeslot;
    private String wholesaleAverageTimeslotPriceData;
    private final int TIMESLOTS_TO_DISPLAY = 48;

    @Autowired
    public WholesaleMarketBean(BrokerService brokerService, WholesaleService wholesaleService, VisualizerHelperService helper) {
        Gson gson = new Gson();
        this.createMostRecentClearings(gson, wholesaleService, helper);
        this.createAllClearings(gson, wholesaleService, helper);
        this.createBrokerWholesaleTransactions(gson, brokerService, helper);
    }

    private void createBrokerWholesaleTransactions(Gson gson, BrokerService brokerService, VisualizerHelperService helper) {
        ArrayList brokers = brokerService.getBrokers();
        int safetyTsIndex = helper.getSafetyWholesaleTimeslotIndex();
        ArrayList<BrokerSeriesTemplate> allWholesaleData = new ArrayList<BrokerSeriesTemplate>();
        ArrayList<BrokerSeriesTemplate> wholesaleTxData = new ArrayList<BrokerSeriesTemplate>();
        ArrayList<BrokerSeriesTemplate> wholesaleTxDataOneTimeslot = new ArrayList<BrokerSeriesTemplate>();
        for (BrokerModel brokerModel : brokers) {
            ArrayList<Object[]> profitData = new ArrayList<Object[]>();
            ArrayList<Object[]> netMwhData = new ArrayList<Object[]>();
            ArrayList<Object[]> profitDataOneTimeslot = new ArrayList<Object[]>();
            ArrayList<Object[]> mwhDataOneTimeslot = new ArrayList<Object[]>();
            ArrayList<Object[]> wholesaleTxBrokerData = new ArrayList<Object[]>();
            ConcurrentHashMap dynDataMap = brokerModel.getWholesaleCategory().getDynamicDataMap();
            NavigableSet<Integer> dynDataSet = new TreeSet<Integer>(brokerModel.getWholesaleCategory().getDynamicDataMap().keySet()).headSet(safetyTsIndex, true);
            double totalProfit = 0.0;
            double totalEnergy = 0.0;
            Iterator iterator2 = dynDataSet.iterator();
            while (iterator2.hasNext()) {
                int key = (Integer)iterator2.next();
                DynamicData dynData = (DynamicData)dynDataMap.get(key);
                Object[] profit = new Object[]{helper.getMillisForIndex(key), totalProfit += dynData.getProfitDelta()};
                Object[] netMwh = new Object[]{helper.getMillisForIndex(key), totalEnergy += dynData.getEnergyDelta()};
                profitData.add(profit);
                netMwhData.add(netMwh);
                Object[] profitOneTimeslot = new Object[]{helper.getMillisForIndex(key), dynData.getProfitDelta()};
                Object[] kWhOneTimeslot = new Object[]{helper.getMillisForIndex(key), dynData.getEnergyDelta()};
                profitDataOneTimeslot.add(profitOneTimeslot);
                mwhDataOneTimeslot.add(kWhOneTimeslot);
            }
            if (dynDataSet.size() == 0) {
                Object[] dummy = new Object[]{helper.getMillisForIndex(0), 0};
                profitData.add(dummy);
                netMwhData.add(dummy);
                profitDataOneTimeslot.add(dummy);
                mwhDataOneTimeslot.add(dummy);
            }
            ConcurrentHashMap mtxMap = brokerModel.getWholesaleCategory().getMarketTxs();
            NavigableSet<Integer> mtxSortedSet = new TreeSet<Integer>(brokerModel.getWholesaleCategory().getMarketTxs().keySet()).headSet(safetyTsIndex, true);
            SortedSet<Integer> mtxSortedSetSubset = mtxSortedSet.subSet(safetyTsIndex - 48 < 0 ? 0 : safetyTsIndex - 48, safetyTsIndex);
            Iterator iterator22 = mtxSortedSetSubset.iterator();
            while (iterator22.hasNext()) {
                int key = (Integer)iterator22.next();
                List mtxList = (List)mtxMap.get(key);
                for (MarketTransaction marketTransaction : mtxList) {
                    Object[] mtxEntry = new Object[]{marketTransaction.getPrice(), marketTransaction.getMWh()};
                    wholesaleTxBrokerData.add(mtxEntry);
                }
            }
            wholesaleTxData.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 0, profitData, true));
            wholesaleTxData.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 1, netMwhData, false));
            wholesaleTxDataOneTimeslot.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 0, profitDataOneTimeslot, true));
            wholesaleTxDataOneTimeslot.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 1, mwhDataOneTimeslot, false));
            allWholesaleData.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCodeRGBShading(), wholesaleTxBrokerData, true));
        }
        this.wholesaleDynData = gson.toJson(wholesaleTxData);
        this.wholesaleDynDataOneTimeslot = gson.toJson(wholesaleTxDataOneTimeslot);
        this.allMarketTransactionsData = gson.toJson(allWholesaleData);
    }

    private void createAllClearings(Gson gson, WholesaleService wholesaleService, VisualizerHelperService helper) {
        ArrayList<Object[]> allClearedTrades = new ArrayList<Object[]>();
        ArrayList<Object[]> totalDataOneTimeslot = new ArrayList<Object[]>();
        ArrayList<WholesaleAnalysisTemplate> averageProfitPerTimeslot = new ArrayList<WholesaleAnalysisTemplate>();
        Collection allTrades = wholesaleService.getClearedTrades().values();
        ConcurrentHashMap<Long, Double> totalPriceInTimeslot = new ConcurrentHashMap<Long, Double>();
        ConcurrentHashMap<Long, Integer> numberOfTransactions = new ConcurrentHashMap<Long, Integer>();
        ConcurrentHashMap<Long, Double> totalEnergyInTimeslot = new ConcurrentHashMap<Long, Double>();
        for (ConcurrentHashMap concurrentHashMap : allTrades) {
            Collection trades = concurrentHashMap.values();
            for (ClearedTrade ct : trades) {
                Object[] entry = new Object[]{ct.getExecutionMWh(), ct.getExecutionPrice()};
                allClearedTrades.add(entry);
                if (!totalPriceInTimeslot.containsKey(helper.getMillisForIndex(ct.getTimeslotIndex()))) {
                    totalPriceInTimeslot.put(helper.getMillisForIndex(ct.getTimeslotIndex()), ct.getExecutionPrice());
                    totalEnergyInTimeslot.put(helper.getMillisForIndex(ct.getTimeslotIndex()), ct.getExecutionMWh());
                    numberOfTransactions.put(helper.getMillisForIndex(ct.getTimeslotIndex()), 1);
                    continue;
                }
                totalPriceInTimeslot.put(helper.getMillisForIndex(ct.getTimeslotIndex()), (Double)totalPriceInTimeslot.get(helper.getMillisForIndex(ct.getTimeslotIndex())) + ct.getExecutionPrice());
                totalEnergyInTimeslot.put(helper.getMillisForIndex(ct.getTimeslotIndex()), (Double)totalEnergyInTimeslot.get(helper.getMillisForIndex(ct.getTimeslotIndex())) + ct.getExecutionMWh());
                numberOfTransactions.put(helper.getMillisForIndex(ct.getTimeslotIndex()), (Integer)numberOfTransactions.get(helper.getMillisForIndex(ct.getTimeslotIndex())) + 1);
            }
        }
        NavigableSet<Long> sortedSet = new TreeSet<Long>(totalPriceInTimeslot.keySet()).headSet(helper.getMillisForIndex(helper.getSafetyWholesaleTimeslotIndex()), true);
        for (Long timeslot : sortedSet) {
            Double totalProfitTimeslot = (Double)totalPriceInTimeslot.get(timeslot);
            Object[] totalProfitOneTimeslot = new Object[]{timeslot, totalProfitTimeslot / (double)((Integer)numberOfTransactions.get(timeslot)).intValue(), totalEnergyInTimeslot.get(timeslot)};
            totalDataOneTimeslot.add(totalProfitOneTimeslot);
        }
        averageProfitPerTimeslot.add(new WholesaleAnalysisTemplate(totalDataOneTimeslot));
        this.clearedTradesDataJson = gson.toJson(allClearedTrades);
        this.wholesaleAverageTimeslotPriceData = gson.toJson(averageProfitPerTimeslot);
    }

    private void createMostRecentClearings(Gson gson, WholesaleService wholesaleService, VisualizerHelperService helper) {
        ArrayList<Object[]> energyMostRecentClearings = new ArrayList<Object[]>();
        ArrayList<Object[]> cashMostRecentClearings = new ArrayList<Object[]>();
        ConcurrentHashMap mapFinalTrades = wholesaleService.getClearedTrades();
        NavigableSet<Long> keys = new TreeSet<Long>(wholesaleService.getClearedTrades().keySet()).headSet(helper.getMillisForIndex(helper.getSafetyWholesaleTimeslotIndex()), true);
        for (Long key : keys) {
            ConcurrentHashMap clearedTrades = (ConcurrentHashMap)mapFinalTrades.get(key);
            if (clearedTrades == null) continue;
            Long lastKey = (Long)new TreeSet(clearedTrades.keySet()).last();
            ClearedTrade mostRecentClearing = (ClearedTrade)clearedTrades.get(lastKey);
            Object[] energy = new Object[]{key, mostRecentClearing.getExecutionMWh()};
            Object[] cash = new Object[]{key, mostRecentClearing.getExecutionPrice()};
            energyMostRecentClearings.add(energy);
            cashMostRecentClearings.add(cash);
        }
        this.energyMostRecentClearingsJson = gson.toJson(energyMostRecentClearings);
        this.cashMostRecentClearingsJson = gson.toJson(cashMostRecentClearings);
    }

    public String getCashMostRecentClearingsJson() {
        return this.cashMostRecentClearingsJson;
    }

    public String getEnergyMostRecentClearingsJson() {
        return this.energyMostRecentClearingsJson;
    }

    public String getClearedTradesDataJson() {
        return this.clearedTradesDataJson;
    }

    public String getAllMarketTransactionsData() {
        return this.allMarketTransactionsData;
    }

    public String getWholesaleDynData() {
        return this.wholesaleDynData;
    }

    public String getWholesaleDynDataOneTimeslot() {
        return this.wholesaleDynDataOneTimeslot;
    }

    public String getWholesaleAverageTimeslotPriceData() {
        return this.wholesaleAverageTimeslotPriceData;
    }
}

