/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services;

import com.google.gson.Gson;
import java.util.ArrayList;
import org.powertac.common.TariffTransaction;
import org.powertac.visualizer.display.BrokerSeriesTemplate;
import org.powertac.visualizer.domain.customer.Customer;
import org.powertac.visualizer.services.CustomerService;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.primefaces.event.TabChangeEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerModelService {
    @Autowired
    VisualizerHelperService helper;
    @Autowired
    CustomerService customerService;
    private ArrayList<Customer> customers;
    private String wholesaleDynDataOneTimeslot;
    private int customerType = 0;

    public ArrayList<Customer> getCustomers() {
        return this.customers;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public String getWholesaleDynDataOneTimeslot() {
        Gson gson = new Gson();
        ArrayList<BrokerSeriesTemplate> wholesaleTxDataOneTimeslot = new ArrayList<BrokerSeriesTemplate>();
        ArrayList<Object[]> profitDataOneTimeslot = new ArrayList<Object[]>();
        ArrayList<Object[]> mwhDataOneTimeslot = new ArrayList<Object[]>();
        for (TariffTransaction tx : ((Customer)this.customerService.getCustomerList().get(this.customerType)).getCustomerModel().getTariffTransactions()) {
            if (tx.getTxType() != TariffTransaction.Type.CONSUME && tx.getTxType() != TariffTransaction.Type.PRODUCE) continue;
            Object[] profitOneTimeslot = new Object[]{this.helper.getMillisForIndex(tx.getPostedTimeslotIndex()), tx.getCharge()};
            Object[] kWhOneTimeslot = new Object[]{this.helper.getMillisForIndex(tx.getPostedTimeslotIndex()), tx.getKWh()};
            profitDataOneTimeslot.add(profitOneTimeslot);
            mwhDataOneTimeslot.add(kWhOneTimeslot);
        }
        wholesaleTxDataOneTimeslot.add(new BrokerSeriesTemplate("Price(\u20ac)", "#808080", 0, profitDataOneTimeslot, true));
        wholesaleTxDataOneTimeslot.add(new BrokerSeriesTemplate("Energy(MWh)", "#8BBC21", 1, mwhDataOneTimeslot, true));
        this.wholesaleDynDataOneTimeslot = gson.toJson(wholesaleTxDataOneTimeslot);
        return gson.toJson(wholesaleTxDataOneTimeslot);
    }

    public void onChange(TabChangeEvent event) {
        int j = 0;
        for (int i = 0; i < this.customerService.getCustomerList().size() && !((Customer)this.customerService.getCustomerList().get(i)).getCustomerInfo().getName().equals(event.getData().toString()); ++i) {
            ++j;
        }
        this.customerType = j;
    }
}

