/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.visualizer.domain.genco.Genco;
import org.powertac.visualizer.interfaces.Recyclable;
import org.powertac.visualizer.interfaces.TimeslotCompleteActivation;
import org.springframework.stereotype.Service;

@Service
public class GencoService
implements TimeslotCompleteActivation,
Recyclable {
    private static Logger log = Logger.getLogger(GencoService.class);
    private HashMap<String, Genco> gencoMap;

    public GencoService() {
        this.recycle();
    }

    public Genco addGenco(Broker broker) {
        Genco genco = new Genco(broker);
        this.gencoMap.put(genco.getBroker().getUsername(), genco);
        log.info((Object)(genco.toString() + " added."));
        return genco;
    }

    public Genco findGencoByUsername(String username) {
        return (Genco)this.gencoMap.get(username);
    }

    public List<Genco> getGencoList() {
        return (List)this.gencoMap.values();
    }

    public void activate(int timeslotIndex, Instant postedTime) {
        for (Genco genco : this.gencoMap.values()) {
            genco.update(timeslotIndex, postedTime);
        }
    }

    public void recycle() {
        this.gencoMap = new HashMap();
    }
}

