/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.genco;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.CashPosition;
import org.powertac.common.Timeslot;
import org.powertac.visualizer.domain.genco.WholesaleDataGenco;
import org.powertac.visualizer.interfaces.TimeslotModelUpdate;
import org.powertac.visualizer.json.GencoJSON;
import org.primefaces.json.JSONArray;
import org.primefaces.json.JSONException;

public class Genco
implements TimeslotModelUpdate {
    private static Logger log = Logger.getLogger(Genco.class);
    private Broker broker;
    private double cash;
    private GencoJSON json;
    private String id;
    private Map<Integer, WholesaleDataGenco> wholesaleDatas;

    public Genco(Broker broker) {
        this.broker = broker;
        this.id = "genco" + RandomStringUtils.random((int)7, (char[])"abcdefghijklomnopqrstuvxy".toCharArray());
        this.wholesaleDatas = new ConcurrentSkipListMap();
        this.json = new GencoJSON();
        log.info((Object)(this.toString() + " created."));
    }

    public WholesaleDataGenco findWholesaleDataByTimeslot(Timeslot timeslot) {
        int serialNumber = timeslot.getSerialNumber();
        WholesaleDataGenco data = (WholesaleDataGenco)this.wholesaleDatas.get(serialNumber);
        if (data == null) {
            data = new WholesaleDataGenco(timeslot);
            this.wholesaleDatas.put(serialNumber, data);
        }
        return data;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public void addCashPosition(CashPosition position) {
        this.cash = position.getBalance();
    }

    public double getCash() {
        return this.cash;
    }

    public void update(int timeslotIndex, Instant postedTime) {
        try {
            JSONArray cashPoint = new JSONArray();
            cashPoint.put(timeslotIndex).put(this.cash);
            this.json.getCashPositions().put((Object)cashPoint);
        }
        catch (JSONException e) {
            log.warn((Object)"JSON update for Genco is not working.");
        }
    }

    public ArrayList<WholesaleDataGenco> getWholesaleDatasList() {
        return new ArrayList<WholesaleDataGenco>(this.wholesaleDatas.values());
    }

    public GencoJSON getJson() {
        return this.json;
    }

    public String toString() {
        return "Genco : " + this.broker.getUsername() + ", apiKey : " + this.broker.getKey();
    }

    public String getId() {
        return this.id;
    }
}

