/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.statistical;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.powertac.common.MarketTransaction;
import org.powertac.common.Order;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.statistical.AbstractPerformanceCategory;
import org.powertac.visualizer.statistical.DynamicData;

public class WholesaleCategory
extends AbstractPerformanceCategory {
    private double totalEnergyBought;
    private double totalEnergySold;
    private double totalCostFromBuying;
    private double totalRevenueFromSelling;
    private ConcurrentHashMap<Integer, List<MarketTransaction>> marketTxs = new ConcurrentHashMap(24, 0.75f, 1);
    private ConcurrentHashMap<Integer, List<Order>> orders = new ConcurrentHashMap(24, 0.75f, 1);

    public WholesaleCategory(BrokerModel broker) {
        super(broker);
    }

    public ConcurrentHashMap<Integer, List<MarketTransaction>> getMarketTxs() {
        return this.marketTxs;
    }

    public ConcurrentHashMap<Integer, List<Order>> getOrders() {
        return this.orders;
    }

    public void update(int tsIndex, double energy, double cash) {
        if (!this.getDynamicDataMap().containsKey(tsIndex)) {
            this.setLastDynamicData(new DynamicData(tsIndex, 0.0, 0.0));
            this.getDynamicDataMap().put(tsIndex, this.getLastDynamicData());
        }
        ((DynamicData)this.getDynamicDataMap().get(tsIndex)).update(energy, cash);
    }

    public void updateAccounts(int tsIndex) {
        if (this.getDynamicDataMap().containsKey(tsIndex)) {
            ((DynamicData)this.getDynamicDataMap().get(tsIndex)).setProfit(this.profit);
            ((DynamicData)this.getDynamicDataMap().get(tsIndex)).setEnergy(this.energy);
            this.profit += ((DynamicData)this.getDynamicDataMap().get(tsIndex)).getProfitDelta();
            this.energy += ((DynamicData)this.getDynamicDataMap().get(tsIndex)).getEnergyDelta();
        }
    }

    public double getTotalEnergyBought() {
        return this.totalEnergyBought;
    }

    public void addEnergyBought(double energy) {
        this.totalEnergyBought += energy;
    }

    public double getTotalEnergySold() {
        return this.totalEnergySold;
    }

    public void addEnergySold(double energy) {
        this.totalEnergySold += energy;
    }

    public double getTotalCostFromBuying() {
        return this.totalCostFromBuying;
    }

    public void addCostFromBuying(double cost) {
        this.totalCostFromBuying += cost;
    }

    public double getTotalRevenueFromSelling() {
        return this.totalRevenueFromSelling;
    }

    public void addRevenueFromSelling(double revenue) {
        this.totalRevenueFromSelling += revenue;
    }
}

