/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.user;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.powertac.visualizer.display.BrokerSeriesTemplate;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.services.BrokerService;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.powertac.visualizer.statistical.DynamicData;
import org.springframework.beans.factory.annotation.Autowired;

public class DistributionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String distributionDynData;
    private String distributionDynDataOneTimeslot;

    @Autowired
    public DistributionBean(BrokerService brokerService, VisualizerHelperService helper) {
        Gson gson = new Gson();
        this.createBrokerDistributionTransactions(gson, brokerService, helper);
    }

    private void createBrokerDistributionTransactions(Gson gson, BrokerService brokerService, VisualizerHelperService helper) {
        ArrayList brokers = brokerService.getBrokers();
        ArrayList<BrokerSeriesTemplate> distributionTxData = new ArrayList<BrokerSeriesTemplate>();
        ArrayList<BrokerSeriesTemplate> distributionTxDataOneTimeslot = new ArrayList<BrokerSeriesTemplate>();
        for (BrokerModel brokerModel : brokers) {
            ArrayList<Object[]> profitData = new ArrayList<Object[]>();
            ArrayList<Object[]> netKwhData = new ArrayList<Object[]>();
            ArrayList<Object[]> profitDataOneTimeslot = new ArrayList<Object[]>();
            ArrayList<Object[]> kwhDataOneTimeslot = new ArrayList<Object[]>();
            ConcurrentHashMap dynDataMap = brokerModel.getDistributionCategory().getDynamicDataMap();
            TreeSet dynDataSet = new TreeSet(dynDataMap.keySet());
            Iterator iterator2 = dynDataSet.iterator();
            while (iterator2.hasNext()) {
                int key = (Integer)iterator2.next();
                DynamicData dynData = (DynamicData)dynDataMap.get(key);
                Object[] profit = new Object[]{helper.getMillisForIndex(key), dynData.getProfit()};
                Object[] netMwh = new Object[]{helper.getMillisForIndex(key), dynData.getEnergy()};
                profitData.add(profit);
                netKwhData.add(netMwh);
                Object[] profitOneTimeslot = new Object[]{helper.getMillisForIndex(key), dynData.getProfitDelta()};
                Object[] kWhOneTimeslot = new Object[]{helper.getMillisForIndex(key), dynData.getEnergyDelta()};
                profitDataOneTimeslot.add(profitOneTimeslot);
                kwhDataOneTimeslot.add(kWhOneTimeslot);
            }
            if (dynDataSet.size() == 0) {
                double[] dummy = new double[]{helper.getMillisForIndex(0), 0.0};
                profitData.add(dummy);
                profitDataOneTimeslot.add(dummy);
                kwhDataOneTimeslot.add(dummy);
                netKwhData.add(dummy);
            }
            distributionTxData.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 0, profitData, true));
            distributionTxData.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 1, netKwhData, false));
            distributionTxDataOneTimeslot.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 0, profitDataOneTimeslot, true));
            distributionTxDataOneTimeslot.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 1, kwhDataOneTimeslot, false));
        }
        this.distributionDynData = gson.toJson(distributionTxData);
        this.distributionDynDataOneTimeslot = gson.toJson(distributionTxDataOneTimeslot);
    }

    public String getDistributionDynData() {
        return this.distributionDynData;
    }

    public String getDistributionDynDataOneTimeslot() {
        return this.distributionDynDataOneTimeslot;
    }
}

